/*
 * Decompiled with CFR 0.152.
 */
package com.github.blutorange.bpmnspector.common.importer;

import com.github.blutorange.bpmnspector.api.Location;
import com.github.blutorange.bpmnspector.api.LocationCoordinate;
import com.github.blutorange.bpmnspector.api.Resource;
import com.github.blutorange.bpmnspector.api.ValidationException;
import com.github.blutorange.bpmnspector.api.Violation;
import com.github.blutorange.bpmnspector.api.Warning;
import com.github.blutorange.bpmnspector.common.importer.BPMNProcess;
import com.github.blutorange.bpmnspector.validation.ValidationResultBuilder;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.io.IOUtils;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.JDOMFactory;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import org.jdom2.located.LocatedElement;
import org.jdom2.located.LocatedJDOMFactory;
import org.jdom2.xpath.XPathHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class ProcessImporter {
    private final SAXBuilder builder = new SAXBuilder();
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ProcessImporter.class.getSimpleName());

    public ProcessImporter() {
        this.builder.setJDOMFactory((JDOMFactory)new LocatedJDOMFactory());
    }

    public BPMNProcess importProcessFromPath(Path path, ValidationResultBuilder result) throws ValidationException {
        return this.importProcessFromPath(path, result, true);
    }

    public BPMNProcess importProcessFromPath(Path path, ValidationResultBuilder result, boolean removeDI) throws ValidationException {
        if (Files.notExists(path, new LinkOption[0]) || !Files.isRegularFile(path, new LinkOption[0])) {
            String msg = "BPMNProcess cannot be created: Path " + String.valueOf(path) + " is invalid.";
            throw new ValidationException(msg);
        }
        Resource resource = new Resource(path);
        return this.importProcessRecursively(resource, null, null, result, removeDI);
    }

    public BPMNProcess importProcessFromStreamSource(InputStream src, String resourceName) throws ValidationException {
        return this.importProcessFromStreamSource(src, resourceName, true);
    }

    public BPMNProcess importProcessFromStreamSource(InputStream src, String resourceName, boolean removeDI) throws ValidationException {
        try {
            Resource resource = new Resource(resourceName);
            byte[] streamContent = IOUtils.toByteArray((InputStream)src);
            Document processAsDoc = this.builder.build((InputStream)new ByteArrayInputStream(streamContent), resource.getResourceName());
            if ("definitions".equals(processAsDoc.getRootElement().getName()) && "http://www.omg.org/spec/BPMN/20100524/MODEL".equals(processAsDoc.getRootElement().getNamespaceURI())) {
                String processNamespace = processAsDoc.getRootElement().getAttributeValue("targetNamespace");
                BPMNProcess process = new BPMNProcess(processAsDoc, resourceName, processNamespace, null);
                if (removeDI) {
                    processAsDoc.getRootElement().removeChildren("BPMNDiagram", this.getBPMNDINamespace());
                }
                return process;
            }
            return null;
        }
        catch (IOException | JDOMException e) {
            throw new ValidationException("Creation of BPMNProcess for stream (" + resourceName + ") object failed.", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BPMNProcess importProcessRecursively(Resource resource, BPMNProcess parent, BPMNProcess rootProcess, ValidationResultBuilder result, boolean removeDI) throws ValidationException {
        result.addResource(resource);
        try (InputStream stream = this.openStreamToResource(resource);){
            byte[] streamContent = IOUtils.toByteArray((InputStream)stream);
            Document processAsDoc = this.builder.build((InputStream)new ByteArrayInputStream(streamContent), resource.getResourceName());
            if ("definitions".equals(processAsDoc.getRootElement().getName()) && "http://www.omg.org/spec/BPMN/20100524/MODEL".equals(processAsDoc.getRootElement().getNamespaceURI())) {
                String processNamespace = processAsDoc.getRootElement().getAttributeValue("targetNamespace");
                BPMNProcess process = new BPMNProcess(processAsDoc, resource.getResourceName(), processNamespace, parent);
                if (removeDI) {
                    processAsDoc.getRootElement().removeChildren("BPMNDiagram", this.getBPMNDINamespace());
                }
                this.resolveAndAddImports(process, Objects.requireNonNullElse(rootProcess, process), result, removeDI);
                BPMNProcess bPMNProcess = process;
                return bPMNProcess;
            }
            BPMNProcess bPMNProcess = null;
            return bPMNProcess;
        }
        catch (IOException e) {
            throw new ValidationException("Failure accessing BPMN process " + resource.getResourceName() + ".", e);
        }
    }

    private void resolveAndAddImports(BPMNProcess process, BPMNProcess rootProcess, ValidationResultBuilder result, boolean removeDI) throws ValidationException {
        List importElements = process.getProcessAsDoc().getRootElement().getChildren("import", this.getBPMNNamespace());
        block31: for (Element elem : importElements) {
            String msg;
            String importType = elem.getAttributeValue("importType");
            if (!("http://www.omg.org/spec/BPMN/20100524/MODEL".equals(importType) || "http://www.w3.org/TR/wsdl20/".equals(importType) || "http://www.w3.org/2001/XMLSchema".equals(importType))) {
                int line = ((LocatedElement)elem).getLine();
                int column = ((LocatedElement)elem).getColumn();
                String xpath = XPathHelper.getAbsolutePath((Content)elem);
                Location loc = new Location(Paths.get(process.getBaseURI(), new String[0]), new LocationCoordinate(line, column), xpath);
                result.addWarning(new Warning("The import type '" + importType + "' is not supported. Import will be ignored.", loc));
                return;
            }
            String location = elem.getAttributeValue("location");
            Resource resource = null;
            try {
                URI importUri = new URI(location);
                if (importUri.isAbsolute() && importUri.getScheme().toLowerCase().startsWith("http")) {
                    URL asURL = importUri.toURL();
                    resource = new Resource(asURL);
                } else {
                    String decodedUrlString = URLDecoder.decode(importUri.toString(), StandardCharsets.UTF_8);
                    Path importPath = Paths.get(decodedUrlString, new String[0]);
                    if (!importPath.isAbsolute()) {
                        importPath = Paths.get(process.getBaseURI(), new String[0]).getParent().resolve(importPath).normalize().toAbsolutePath();
                    }
                    if (Files.notExists(importPath, new LinkOption[0]) || !Files.isRegularFile(importPath, new LinkOption[0])) {
                        msg = "Import could not be resolved: Path " + elem.getAttributeValue("location") + " is invalid.";
                        Violation violation = this.createViolation(process, elem, msg);
                        result.addViolation(violation);
                    } else {
                        resource = new Resource(importPath);
                    }
                }
            }
            catch (MalformedURLException | URISyntaxException e) {
                String msg2 = "Import could not be resolved: Path " + location + " is invalid.";
                Violation violation = this.createViolation(process, elem, msg2);
                result.addViolation(violation);
            }
            if (resource == null) continue;
            switch (importType) {
                case "http://www.omg.org/spec/BPMN/20100524/MODEL": {
                    if (this.isFileAlreadyImported(resource.getResourceName(), rootProcess)) break;
                    try {
                        BPMNProcess importedProcess = this.importProcessRecursively(resource, process, rootProcess, result, removeDI);
                        if (importedProcess == null) continue block31;
                        process.getChildren().add(importedProcess);
                    }
                    catch (ValidationException e) {
                        result.addViolation(this.createViolation(process, elem, e.getMessage()));
                    }
                    break;
                }
                case "http://www.w3.org/TR/wsdl20/": {
                    InputStream stream;
                    try {
                        stream = this.openStreamToResource(resource);
                        try {
                            result.addResource(resource);
                            process.getWsdls().add(this.builder.build(stream));
                            continue block31;
                        }
                        finally {
                            if (stream == null) continue block31;
                            stream.close();
                            continue block31;
                        }
                    }
                    catch (ValidationException e) {
                        result.addViolation(this.createViolation(process, elem, e.getMessage()));
                        break;
                    }
                    catch (IOException | JDOMException e) {
                        throw new ValidationException("WSDL validation of file " + resource.getResourceName() + " failed.", e);
                    }
                }
                case "http://www.w3.org/2001/XMLSchema": {
                    InputStream stream;
                    try {
                        stream = this.openStreamToResource(resource);
                        try {
                            result.addResource(resource);
                            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                            schemaFactory.newSchema(new StreamSource(stream));
                            continue block31;
                        }
                        finally {
                            if (stream == null) continue block31;
                            stream.close();
                            continue block31;
                        }
                    }
                    catch (ValidationException e) {
                        result.addViolation(this.createViolation(process, elem, e.getMessage()));
                        break;
                    }
                    catch (SAXException e) {
                        msg = "File " + resource.getResourceName() + " is not a valid XSD file.";
                        result.addViolation(this.createViolation(process, elem, msg));
                        break;
                    }
                    catch (IOException e) {
                        throw new ValidationException("XSD file check for  " + resource.getResourceName() + " failed.", e);
                    }
                }
            }
        }
    }

    private Namespace getBPMNNamespace() {
        return Namespace.getNamespace((String)"http://www.omg.org/spec/BPMN/20100524/MODEL");
    }

    private Namespace getBPMNDINamespace() {
        return Namespace.getNamespace((String)"http://www.omg.org/spec/BPMN/20100524/DI");
    }

    private Violation createViolation(BPMNProcess parent, Element importElement, String msg) {
        int line = ((LocatedElement)importElement).getLine();
        int column = ((LocatedElement)importElement).getColumn();
        String xpath = XPathHelper.getAbsolutePath((Content)importElement);
        Location location = new Location(Paths.get(parent.getBaseURI(), new String[0]), new LocationCoordinate(line, column), xpath);
        return new Violation(location, msg, "EXT.001");
    }

    private boolean isFileAlreadyImported(String baseURI, BPMNProcess process) {
        if (process.getBaseURI().equals(baseURI)) {
            return true;
        }
        for (BPMNProcess child : process.getChildren()) {
            if (!this.isFileAlreadyImported(baseURI, child)) continue;
            return true;
        }
        return false;
    }

    private InputStream openStreamToResource(Resource resource) throws ValidationException, IOException {
        if (resource.getType() == Resource.ResourceType.URL) {
            LOGGER.debug("Trying to openStream to: {}", (Object)resource.getResourceName());
            try {
                return resource.getUrl().orElseThrow().openConnection().getInputStream();
            }
            catch (UnknownHostException e) {
                throw new ValidationException("Host " + e.getMessage() + " is unknown.", e);
            }
            catch (FileNotFoundException e) {
                throw new ValidationException("File cannot be resolved from URL: " + e.getMessage(), e);
            }
        }
        if (resource.getType() == Resource.ResourceType.FILE) {
            return new FileInputStream(resource.getPath().orElseThrow().toFile());
        }
        throw new IllegalArgumentException("Import processing of resource type " + String.valueOf((Object)resource.getType()) + " is not supported.");
    }
}

