/*
 * Decompiled with CFR 0.152.
 */
package com.github.blutorange.bpmnspector.common.util;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)FileUtils.class.getSimpleName());

    public static List<Path> getAllBpmnFileFromDirectory(Path directory) {
        FileUtils.assertDirectory(directory);
        final ArrayList<Path> bpmnFiles = new ArrayList<Path>();
        try {
            Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (FileSystems.getDefault().getPathMatcher("glob:**/*.{bpmn,bpmn2,bpmn20.xml}").matches(file)) {
                        bpmnFiles.add(file);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            LOGGER.error("IOException while traversing folder.", (Throwable)e);
        }
        return bpmnFiles;
    }

    public static void assertDirectory(Path path) {
        if (!Files.isDirectory(path, new LinkOption[0])) {
            throw new IllegalArgumentException("Path " + String.valueOf(path.toAbsolutePath()) + " is no directory.");
        }
    }
}

