/*
 * Decompiled with CFR 0.152.
 */
package com.github.blutorange.bpmnspector.common.util;

import com.github.blutorange.bpmnspector.api.Resource;
import com.github.blutorange.bpmnspector.api.ValidationException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class ResourceUtils {
    public static Resource determineAndCreateResourceFromString(String location, String baseLocation) throws ValidationException {
        try {
            Resource resource;
            URI importUri = new URI(location);
            if (importUri.isAbsolute() && importUri.getScheme().toLowerCase().startsWith("http")) {
                URL asURL = importUri.toURL();
                resource = new Resource(asURL);
            } else {
                Path importPath = Paths.get(importUri);
                if (!importPath.isAbsolute() && baseLocation != null) {
                    importPath = Paths.get(baseLocation, new String[0]).getParent().resolve(importPath).normalize().toAbsolutePath();
                }
                if (Files.notExists(importPath, new LinkOption[0]) || !Files.isRegularFile(importPath, new LinkOption[0])) {
                    throw new ValidationException("File does not exist.");
                }
                resource = new Resource(importPath);
            }
            return resource;
        }
        catch (MalformedURLException | URISyntaxException | InvalidPathException e) {
            throw new ValidationException("Path " + location + " is invalid.", e);
        }
    }
}

