/*
 * Decompiled with CFR 0.152.
 */
package com.github.blutorange.bpmnspector.refcheck;

import com.github.blutorange.bpmnspector.api.ValidationException;
import com.github.blutorange.bpmnspector.api.Violation;
import com.github.blutorange.bpmnspector.common.importer.BPMNProcess;
import com.github.blutorange.bpmnspector.refcheck.BPMNElement;
import com.github.blutorange.bpmnspector.refcheck.Reference;
import com.github.blutorange.bpmnspector.refcheck.ReferenceChecker;
import com.github.blutorange.bpmnspector.refcheck.ReferenceLoader;
import com.github.blutorange.bpmnspector.refcheck.utils.JDOMUtils;
import com.github.blutorange.bpmnspector.validation.BpmnProcessValidator;
import com.github.blutorange.bpmnspector.validation.ValidationResultBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.filter.Filter;
import org.jdom2.filter.Filters;
import org.jdom2.located.LocatedElement;
import org.jdom2.util.IteratorIterable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BPMNReferenceValidator
implements BpmnProcessValidator {
    private Map<String, BPMNElement> bpmnRefElements;
    private final ReferenceChecker referenceChecker;
    private static final String RESULT_TEXT_TEMPLATE = "Reference check of file %s finished; %d violations found.";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)BPMNReferenceValidator.class.getSimpleName());

    public BPMNReferenceValidator() throws ValidationException {
        this.loadReferences();
        this.referenceChecker = new ReferenceChecker(this.bpmnRefElements);
    }

    @Override
    public void validate(BPMNProcess process, ValidationResultBuilder validationResult) throws ValidationException {
        Objects.requireNonNull(process, "process must not be null.");
        Objects.requireNonNull(validationResult, "validationResult must not be null.");
        try {
            ArrayList<BPMNProcess> processesToCheck = new ArrayList<BPMNProcess>();
            process.getAllProcessesRecursively(processesToCheck);
            for (BPMNProcess processToCheck : processesToCheck) {
                this.startValidation(processToCheck, validationResult);
            }
            String resultText = String.format(RESULT_TEXT_TEMPLATE, process.getBaseURI(), validationResult.getViolations().size());
            LOGGER.debug(resultText);
        }
        catch (ValidationException e) {
            LOGGER.error("Validation of process {} failed, due to an error: {}", (Object)process.getBaseURI(), (Object)e);
        }
    }

    private void loadReferences() throws ValidationException {
        ReferenceLoader referenceLoader = new ReferenceLoader();
        this.bpmnRefElements = referenceLoader.load("/com/github/blutorange/bpmnspector/resources/references.xml", "/com/github/blutorange/bpmnspector/resources/references.xsd");
        StringBuilder bpmnElementsLogText = new StringBuilder(500);
        bpmnElementsLogText.append("Imported BPMNElements: ");
        for (String key : this.bpmnRefElements.keySet()) {
            bpmnElementsLogText.append(String.format("%s :: %s", key, this.bpmnRefElements.get(key)));
            bpmnElementsLogText.append(System.lineSeparator());
        }
        LOGGER.debug(bpmnElementsLogText.toString());
    }

    private void startValidation(BPMNProcess baseProcess, ValidationResultBuilder validationResult) throws ValidationException {
        LOGGER.debug("Starting to process {} :", (Object)baseProcess.getBaseURI());
        Document baseDocument = baseProcess.getProcessAsDoc();
        Map<String, Element> elements = JDOMUtils.getAllElements(baseDocument);
        String ownPrefix = "";
        Element rootNode = baseDocument.getRootElement();
        String targetNamespace = rootNode.getAttributeValue("targetNamespace");
        if (targetNamespace != null) {
            for (Namespace namespace : rootNode.getNamespacesInScope()) {
                if (!targetNamespace.equals(namespace.getURI())) continue;
                ownPrefix = namespace.getPrefix();
                break;
            }
        }
        LOGGER.debug("ownprefix after getAllElements():{}", (Object)ownPrefix);
        HashMap<String, Map<String, Element>> importedElements = new HashMap<String, Map<String, Element>>();
        JDOMUtils.getAllElementsGroupedByNamespace(importedElements, baseProcess, new ArrayList<String>());
        StringBuilder importedFilesLogText = new StringBuilder(100).append("Elements found by namespace: ").append(System.lineSeparator());
        for (Map.Entry entry : importedElements.entrySet()) {
            importedFilesLogText.append("Namespace prefix: ").append((String)entry.getKey()).append(System.lineSeparator()).append(entry.getValue()).append(System.lineSeparator());
        }
        LOGGER.debug(importedFilesLogText.toString());
        Filter filter = Filters.element();
        IteratorIterable list = baseDocument.getDescendants(filter);
        while (list.hasNext()) {
            Element currentElement = (Element)list.next();
            String currentName = currentElement.getName();
            if (!this.bpmnRefElements.containsKey(currentName)) continue;
            for (Reference checkingReference : this.bpmnRefElements.get(currentName).getReferences()) {
                String referencedId = null;
                int line = -1;
                int column = -1;
                if (checkingReference.isAttribute()) {
                    referencedId = currentElement.getAttributeValue(checkingReference.getName());
                    line = ((LocatedElement)currentElement).getLine();
                    column = ((LocatedElement)currentElement).getColumn();
                } else {
                    for (Element child : currentElement.getChildren()) {
                        if (!child.getName().equals(checkingReference.getName())) continue;
                        referencedId = child.getText();
                        line = ((LocatedElement)child).getLine();
                        column = ((LocatedElement)child).getColumn();
                        break;
                    }
                }
                if (referencedId == null) continue;
                LOGGER.debug("Checking the Reference: {} :: {}", (Object)currentName, (Object)checkingReference.getName());
                this.referenceChecker.validateReferenceType(elements, importedElements, validationResult, currentElement, line, column, checkingReference, referencedId, ownPrefix);
            }
        }
        if (!validationResult.isValid()) {
            StringBuilder violationListLogText = new StringBuilder("VIOLATIONS_LIST:").append(System.lineSeparator());
            for (Violation violation : validationResult.getViolations()) {
                violationListLogText.append(violation.getMessage()).append(System.lineSeparator());
            }
            LOGGER.debug(violationListLogText.toString());
        }
    }
}

