/*
 * Decompiled with CFR 0.152.
 */
package com.github.blutorange.bpmnspector.refcheck;

import com.github.blutorange.bpmnspector.api.Location;
import com.github.blutorange.bpmnspector.api.LocationCoordinate;
import com.github.blutorange.bpmnspector.api.ValidationException;
import com.github.blutorange.bpmnspector.api.Violation;
import com.github.blutorange.bpmnspector.refcheck.BPMNElement;
import com.github.blutorange.bpmnspector.refcheck.Reference;
import com.github.blutorange.bpmnspector.refcheck.utils.ViolationMessageCreator;
import com.github.blutorange.bpmnspector.validation.ValidationResultBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.xpath.XPathHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferenceChecker {
    public static final String CONSTRAINT_REF_TYPE = "REF_TYPE";
    public static final String CONSTRAINT_REF_EXISTENCE = "REF_EXISTENCE";
    private final Map<String, BPMNElement> bpmnRefElements;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ReferenceChecker.class.getSimpleName());

    public ReferenceChecker(Map<String, BPMNElement> bpmnRefElements) {
        this.bpmnRefElements = bpmnRefElements;
    }

    public void validateReferenceType(Map<String, Element> elements, Map<String, Map<String, Element>> importedElements, ValidationResultBuilder validationResult, Element currentElement, int line, int column, Reference checkingReference, String referencedId, String ownPrefix) throws ValidationException {
        if (checkingReference.isQname()) {
            if (referencedId.contains(":")) {
                String[] parts = referencedId.split(":");
                String prefix = parts[0];
                String importedId = parts[1];
                String namespace = "";
                for (Namespace nsp : currentElement.getNamespacesInScope()) {
                    if (!nsp.getPrefix().equals(prefix)) continue;
                    namespace = nsp.getURI();
                    break;
                }
                Map<String, Element> relevantImportedElements = importedElements.get(namespace);
                if (ownPrefix.equals(prefix)) {
                    if (elements.containsKey(importedId)) {
                        this.checkTypeAndAddViolation(validationResult, line, column, currentElement, checkingReference, elements.get(importedId));
                    } else if (relevantImportedElements != null && relevantImportedElements.containsKey(importedId)) {
                        this.checkTypeAndAddViolation(validationResult, line, column, currentElement, checkingReference, relevantImportedElements.get(importedId));
                    } else {
                        this.createAndAddExistenceViolation(validationResult, line, column, currentElement, checkingReference);
                    }
                } else if (relevantImportedElements != null) {
                    if (relevantImportedElements.containsKey(importedId)) {
                        this.checkTypeAndAddViolation(validationResult, line, column, currentElement, checkingReference, relevantImportedElements.get(importedId));
                    } else {
                        this.createAndAddExistenceViolation(validationResult, line, column, currentElement, checkingReference);
                    }
                } else {
                    this.createAndAddExistenceViolation(validationResult, line, column, currentElement, checkingReference);
                }
            } else if (elements.containsKey(referencedId)) {
                this.checkTypeAndAddViolation(validationResult, line, column, currentElement, checkingReference, elements.get(referencedId));
            } else {
                this.createAndAddExistenceViolation(validationResult, line, column, currentElement, checkingReference);
            }
        } else if (elements.containsKey(referencedId)) {
            this.checkTypeAndAddViolation(validationResult, line, column, currentElement, checkingReference, elements.get(referencedId));
        } else {
            this.createAndAddExistenceViolation(validationResult, line, column, currentElement, checkingReference);
        }
    }

    private void checkTypeAndAddViolation(ValidationResultBuilder validationResult, int line, int column, Element currentElement, Reference checkingReference, Element referencedElement) throws ValidationException {
        boolean validType = false;
        List<String> referencedTypes = checkingReference.getTypes();
        if (referencedTypes != null) {
            boolean childFound;
            ArrayList<String> types = new ArrayList<String>(referencedTypes);
            do {
                childFound = false;
                ArrayList<String> typesCopy = new ArrayList<String>(types);
                for (String type : typesCopy) {
                    BPMNElement bpmnElement;
                    List<String> children;
                    if (!this.bpmnRefElements.containsKey(type) || (children = (bpmnElement = this.bpmnRefElements.get(type)).getChildren()) == null) continue;
                    for (String child : children) {
                        if (typesCopy.contains(child)) continue;
                        types.add(child);
                        childFound = true;
                    }
                }
            } while (childFound);
            for (String type : types) {
                if (!referencedElement.getName().equals(type)) continue;
                validType = true;
                break;
            }
            if (!validType) {
                this.createAndAddReferenceTypeViolation(validationResult, line, column, currentElement, checkingReference, referencedElement, types);
            }
        }
    }

    private void createAndAddReferenceTypeViolation(ValidationResultBuilder validationResult, int line, int column, Element currentElement, Reference checkingReference, Element referencedElement, List<String> types) throws ValidationException {
        String message = ViolationMessageCreator.createTypeViolationMessage(currentElement.getName(), line, checkingReference.getName(), referencedElement.getName(), types.toString());
        Violation violation = new Violation(this.createLocation(line, column, currentElement), message, CONSTRAINT_REF_TYPE);
        validationResult.addViolation(violation);
    }

    public void createAndAddExistenceViolation(ValidationResultBuilder validationResult, int line, int column, Element currentElement, Reference checkingReference) throws ValidationException {
        String message = ViolationMessageCreator.createExistenceViolationMessage(currentElement.getName(), checkingReference.getName(), line, 0, XPathHelper.getAbsolutePath((Content)currentElement));
        Violation violation = new Violation(this.createLocation(line, column, currentElement), message, CONSTRAINT_REF_EXISTENCE);
        validationResult.addViolation(violation);
    }

    private Location createLocation(int line, int column, Element currentElement) throws ValidationException {
        try {
            URI baseUri = currentElement.getXMLBaseURI();
            Path locationPath = Paths.get(baseUri);
            return new Location(locationPath, new LocationCoordinate(line, column));
        }
        catch (URISyntaxException e) {
            throw new ValidationException("Base URI of current element " + currentElement.getName() + " could not be restored.", e);
        }
    }
}

