/*
 * Decompiled with CFR 0.152.
 */
package com.github.blutorange.bpmnspector.refcheck;

import com.github.blutorange.bpmnspector.api.ValidationException;
import com.github.blutorange.bpmnspector.refcheck.BPMNElement;
import com.github.blutorange.bpmnspector.refcheck.Reference;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ReferenceLoader {
    private final List<SAXParseException> xsdErrorList = new ArrayList<SAXParseException>();

    public Map<String, BPMNElement> load(String referencesPath, String xsdPath) throws ValidationException {
        HashMap<String, BPMNElement> hashMap;
        block9: {
            InputStream refPathStream = this.getClass().getResourceAsStream(referencesPath);
            try {
                this.validateReferencesFile(referencesPath, xsdPath);
                Document document = new SAXBuilder().build(refPathStream);
                Element root = document.getRootElement();
                HashMap<String, BPMNElement> bpmnElements = new HashMap<String, BPMNElement>();
                List elems = root.getChildren();
                for (Element elem : elems) {
                    if (elem.getChild("parent") != null || bpmnElements.containsKey(elem.getAttributeValue("name"))) continue;
                    this.createBPMNElementAndReferences(root, elem, bpmnElements, new ArrayList<Reference>());
                }
                hashMap = bpmnElements;
                if (refPathStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (refPathStream != null) {
                        try {
                            refPathStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | JDOMException e) {
                    throw new ValidationException("Problems occurred while traversing the file '" + referencesPath + "'", e);
                }
            }
            refPathStream.close();
        }
        return hashMap;
    }

    private void createBPMNElementAndReferences(Element rootElem, Element elementToAdd, Map<String, BPMNElement> processedElements, List<Reference> referencesFromParent) {
        String elementName = elementToAdd.getAttributeValue("name");
        String parent = elementToAdd.getChildText("parent");
        ArrayList<Reference> references = new ArrayList<Reference>(referencesFromParent);
        this.createReferencesOfElement(elementToAdd, references);
        ArrayList<String> children = null;
        List childElements = elementToAdd.getChildren("child");
        if (!childElements.isEmpty()) {
            children = new ArrayList<String>();
            for (Element child : childElements) {
                children.add(child.getText());
                this.createBPMNElementAndReferencesForChild(rootElem, child.getText(), elementName, processedElements, references);
            }
        }
        BPMNElement bpmnElement = new BPMNElement(elementName, parent, children, references);
        processedElements.put(elementName, bpmnElement);
    }

    private void createBPMNElementAndReferencesForChild(Element rootElem, String nameOfChild, String nameOfParent, Map<String, BPMNElement> processedElements, List<Reference> referencesFromParent) {
        Optional<Element> childToProcess = rootElem.getChildren("element").stream().filter(element -> nameOfChild.equals(element.getAttributeValue("name"))).findAny();
        if (childToProcess.isPresent()) {
            this.createBPMNElementAndReferences(rootElem, childToProcess.get(), processedElements, referencesFromParent);
        } else {
            processedElements.put(nameOfChild, new BPMNElement(nameOfChild, nameOfParent, null, referencesFromParent));
        }
    }

    private void createReferencesOfElement(Element element, List<Reference> referenceList) {
        List referencesInFile = element.getChildren("reference");
        for (Element reference : referencesInFile) {
            int number = Integer.parseInt(reference.getAttributeValue("number"));
            String referenceName = reference.getChild("name").getText();
            ArrayList<String> types = null;
            List typesInFile = reference.getChildren("type");
            if (!typesInFile.isEmpty()) {
                types = new ArrayList<String>();
                for (Element type : typesInFile) {
                    types.add(type.getText());
                }
            }
            boolean qname = this.convertToBoolean(reference.getAttributeValue("qname"));
            boolean attribute = this.convertToBoolean(reference.getAttributeValue("attribute"));
            Reference bpmnReference = new Reference(number, referenceName, types, qname, attribute);
            referenceList.add(bpmnReference);
        }
    }

    private void validateReferencesFile(String referencesPath, String xsdPath) throws ValidationException, IOException {
        try (InputStream refPathStream = this.getClass().getResourceAsStream(referencesPath);
             InputStream xsdPathStream = this.getClass().getResourceAsStream(xsdPath);){
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(new StreamSource(xsdPathStream));
            Validator validator = schema.newValidator();
            validator.setErrorHandler(new XSDValidationLoggingErrorHandler());
            validator.validate(new StreamSource(refPathStream));
            if (!this.xsdErrorList.isEmpty()) {
                StringBuilder xsdErrorText = new StringBuilder(200).append("While the XSD validation of the 'references.xml' file the following errors occurred:").append(System.lineSeparator());
                for (SAXParseException saxParseException : this.xsdErrorList) {
                    xsdErrorText.append("line: ").append(saxParseException.getLineNumber()).append(':').append(saxParseException.getMessage()).append(System.lineSeparator());
                }
                throw new ValidationException(xsdErrorText.toString());
            }
        }
        catch (SAXException e) {
            throw new ValidationException("Problems occurred while trying to check the references XML file against the corresponding XSD file.", e);
        }
    }

    private boolean convertToBoolean(String string) {
        return "true".equals(string);
    }

    private class XSDValidationLoggingErrorHandler
    implements ErrorHandler {
        private XSDValidationLoggingErrorHandler() {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            ReferenceLoader.this.xsdErrorList.add(exception);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            ReferenceLoader.this.xsdErrorList.add(exception);
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            ReferenceLoader.this.xsdErrorList.add(exception);
        }
    }
}

