/*
 * Decompiled with CFR 0.152.
 */
package com.github.blutorange.bpmnspector.refcheck.utils;

import com.github.blutorange.bpmnspector.common.importer.BPMNProcess;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.filter.Filter;
import org.jdom2.filter.Filters;
import org.jdom2.util.IteratorIterable;

public class JDOMUtils {
    public static Map<String, Element> getAllElements(Document document) {
        HashMap<String, Element> elements = new HashMap<String, Element>();
        Element rootNode = document.getRootElement();
        Filter filter = Filters.element();
        IteratorIterable list = rootNode.getDescendants(filter);
        while (list.hasNext()) {
            String idValue;
            Element element = (Element)list.next();
            Attribute id = element.getAttribute("id");
            if (id == null || (idValue = id.getValue()) == null || idValue.isEmpty()) continue;
            elements.put(idValue, element);
        }
        return elements;
    }

    public static void getAllElementsGroupedByNamespace(Map<String, Map<String, Element>> elementsMap, BPMNProcess process, List<String> alreadyVisited) {
        if (!alreadyVisited.contains(process.getBaseURI())) {
            JDOMUtils.addElementsFromSingleDocument(elementsMap, process.getProcessAsDoc());
            alreadyVisited.add(process.getBaseURI());
            for (BPMNProcess child : process.getChildren()) {
                JDOMUtils.getAllElementsGroupedByNamespace(elementsMap, child, alreadyVisited);
            }
        }
    }

    private static void addElementsFromSingleDocument(Map<String, Map<String, Element>> groupedElements, Document doc) {
        String targetNamespace = doc.getRootElement().getAttributeValue("targetNamespace");
        Map<String, Element> docElements = JDOMUtils.getAllElements(doc);
        if (groupedElements.containsKey(targetNamespace)) {
            Map<String, Element> previousElems = groupedElements.get(targetNamespace);
            previousElems.putAll(docElements);
        } else {
            groupedElements.put(targetNamespace, docElements);
        }
    }

    public static Optional<String> getUsedPrefixForTargetNamespace(Document document) {
        Element rootElem = document.getRootElement();
        String targetNamespaceURI = rootElem.getAttributeValue("targetNamespace");
        Optional<Namespace> namespaceForTargetNamespace = rootElem.getNamespacesInScope().stream().filter(n -> n.getURI().equals(targetNamespaceURI)).findAny();
        if (namespaceForTargetNamespace.isPresent()) {
            return Optional.of(namespaceForTargetNamespace.get().getPrefix());
        }
        return Optional.empty();
    }
}

