/*
 * Decompiled with CFR 0.152.
 */
package com.github.blutorange.bpmnspector.schematron;

import com.github.blutorange.bpmnspector.api.Location;
import com.github.blutorange.bpmnspector.api.LocationCoordinate;
import com.github.blutorange.bpmnspector.api.ValidationException;
import com.github.blutorange.bpmnspector.api.Violation;
import com.github.blutorange.bpmnspector.api.Warning;
import com.github.blutorange.bpmnspector.common.importer.BPMNProcess;
import com.github.blutorange.bpmnspector.common.importer.ProcessImporter;
import com.github.blutorange.bpmnspector.common.util.ConstantHelper;
import com.github.blutorange.bpmnspector.schematron.Ext002Checker;
import com.github.blutorange.bpmnspector.schematron.preprocessing.PreProcessor;
import com.github.blutorange.bpmnspector.validation.BpmnProcessValidator;
import com.github.blutorange.bpmnspector.validation.UnsortedValidationResult;
import com.github.blutorange.bpmnspector.validation.ValidationResultBuilder;
import com.helger.schematron.ISchematronResource;
import com.helger.schematron.pure.SchematronResourcePure;
import com.helger.schematron.pure.xpath.IXPathConfig;
import com.helger.schematron.pure.xpath.XPathConfig;
import com.helger.schematron.svrl.SVRLHelper;
import com.helger.schematron.svrl.jaxb.DiagnosticReference;
import com.helger.schematron.svrl.jaxb.Dir;
import com.helger.schematron.svrl.jaxb.Emph;
import com.helger.schematron.svrl.jaxb.FailedAssert;
import com.helger.schematron.svrl.jaxb.SchematronOutputType;
import com.helger.schematron.svrl.jaxb.Span;
import com.helger.schematron.svrl.jaxb.Text;
import java.io.File;
import java.lang.reflect.Method;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.filter.Filters;
import org.jdom2.located.LocatedElement;
import org.jdom2.output.DOMOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchematronBPMNValidator
implements BpmnProcessValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)SchematronBPMNValidator.class.getSimpleName());
    private static final Pattern XPATH_ELEM_NUMBER_REGEX = Pattern.compile("(.*)\\[(\\d*)]");
    private final ProcessImporter bpmnImporter;
    private final Ext002Checker ext002Checker;
    private final PreProcessor preProcessor = new PreProcessor();
    private final List<ISchematronResource> schemaToCheck;

    public SchematronBPMNValidator() throws ValidationException {
        this.bpmnImporter = new ProcessImporter();
        this.ext002Checker = new Ext002Checker();
        this.schemaToCheck = this.loadAndValidateSchematronFiles();
    }

    public ValidationResultBuilder validate(File xmlFile) throws ValidationException {
        UnsortedValidationResult validationResult = new UnsortedValidationResult();
        BPMNProcess process = this.bpmnImporter.importProcessFromPath(Paths.get(xmlFile.getPath(), new String[0]), validationResult);
        if (process != null) {
            this.validate(process, validationResult);
        }
        return validationResult;
    }

    @Override
    public void validate(BPMNProcess process, ValidationResultBuilder validationResult) throws ValidationException {
        LOGGER.debug("Validating {}", (Object)process.getBaseURI());
        try {
            if (!process.getChildren().isEmpty()) {
                this.ext002Checker.checkConstraint002(process, validationResult);
            }
            Document documentToCheck = this.preProcessor.preProcess(process);
            DOMOutputter domOutputter = new DOMOutputter();
            org.w3c.dom.Document w3cDoc = domOutputter.output(documentToCheck);
            DOMSource domSource = new DOMSource(w3cDoc);
            for (ISchematronResource schematronFile : this.schemaToCheck) {
                SchematronOutputType schematronOutputType = schematronFile.applySchematronValidationToSVRL((Source)domSource);
                if (schematronOutputType == null) continue;
                schematronOutputType.getActivePatternAndFiredRuleAndFailedAssert().stream().filter(FailedAssert.class::isInstance).map(FailedAssert.class::cast).forEach(obj -> this.handleSchematronErrors(process, validationResult, (FailedAssert)obj));
            }
        }
        catch (Exception e) {
            LOGGER.debug("exception during schematron validation", (Throwable)e);
            throw new ValidationException("Something went wrong during schematron validation!");
        }
        LOGGER.debug("Validating process successfully done, file is valid: {}", (Object)validationResult.isValid());
    }

    public List<ValidationResultBuilder> validateFiles(List<File> xmlFiles) throws ValidationException {
        ArrayList<ValidationResultBuilder> validationResults = new ArrayList<ValidationResultBuilder>();
        for (File xmlFile : xmlFiles) {
            validationResults.add(this.validate(xmlFile));
        }
        return validationResults;
    }

    private XPathConfig createXPathConfig() throws ValidationException {
        try {
            XPathFactory xpathFactory;
            block5: {
                xpathFactory = XPathFactory.newInstance("http://java.sun.com/jaxp/xpath/dom");
                try {
                    Method setProperty = XPathFactory.class.getMethod("setProperty", String.class, String.class);
                    setProperty.invoke((Object)xpathFactory, "jdk.xml.xpathExprOpLimit", "600");
                    setProperty.invoke((Object)xpathFactory, "jdk.xml.xpathExprGrpLimit", "30");
                }
                catch (NoSuchMethodException e) {
                    int exprOpLimit = this.getNumericalSystemProperty("jdk.xml.xpathExprOpLimit", 100);
                    int exprGrpLimit = this.getNumericalSystemProperty("jdk.xml.xpathExprGrpLimit", 10);
                    if (exprOpLimit < 600) {
                        throw new ValidationException("The system property 'jdk.xml.xpathExprOpLimit' must be at least 600");
                    }
                    if (exprGrpLimit >= 30) break block5;
                    throw new ValidationException("The system property 'jdk.xml.xpathExprGrpLimit' must be at least 30");
                }
            }
            xpathFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            return new XPathConfig(xpathFactory, null, null);
        }
        catch (ReflectiveOperationException | XPathFactoryConfigurationException e) {
            throw new ValidationException("Could not create XPathFactory", e);
        }
    }

    private int getNumericalSystemProperty(String name, int defaultValue) {
        String value = System.getProperty(name);
        try {
            return value != null && !value.isEmpty() ? Integer.parseInt(value) : defaultValue;
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private void handleSchematronErrors(BPMNProcess baseProcess, ValidationResultBuilder validationResult, FailedAssert failedAssert) {
        String logText;
        String message = SchematronBPMNValidator.textToString(SVRLHelper.getText((FailedAssert)failedAssert)).trim();
        String constraint = message.substring(0, message.indexOf(124));
        String errorMessage = message.substring(message.indexOf(124) + 1);
        Location violationLocation = null;
        String location = failedAssert.getLocation();
        LOGGER.debug("XPath to evaluate: {}", (Object)location);
        org.jdom2.xpath.XPathFactory fac = org.jdom2.xpath.XPathFactory.instance();
        Element foundElem = (Element)fac.compile(location, Filters.element(), null, new Namespace[]{ConstantHelper.BPMN_NAMESPACE}).evaluateFirst((Object)baseProcess.getProcessAsDoc());
        if (foundElem != null) {
            int line = ((LocatedElement)foundElem).getLine();
            int column = ((LocatedElement)foundElem).getColumn();
            String fileName = baseProcess.getBaseURI();
            violationLocation = new Location(Paths.get(fileName, new String[0]).toAbsolutePath(), new LocationCoordinate(line, column), location);
            logText = String.format("violation of constraint %s found in %s at line %s.", constraint, violationLocation.getResource(), violationLocation.getLocation().getRow());
        } else {
            try {
                String xpathId = "";
                if (failedAssert.getDiagnosticReferenceOrPropertyReferenceOrTextCount() > 0) {
                    String firstId = SVRLHelper.getAllDiagnosticReferences((FailedAssert)failedAssert).stream().map(DiagnosticReference::getContent).flatMap(Collection::stream).filter(Text.class::isInstance).map(Text.class::cast).map(SchematronBPMNValidator::textToString).findFirst().orElse("");
                    xpathId = firstId.trim();
                }
                LOGGER.debug("Trying to locate in files: {}", (Object)xpathId);
                violationLocation = this.searchForViolationFile(xpathId, baseProcess);
                logText = String.format("violation of constraint %s found in %s at line %s.", constraint, violationLocation.getResource(), violationLocation.getLocation().getRow());
            }
            catch (ValidationException | StringIndexOutOfBoundsException e) {
                LOGGER.error("Line of affected Element could not be determined.", (Throwable)e);
                logText = String.format("Found violation of constraint %s but the correct location could not be determined.", constraint);
            }
        }
        LOGGER.debug(logText);
        if ("EXT.076".equals(constraint)) {
            Warning warning = new Warning(errorMessage, violationLocation);
            validationResult.addWarning(warning);
        } else {
            Violation violation = new Violation(violationLocation, errorMessage, constraint);
            validationResult.addViolation(violation);
        }
    }

    private List<ISchematronResource> loadAndValidateSchematronFiles() throws ValidationException {
        ArrayList<ISchematronResource> schemasToCheck = new ArrayList<ISchematronResource>();
        XPathConfig xpathConfig = this.createXPathConfig();
        SchematronResourcePure schematronSchemaDescriptive = SchematronResourcePure.fromClassPath((String)"com/github/blutorange/bpmnspector/resources/EXT_descriptive.xml");
        schematronSchemaDescriptive.setXPathConfig((IXPathConfig)xpathConfig);
        if (!schematronSchemaDescriptive.isValidSchematron()) {
            LOGGER.debug("schematron file for Descriptive Conformance class is invalid");
            throw new ValidationException("Invalid Schematron file (EXT_descriptive.xml)!");
        }
        schemasToCheck.add((ISchematronResource)schematronSchemaDescriptive);
        SchematronResourcePure schematronSchemaAnalytic = SchematronResourcePure.fromClassPath((String)"com/github/blutorange/bpmnspector/resources/EXT_analytic.xml");
        schematronSchemaAnalytic.setXPathConfig((IXPathConfig)xpathConfig);
        if (!schematronSchemaAnalytic.isValidSchematron()) {
            LOGGER.debug("schematron file for Analytic Conformance class is invalid");
            throw new ValidationException("Invalid Schematron file (EXT_analytic.xml)!");
        }
        schemasToCheck.add((ISchematronResource)schematronSchemaAnalytic);
        SchematronResourcePure schematronSchemaCommonExec = SchematronResourcePure.fromClassPath((String)"com/github/blutorange/bpmnspector/resources/EXT_commonExec.xml");
        schematronSchemaCommonExec.setXPathConfig((IXPathConfig)xpathConfig);
        if (!schematronSchemaCommonExec.isValidSchematron()) {
            LOGGER.debug("schematron file for Common Executable Conformance class is invalid");
            throw new ValidationException("Invalid Schematron file (EXT_commonExec.xml)!");
        }
        schemasToCheck.add((ISchematronResource)schematronSchemaCommonExec);
        SchematronResourcePure schematronSchemaFull = SchematronResourcePure.fromClassPath((String)"com/github/blutorange/bpmnspector/resources/EXT_full.xml");
        schematronSchemaFull.setXPathConfig((IXPathConfig)xpathConfig);
        if (!schematronSchemaFull.isValidSchematron()) {
            LOGGER.debug("schematron file for Full Conformance class is invalid");
            throw new ValidationException("Invalid Schematron file (EXT_full.xml)!");
        }
        schemasToCheck.add((ISchematronResource)schematronSchemaFull);
        return schemasToCheck;
    }

    private Location searchForViolationFile(String xpathExpression, BPMNProcess baseProcess) throws ValidationException {
        String namespacePrefix = xpathExpression.substring(0, xpathExpression.indexOf(95));
        Optional<BPMNProcess> optional = baseProcess.findProcessByGeneratedPrefix(namespacePrefix);
        if (optional.isPresent()) {
            String fileName = optional.get().getBaseURI();
            int line = -1;
            int column = -1;
            String xpathObjectId = SchematronBPMNValidator.createIdBpmnExpression(xpathExpression);
            LOGGER.debug("Expression to evaluate: {}", (Object)xpathObjectId);
            org.jdom2.xpath.XPathFactory fac = org.jdom2.xpath.XPathFactory.instance();
            List elems = fac.compile(xpathObjectId, Filters.element(), null, new Namespace[]{ConstantHelper.BPMN_NAMESPACE}).evaluate((Object)optional.get().getProcessAsDoc());
            if (elems.size() == 1) {
                line = ((LocatedElement)elems.get(0)).getLine();
                column = ((LocatedElement)elems.get(0)).getColumn();
                xpathObjectId = SchematronBPMNValidator.createIdBpmnExpression(xpathExpression.substring(xpathExpression.indexOf(95) + 1));
            }
            if (line == -1 || column == -1) {
                throw new ValidationException("BPMN Element couldn't be found in file '" + fileName + "'!");
            }
            return new Location(Paths.get(fileName, new String[0]).toAbsolutePath(), new LocationCoordinate(line, column), xpathObjectId);
        }
        throw new ValidationException("BPMN Element couldn't be found as no corresponding file could be found.");
    }

    private static String createIdBpmnExpression(String id) {
        return String.format("//bpmn:*[@id = '%s']", id);
    }

    private static String textToString(Text text) {
        if (text == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Object content : text.getContent()) {
            if (content instanceof String) {
                sb.append(content);
                continue;
            }
            if (content instanceof Span) {
                sb.append(((Span)content).getContent());
                continue;
            }
            if (content instanceof Emph) {
                sb.append(((Emph)content).getContent());
                continue;
            }
            if (!(content instanceof Dir)) continue;
            sb.append(((Dir)content).getContent());
        }
        return sb.toString();
    }
}

