/*
 * Decompiled with CFR 0.152.
 */
package com.github.blutorange.bpmnspector.schematron.preprocessing;

import com.github.blutorange.bpmnspector.common.importer.BPMNProcess;
import com.github.blutorange.bpmnspector.common.util.ConstantHelper;
import com.github.blutorange.bpmnspector.refcheck.utils.JDOMUtils;
import java.util.List;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.filter.Filters;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)PreProcessor.class.getSimpleName());
    private static final String ALL_QNAME_ATTRIBUTES = "//bpmn:*/@sourceRef | //bpmn:*/@targetRef | //bpmn:*/@calledElement | //bpmn:*/@processRef | //bpmn:*/@dataStoreRef | //bpmn:*/@categoryValueRef | //bpmn:*/@messageRef | //bpmn:*/@correlationKeyRef | //bpmn:*/@correlationPropertyRef | //bpmn:*/@structureRef |//bpmn:*/@evaluatesToTypeRef | //bpmn:*/@itemRef | //bpmn:*/@type | //bpmn:*/@definitionalCollaborationRef | //bpmn:*/@parameterRef | //bpmn:*/@operationRef |//bpmn:*/@calledElement | //bpmn:*/@itemSubjectRef | //bpmn:*/@dataStoreRef | //bpmn:*/@attachedToRef | //bpmn:*/@activityRef | //bpmn:*/@errorRef | //bpmn:*/@escalationRef | //bpmn:*/@source | //bpmn:*/@target | //bpmn:*/@signalRef | //bpmn:*/@partitionElementRef";
    private static final String ALL_IDREF_ATTRIBUTES = "//bpmn:*/@sourceRef | //bpmn:*/@targetRef | //bpmn:*/@default |//bpmn:*/@inputDataRef | //bpmn:*/@outputDataRef | //bpmn:*/@dataObjectRef";
    private static final String ALL_QNAME_ELEMENTS = "//bpmn:eventDefinitionRef | //bpmn:incoming | //bpmn:outgoing | //bpmn:dataInputRefs | //bpmn:dataOutputRefs | //bpmn:correlationPropertyRef | //bpmn:categoryValueRef |//bpmn:inMessageRef | //bpmn:outMessageRef | //bpmn:errorRef | //bpmn:choreographyRef |//bpmn:interfaceRef | //bpmn:endPointRef | //bpmn:participantRef | //bpmn:innerParticipantRef |//bpmn:outerParticipantRef | //bpmn:supports | //bpmn:resourceRef | //bpmn:supportedInterfaceRefs |//bpmn:loopDataInputRef | //bpmn:loopDataOutputRef | //bpmn:oneBehaviorEventRef |//bpmn:noneBehaviorEventRef";
    private static final String ALL_IDREF_ELEMENTS = "//bpmn:dataInputRefs | //bpmn:optionalInputRefs | //bpmn:whileExecutingInputRefs | //bpmn:outputSetRefs | //bpmn:dataOutputRefs | //bpmn:optionalOutputRefs | //bpmn:whileExecutingOutputRefs | //bpmn:inputSetRefs | //bpmn:sourceRef | //bpmn:targetRef | //bpmn:flowNodeRef";
    private final XPathFactory xPathFactory = XPathFactory.instance();

    public Document preProcess(BPMNProcess process) {
        LOGGER.debug("Starting to preprocess file: {}", (Object)process.getBaseURI());
        Document cloneOfDoc = process.getProcessAsDoc().clone();
        if (process.getChildren().isEmpty() && JDOMUtils.getUsedPrefixForTargetNamespace(cloneOfDoc).isEmpty()) {
            LOGGER.debug("Skipping preprocessing.");
            return cloneOfDoc;
        }
        List refAttributes = this.createXPathExpressionForAllQNameAttributes().evaluate((Object)cloneOfDoc);
        List refElements = this.createXPathExpressionForAllQNameElements().evaluate((Object)cloneOfDoc);
        refAttributes.stream().filter(attribute -> attribute.getValue().contains(":")).forEach(attribute -> this.renameGlobalIds(process, (Attribute)attribute));
        refElements.stream().filter(element -> element.getText().contains(":")).forEach(element -> this.renameGlobalIds(process, (Element)element));
        for (BPMNProcess imported : process.getChildren()) {
            this.renameIds(imported);
            LOGGER.debug("Checking imported importedProcess for further imports.");
            Document result = this.preProcess(imported);
            LOGGER.debug("integration of document will be done now");
            this.addNodesToDocument(result, cloneOfDoc);
        }
        LOGGER.debug("Preprocessing of file {} completed.", (Object)process.getBaseURI());
        return cloneOfDoc;
    }

    private void renameGlobalIds(BPMNProcess process, Attribute attribute) {
        String prefix = attribute.getValue().substring(0, attribute.getValue().indexOf(":"));
        Object newPrefix = prefix.equals(JDOMUtils.getUsedPrefixForTargetNamespace(process.getProcessAsDoc()).orElse("")) ? "" : this.getNewPrefixByOldPrefix(process, prefix) + "_";
        String newId = attribute.getValue().replace(prefix + ":", (CharSequence)newPrefix);
        LOGGER.debug("new prefix '{}' for ID '{}' - new ID: {}", new Object[]{newPrefix, attribute.getValue(), newId});
        attribute.setValue(newId);
    }

    private void renameGlobalIds(BPMNProcess process, Element element) {
        String prefix = element.getText().substring(0, element.getText().indexOf(":"));
        Object newPrefix = prefix.equals(JDOMUtils.getUsedPrefixForTargetNamespace(process.getProcessAsDoc()).orElse("")) ? "" : this.getNewPrefixByOldPrefix(process, prefix) + "_";
        String newId = element.getText().replace(prefix + ":", (CharSequence)newPrefix);
        LOGGER.debug("new prefix '{}' for ID '{}' - new ID: {}", new Object[]{newPrefix, element.getText(), newId});
        element.setText(newId);
    }

    private String getNewPrefixByOldPrefix(BPMNProcess process, String oldPrefix) {
        Namespace namespace = process.getProcessAsDoc().getRootElement().getNamespace(oldPrefix);
        String nspURI = "";
        if (namespace != null) {
            nspURI = namespace.getURI();
        }
        String newPrefix = "";
        for (BPMNProcess imported : process.getChildren()) {
            if (!nspURI.equals(imported.getNamespace())) continue;
            newPrefix = imported.getGeneratedPrefix();
        }
        return newPrefix;
    }

    private void renameIds(BPMNProcess importedProcess) {
        List attributes = this.createXPathExpressionForAllIDsAndReferenceAttributes().evaluate((Object)importedProcess.getProcessAsDoc());
        List elements = this.createXPathExpressionForAllReferenceElements().evaluate((Object)importedProcess.getProcessAsDoc());
        attributes.stream().filter(x -> !x.getValue().contains(":")).forEach(x -> {
            LOGGER.debug("Updating attribute ID '{}' new value: {}", (Object)x.getValue(), (Object)(importedProcess.getGeneratedPrefix() + "_" + x.getValue()));
            x.setValue(importedProcess.getGeneratedPrefix() + "_" + x.getValue());
        });
        elements.stream().filter(x -> !x.getText().contains(":")).forEach(x -> {
            LOGGER.debug("Updating element {} ID '{}' new value: {}", new Object[]{x.getName(), x.getText(), importedProcess.getGeneratedPrefix() + "_" + x.getText()});
            x.setText(importedProcess.getGeneratedPrefix() + "_" + x.getText());
        });
    }

    private void addNodesToDocument(Document importedProcess, Document headDocument) {
        Element definitionsHead = headDocument.getRootElement();
        Element definitionsImported = importedProcess.getRootElement();
        for (Element element : definitionsImported.getChildren()) {
            Element clone = element.clone();
            definitionsHead.addContent((Content)clone);
        }
    }

    private XPathExpression<Attribute> createXPathExpressionForAllQNameAttributes() {
        return this.xPathFactory.compile(ALL_QNAME_ATTRIBUTES, Filters.attribute(), null, new Namespace[]{ConstantHelper.BPMN_NAMESPACE});
    }

    private XPathExpression<Element> createXPathExpressionForAllQNameElements() {
        return this.xPathFactory.compile(ALL_QNAME_ELEMENTS, Filters.element(), null, new Namespace[]{ConstantHelper.BPMN_NAMESPACE});
    }

    private XPathExpression<Attribute> createXPathExpressionForAllIDsAndReferenceAttributes() {
        String expStr = "//bpmn:*/@id | //bpmn:*/@sourceRef | //bpmn:*/@targetRef | //bpmn:*/@default |//bpmn:*/@inputDataRef | //bpmn:*/@outputDataRef | //bpmn:*/@dataObjectRef | //bpmn:*/@sourceRef | //bpmn:*/@targetRef | //bpmn:*/@calledElement | //bpmn:*/@processRef | //bpmn:*/@dataStoreRef | //bpmn:*/@categoryValueRef | //bpmn:*/@messageRef | //bpmn:*/@correlationKeyRef | //bpmn:*/@correlationPropertyRef | //bpmn:*/@structureRef |//bpmn:*/@evaluatesToTypeRef | //bpmn:*/@itemRef | //bpmn:*/@type | //bpmn:*/@definitionalCollaborationRef | //bpmn:*/@parameterRef | //bpmn:*/@operationRef |//bpmn:*/@calledElement | //bpmn:*/@itemSubjectRef | //bpmn:*/@dataStoreRef | //bpmn:*/@attachedToRef | //bpmn:*/@activityRef | //bpmn:*/@errorRef | //bpmn:*/@escalationRef | //bpmn:*/@source | //bpmn:*/@target | //bpmn:*/@signalRef | //bpmn:*/@partitionElementRef";
        return this.xPathFactory.compile(expStr, Filters.attribute(), null, new Namespace[]{ConstantHelper.BPMN_NAMESPACE});
    }

    private XPathExpression<Element> createXPathExpressionForAllReferenceElements() {
        String expStr = "//bpmn:dataInputRefs | //bpmn:optionalInputRefs | //bpmn:whileExecutingInputRefs | //bpmn:outputSetRefs | //bpmn:dataOutputRefs | //bpmn:optionalOutputRefs | //bpmn:whileExecutingOutputRefs | //bpmn:inputSetRefs | //bpmn:sourceRef | //bpmn:targetRef | //bpmn:flowNodeRef | //bpmn:eventDefinitionRef | //bpmn:incoming | //bpmn:outgoing | //bpmn:dataInputRefs | //bpmn:dataOutputRefs | //bpmn:correlationPropertyRef | //bpmn:categoryValueRef |//bpmn:inMessageRef | //bpmn:outMessageRef | //bpmn:errorRef | //bpmn:choreographyRef |//bpmn:interfaceRef | //bpmn:endPointRef | //bpmn:participantRef | //bpmn:innerParticipantRef |//bpmn:outerParticipantRef | //bpmn:supports | //bpmn:resourceRef | //bpmn:supportedInterfaceRefs |//bpmn:loopDataInputRef | //bpmn:loopDataOutputRef | //bpmn:oneBehaviorEventRef |//bpmn:noneBehaviorEventRef";
        return this.xPathFactory.compile(expStr, Filters.element(), null, new Namespace[]{ConstantHelper.BPMN_NAMESPACE});
    }
}

