/*
 * Decompiled with CFR 0.152.
 */
package com.github.blutorange.bpmnspector.validation;

import com.github.blutorange.bpmnspector.api.Resource;
import com.github.blutorange.bpmnspector.api.Violation;
import com.github.blutorange.bpmnspector.api.Warning;
import com.github.blutorange.bpmnspector.validation.ValidationResultBuilder;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class UnsortedValidationResult
extends ValidationResultBuilder {
    private final List<Resource> resources = new ArrayList<Resource>();
    private final List<Violation> violations = new ArrayList<Violation>();
    private final List<Warning> warnings = new ArrayList<Warning>();

    @Override
    public void addFile(Path s) {
        this.resources.add(new Resource(s));
    }

    @Override
    public void addResource(Resource resource) {
        this.resources.add(resource);
    }

    @Override
    public void addViolation(Violation violation) {
        this.violations.add(violation);
    }

    @Override
    public void addWarning(Warning warning) {
        this.warnings.add(warning);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnsortedValidationResult that = (UnsortedValidationResult)o;
        return Objects.equals(this.violations, that.violations) && Objects.equals(this.warnings, that.warnings) && Objects.equals(this.resources, that.resources);
    }

    @Override
    public List<Resource> getResources() {
        return new ArrayList<Resource>(this.resources);
    }

    @Override
    public List<Violation> getViolations() {
        return new ArrayList<Violation>(this.violations);
    }

    @Override
    public List<Warning> getWarnings() {
        return new ArrayList<Warning>(this.warnings);
    }

    public int hashCode() {
        return Objects.hash(this.violations, this.warnings, this.resources);
    }
}

