/*
 * Decompiled with CFR 0.152.
 */
package com.github.blutorange.bpmnspector.validation;

import com.github.blutorange.bpmnspector.api.AutoFixOptions;
import com.github.blutorange.bpmnspector.api.FixReport;
import com.github.blutorange.bpmnspector.api.Resource;
import com.github.blutorange.bpmnspector.api.ValidationResult;
import com.github.blutorange.bpmnspector.api.Violation;
import com.github.blutorange.bpmnspector.api.Warning;
import com.github.blutorange.bpmnspector.autofix.ConstraintFixer;
import com.github.blutorange.bpmnspector.autofix.FixingStrategy;
import com.github.blutorange.bpmnspector.common.importer.BPMNProcess;
import com.github.blutorange.bpmnspector.validation.DefaultFixReport;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.file.Path;
import java.util.Map;
import java.util.stream.Collectors;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public abstract class ValidationResultBuilder
implements ValidationResult {
    private BPMNProcess process;

    public abstract void addFile(Path var1);

    public abstract void addResource(Resource var1);

    public abstract void addViolation(Violation var1);

    public abstract void addWarning(Warning var1);

    @Override
    public FixReport<String> autoFix(AutoFixOptions options) {
        if (this.process == null) {
            throw new IllegalStateException("Cannot auto-fix, process was never read or set");
        }
        ConstraintFixer fixer = this.doFix();
        XMLOutputter outputter = this.createXmlOutputter(options);
        String xml = outputter.outputString(fixer.getFixedProcess().getProcessAsDoc());
        return new DefaultFixReport<String>(xml, fixer.getGlobalFixReport().getFixedViolations());
    }

    @Override
    public FixReport<Void> autoFix(AutoFixOptions options, OutputStream output) throws IOException {
        if (this.process == null) {
            throw new IllegalStateException("Cannot auto-fix, process was never read or set");
        }
        ConstraintFixer fixer = this.doFix();
        XMLOutputter outputter = this.createXmlOutputter(options);
        outputter.output(fixer.getFixedProcess().getProcessAsDoc(), output);
        return new DefaultFixReport<Object>(null, fixer.getGlobalFixReport().getFixedViolations());
    }

    @Override
    public FixReport<Void> autoFix(AutoFixOptions options, Writer writer) throws IOException {
        if (this.process == null) {
            throw new IllegalStateException("Cannot auto-fix, process was never read or set");
        }
        ConstraintFixer fixer = this.doFix();
        XMLOutputter outputter = this.createXmlOutputter(options);
        outputter.output(fixer.getFixedProcess().getProcessAsDoc(), writer);
        return new DefaultFixReport<Object>(null, fixer.getGlobalFixReport().getFixedViolations());
    }

    public final void setBpmnProcess(BPMNProcess process) {
        this.process = process;
    }

    private XMLOutputter createXmlOutputter(AutoFixOptions options) {
        XMLOutputter outputter = new XMLOutputter();
        if (options.isPrettyPrint()) {
            outputter.setFormat(Format.getPrettyFormat());
        } else {
            outputter.setFormat(Format.getCompactFormat());
        }
        return outputter;
    }

    private ConstraintFixer doFix() {
        Map<Violation, FixingStrategy> fixes = this.getViolations().stream().map(v -> Map.entry(v, FixingStrategy.AUTO_FIX)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        ConstraintFixer fixer = new ConstraintFixer(this.process, fixes);
        fixer.fixAllPossibleIssues();
        return fixer;
    }
}

