/*
 * Decompiled with CFR 0.152.
 */
package com.github.blutorange.maven.plugin.closurecompiler.common;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.codehaus.plexus.util.DirectoryScanner;

public class FileHelper {
    private FileHelper() {
    }

    public static String relativizePath(File base, File target) throws IOException {
        Path targetPath = Paths.get(target.getCanonicalPath(), new String[0]);
        if (base == null) {
            return targetPath.toString();
        }
        Path basePath = base.getCanonicalFile().toPath();
        String relativePath = basePath.relativize(targetPath).toString();
        return relativePath;
    }

    public static File getFile(File directory, String ... names) {
        return FileUtils.getFile((File)directory, (String[])((String[])Arrays.stream(names).filter(StringUtils::isNotEmpty).toArray(String[]::new)));
    }

    public static File getAbsoluteFile(File basedir, File file) {
        if (file.isAbsolute()) {
            return file;
        }
        return new File(basedir, file.getPath());
    }

    public static File getAbsoluteFile(File basedir, String file) {
        return FileHelper.getAbsoluteFile(basedir, new File(file));
    }

    public static List<File> getIncludedFiles(File baseDir, List<String> includes, List<String> excludes) {
        if (CollectionUtils.isEmpty(includes)) {
            return new ArrayList<File>();
        }
        String[] excludesArray = excludes.toArray(new String[excludes.size()]);
        return IntStream.range(0, includes.size()).mapToObj(i -> Pair.of((Object)i, (Object)((String)includes.get(i)))).flatMap(include -> {
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setIncludes(new String[]{(String)include.getRight()});
            scanner.setExcludes(excludesArray);
            scanner.addDefaultExcludes();
            scanner.setBasedir(baseDir);
            scanner.scan();
            return Arrays.stream(scanner.getIncludedFiles()).map(includedFilename -> {
                File includedFile = new File(baseDir, (String)includedFilename);
                return Pair.of((Object)((Integer)include.getLeft()), (Object)includedFile);
            });
        }).sorted().map(Pair::getRight).filter(FileHelper.distinctByKey(File::getAbsolutePath)).collect(Collectors.toList());
    }

    private static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        HashSet seen = new HashSet();
        return t -> seen.add(keyExtractor.apply(t));
    }
}

