/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.callback.CallbackList;
import com.helger.commons.callback.ICallback;
import com.helger.commons.callback.exception.IExceptionCallback;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.error.list.ErrorList;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.lang.IHasClassLoader;
import com.helger.commons.state.ESuccess;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.jaxb.IJAXBMarshaller;
import com.helger.jaxb.IJAXBReader;
import com.helger.jaxb.IJAXBUnmarshaller;
import com.helger.jaxb.IJAXBValidator;
import com.helger.jaxb.IJAXBWriter;
import com.helger.jaxb.JAXBContextCache;
import com.helger.jaxb.JAXBContextCacheKey;
import com.helger.jaxb.JAXBMarshallerHelper;
import com.helger.jaxb.LoggingJAXBReadExceptionHandler;
import com.helger.jaxb.LoggingJAXBWriteExceptionHandler;
import com.helger.jaxb.builder.JAXBBuilderDefaultSettings;
import com.helger.jaxb.validation.IValidationEventHandlerFactory;
import com.helger.jaxb.validation.WrappedCollectingValidationEventHandler;
import com.helger.xml.schema.XMLSchemaCache;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.validation.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.DefaultHandler;

@NotThreadSafe
public class GenericJAXBMarshaller<JAXBTYPE>
implements IHasClassLoader,
IJAXBReader<JAXBTYPE>,
IJAXBWriter<JAXBTYPE>,
IJAXBValidator<JAXBTYPE> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericJAXBMarshaller.class);
    private final Class<JAXBTYPE> m_aType;
    private final ICommonsList<ClassPathResource> m_aXSDs = new CommonsArrayList();
    private final Function<? super JAXBTYPE, ? extends JAXBElement<JAXBTYPE>> m_aJAXBElementWrapper;
    private ValidationEventHandler m_aEventHandler = JAXBBuilderDefaultSettings.getDefaultValidationEventHandler();
    private boolean m_bFormattedOutput = JAXBBuilderDefaultSettings.isDefaultFormattedOutput();
    private NamespaceContext m_aNSContext = JAXBBuilderDefaultSettings.getDefaultNamespaceContext();
    private Charset m_aCharset = JAXBBuilderDefaultSettings.getDefaultCharset();
    private String m_sIndentString = JAXBBuilderDefaultSettings.getDefaultIndentString();
    private boolean m_bUseSchema = JAXBBuilderDefaultSettings.isDefaultUseSchema();
    private String m_sSchemaLocation = JAXBBuilderDefaultSettings.getDefaultSchemaLocation();
    private String m_sNoNamespaceSchemaLocation = JAXBBuilderDefaultSettings.getDefaultNoNamespaceSchemaLocation();
    private boolean m_bUseContextCache = JAXBBuilderDefaultSettings.isDefaultUseContextCache();
    private WeakReference<ClassLoader> m_aClassLoader;
    private final CallbackList<IExceptionCallback<JAXBException>> m_aReadExceptionCallbacks = new CallbackList();
    private final CallbackList<IExceptionCallback<JAXBException>> m_aWriteExceptionCallbacks = new CallbackList();

    public GenericJAXBMarshaller(@Nonnull Class<JAXBTYPE> aType, @Nonnull QName aQName) {
        this(aType, GenericJAXBMarshaller.createSimpleJAXBElement(aQName, aType));
    }

    public GenericJAXBMarshaller(@Nonnull Class<JAXBTYPE> aType, @Nonnull Function<? super JAXBTYPE, ? extends JAXBElement<JAXBTYPE>> aWrapper) {
        this(aType, null, aWrapper);
    }

    public GenericJAXBMarshaller(@Nonnull Class<JAXBTYPE> aType, @Nullable List<? extends ClassPathResource> aXSDs, @Nonnull Function<? super JAXBTYPE, ? extends JAXBElement<JAXBTYPE>> aJAXBElementWrapper) {
        this.m_aType = (Class)ValueEnforcer.notNull(aType, (String)"Type");
        if (aXSDs != null) {
            ValueEnforcer.notEmptyNoNullValue(aXSDs, (String)"XSDs");
            this.m_aXSDs.addAll(aXSDs);
            for (ClassPathResource aRes : this.m_aXSDs) {
                ValueEnforcer.isTrue((boolean)aRes.hasClassLoader(), () -> "ClassPathResource " + String.valueOf(aRes) + " should define its ClassLoader for OSGI handling!");
            }
        }
        this.m_aJAXBElementWrapper = (Function)ValueEnforcer.notNull(aJAXBElementWrapper, (String)"JAXBElementWrapper");
        this.m_aClassLoader = new WeakReference<ClassLoader>(aType.getClassLoader());
        this.m_aReadExceptionCallbacks.add((ICallback)LoggingJAXBReadExceptionHandler.INSTANCE);
        this.m_aWriteExceptionCallbacks.add((ICallback)LoggingJAXBWriteExceptionHandler.INSTANCE);
    }

    @Nonnull
    protected final Class<JAXBTYPE> getType() {
        return this.m_aType;
    }

    @Nullable
    public final ClassLoader getClassLoader() {
        return (ClassLoader)this.m_aClassLoader.get();
    }

    @Nullable
    public final ValidationEventHandler getValidationEventHandler() {
        return this.m_aEventHandler;
    }

    @Nonnull
    public final GenericJAXBMarshaller<JAXBTYPE> setValidationEventHandler(@Nullable ValidationEventHandler aEventHandler) {
        this.m_aEventHandler = aEventHandler;
        return this;
    }

    @Nonnull
    @Deprecated(forRemoval=true, since="11.0.0")
    public final GenericJAXBMarshaller<JAXBTYPE> setValidationEventHandlerFactory(@Nullable IValidationEventHandlerFactory aVEHFactory) {
        return this.setValidationEventHandler(aVEHFactory == null ? null : aVEHFactory.apply(this.m_aEventHandler));
    }

    @Nonnull
    public final GenericJAXBMarshaller<JAXBTYPE> setCollectErrors(@Nonnull ErrorList aErrorList) {
        ValueEnforcer.notNull((Object)aErrorList, (String)"ErrorList");
        return this.setValidationEventHandler(new WrappedCollectingValidationEventHandler(aErrorList));
    }

    @Override
    @Nullable
    public final NamespaceContext getNamespaceContext() {
        return this.m_aNSContext;
    }

    @Nonnull
    public final GenericJAXBMarshaller<JAXBTYPE> setNamespaceContext(@Nullable NamespaceContext aNSContext) {
        this.m_aNSContext = aNSContext;
        return this;
    }

    @Override
    public final boolean isFormattedOutput() {
        return this.m_bFormattedOutput;
    }

    @Nonnull
    public final GenericJAXBMarshaller<JAXBTYPE> setFormattedOutput(boolean bWriteFormatted) {
        this.m_bFormattedOutput = bWriteFormatted;
        return this;
    }

    @Override
    @Nullable
    public final Charset getCharset() {
        return this.m_aCharset;
    }

    @Nonnull
    public final GenericJAXBMarshaller<JAXBTYPE> setCharset(@Nullable Charset aCharset) {
        this.m_aCharset = aCharset;
        return this;
    }

    @Override
    @Nullable
    public final String getIndentString() {
        return this.m_sIndentString;
    }

    @Nonnull
    public final GenericJAXBMarshaller<JAXBTYPE> setIndentString(@Nullable String sIndentString) {
        this.m_sIndentString = sIndentString;
        return this;
    }

    @Override
    public final boolean isUseSchema() {
        return this.m_bUseSchema;
    }

    @Nonnull
    public final GenericJAXBMarshaller<JAXBTYPE> setUseSchema(boolean bUseSchema) {
        this.m_bUseSchema = bUseSchema;
        return this;
    }

    @Override
    @Nullable
    public final String getSchemaLocation() {
        return this.m_sSchemaLocation;
    }

    @Nonnull
    public final GenericJAXBMarshaller<JAXBTYPE> setSchemaLocation(@Nullable String sSchemaLocation) {
        this.m_sSchemaLocation = sSchemaLocation;
        return this;
    }

    @Override
    @Nullable
    public final String getNoNamespaceSchemaLocation() {
        return this.m_sNoNamespaceSchemaLocation;
    }

    @Nonnull
    public final GenericJAXBMarshaller<JAXBTYPE> setNoNamespaceSchemaLocation(@Nullable String sNoNamespaceSchemaLocation) {
        this.m_sNoNamespaceSchemaLocation = sNoNamespaceSchemaLocation;
        return this;
    }

    public final boolean isUseContextCache() {
        return this.m_bUseContextCache;
    }

    @Nonnull
    public final GenericJAXBMarshaller<JAXBTYPE> setUseContextCache(boolean bUseContextCache) {
        this.m_bUseContextCache = bUseContextCache;
        return this;
    }

    @Nonnull
    @ReturnsMutableObject
    public final CallbackList<IExceptionCallback<JAXBException>> readExceptionCallbacks() {
        return this.m_aReadExceptionCallbacks;
    }

    @Nonnull
    @ReturnsMutableObject
    public final CallbackList<IExceptionCallback<JAXBException>> writeExceptionCallbacks() {
        return this.m_aWriteExceptionCallbacks;
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public final ICommonsList<ClassPathResource> getOriginalXSDs() {
        return (ICommonsList)this.m_aXSDs.getClone();
    }

    @Nullable
    @OverrideOnDemand
    protected Schema createValidationSchema() {
        if (!this.m_bUseSchema) {
            return null;
        }
        if (this.m_aXSDs.isEmpty()) {
            return null;
        }
        return XMLSchemaCache.getInstanceOfClassLoader((ClassLoader)this.getClassLoader()).getSchema(this.m_aXSDs);
    }

    @Nonnull
    @OverrideOnDemand
    protected JAXBContext getJAXBContext(@Nullable ClassLoader aClassLoader) throws JAXBException {
        Package aPackage = this.m_aType.getPackage();
        if (this.m_bUseContextCache) {
            return (JAXBContext)JAXBContextCache.getInstance().getFromCache(JAXBContextCacheKey.createForPackage(aPackage, aClassLoader));
        }
        return JAXBContext.newInstance((String)aPackage.getName(), (ClassLoader)aClassLoader);
    }

    @Nonnull
    private Unmarshaller _createUnmarshaller(@Nullable ClassLoader aClassLoader) throws JAXBException {
        Schema aValidationSchema;
        JAXBContext aJAXBContext = this.getJAXBContext(aClassLoader);
        Unmarshaller aUnmarshaller = aJAXBContext.createUnmarshaller();
        if (this.m_aEventHandler != null) {
            aUnmarshaller.setEventHandler(this.m_aEventHandler);
        }
        if ((aValidationSchema = this.createValidationSchema()) != null) {
            aUnmarshaller.setSchema(aValidationSchema);
        }
        return aUnmarshaller;
    }

    @OverrideOnDemand
    protected void customizeUnmarshaller(@Nonnull Unmarshaller aUnmarshaller) {
    }

    @Override
    @Nullable
    public final JAXBTYPE read(@Nonnull IJAXBUnmarshaller<JAXBTYPE> aHandler) {
        ValueEnforcer.notNull(aHandler, (String)"Handler");
        try {
            Unmarshaller aUnmarshaller = this._createUnmarshaller(this.getClassLoader());
            this.customizeUnmarshaller(aUnmarshaller);
            return (JAXBTYPE)aHandler.doUnmarshal(aUnmarshaller, this.m_aType).getValue();
        }
        catch (JAXBException ex) {
            this.m_aReadExceptionCallbacks.forEach(x -> x.onException((Throwable)ex));
            return null;
        }
    }

    @Nonnull
    private Marshaller _createMarshaller(@Nullable ClassLoader aClassLoader) throws JAXBException {
        Schema aValidationSchema;
        JAXBContext aJAXBContext = this.getJAXBContext(aClassLoader);
        Marshaller aMarshaller = aJAXBContext.createMarshaller();
        if (this.m_aEventHandler != null) {
            aMarshaller.setEventHandler(this.m_aEventHandler);
        }
        if (this.m_aNSContext != null) {
            try {
                JAXBMarshallerHelper.setJakartaNamespacePrefixMapper(aMarshaller, this.m_aNSContext);
            }
            catch (Exception | NoClassDefFoundError ex) {
                LOGGER.error("Failed to set the namespace context " + String.valueOf(this.m_aNSContext) + ": " + ex.getClass().getName() + " -- " + ex.getMessage());
            }
        }
        JAXBMarshallerHelper.setFormattedOutput(aMarshaller, this.m_bFormattedOutput);
        if (this.m_aCharset != null) {
            JAXBMarshallerHelper.setEncoding(aMarshaller, this.m_aCharset);
        }
        if (this.m_sIndentString != null) {
            JAXBMarshallerHelper.setJakartaIndentString(aMarshaller, this.m_sIndentString);
        }
        if (this.m_sSchemaLocation != null) {
            JAXBMarshallerHelper.setSchemaLocation(aMarshaller, this.m_sSchemaLocation);
        }
        if (this.m_sNoNamespaceSchemaLocation != null) {
            JAXBMarshallerHelper.setNoNamespaceSchemaLocation(aMarshaller, this.m_sNoNamespaceSchemaLocation);
        }
        if ((aValidationSchema = this.createValidationSchema()) != null) {
            aMarshaller.setSchema(aValidationSchema);
        }
        return aMarshaller;
    }

    @OverrideOnDemand
    protected void customizeMarshaller(@Nonnull Marshaller aMarshaller) {
    }

    @Override
    @Nonnull
    public final ESuccess write(@Nonnull JAXBTYPE aObject, @Nonnull IJAXBMarshaller<JAXBTYPE> aMarshallerFunc) {
        ValueEnforcer.notNull(aObject, (String)"Object");
        ValueEnforcer.notNull(aMarshallerFunc, (String)"MarshallerFunc");
        try {
            Marshaller aMarshaller = this._createMarshaller(this.getClassLoader());
            this.customizeMarshaller(aMarshaller);
            JAXBElement<JAXBTYPE> aJAXBElement = this.m_aJAXBElementWrapper.apply(aObject);
            aMarshallerFunc.doMarshal(aMarshaller, aJAXBElement);
            return ESuccess.SUCCESS;
        }
        catch (JAXBException ex) {
            this.m_aWriteExceptionCallbacks.forEach(x -> x.onException((Throwable)ex));
            return ESuccess.FAILURE;
        }
    }

    @OverrideOnDemand
    protected void customizeMarshallerForValidation(@Nonnull Marshaller aMarshaller) {
    }

    @Override
    public void validate(@Nonnull JAXBTYPE aObject, @Nonnull ErrorList aErrorList) {
        ValueEnforcer.notNull(aObject, (String)"Object");
        ValueEnforcer.notNull((Object)aErrorList, (String)"ErrorList");
        WrappedCollectingValidationEventHandler aEventHandler = new WrappedCollectingValidationEventHandler(aErrorList);
        try {
            Marshaller aMarshaller = this._createMarshaller(this.getClassLoader());
            aMarshaller.setEventHandler((ValidationEventHandler)aEventHandler);
            this.customizeMarshallerForValidation(aMarshaller);
            if (aMarshaller.getSchema() == null) {
                LOGGER.warn("Running validation on JAXB object of type " + aObject.getClass().getName() + " makes no sense, because no XML Schema is provided");
            }
            JAXBElement<JAXBTYPE> aJAXBElement = this.m_aJAXBElementWrapper.apply(aObject);
            aMarshaller.marshal(aJAXBElement, (ContentHandler)new DefaultHandler());
        }
        catch (JAXBException jAXBException) {
            // empty catch block
        }
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Type", this.m_aType).append("XSDs", this.m_aXSDs).append("JAXBElementWrapper", this.m_aJAXBElementWrapper).append("EventHandler", (Object)this.m_aEventHandler).append("FormattedOutput", this.m_bFormattedOutput).append("NSContext", (Object)this.m_aNSContext).append("Charset", (Object)this.m_aCharset).append("IndentString", this.m_sIndentString == null ? null : StringHelper.getHexEncoded((String)this.m_sIndentString, (Charset)StandardCharsets.ISO_8859_1)).append("SchemaLocation", (Object)this.m_sSchemaLocation).append("NoNamespaceSchemaLocation", (Object)this.m_sNoNamespaceSchemaLocation).append("UseContextCache", this.m_bUseContextCache).append("ClassLoader", this.m_aClassLoader).append("ReadExceptionHandlers", this.m_aReadExceptionCallbacks).append("WriteExceptionHandlers", this.m_aWriteExceptionCallbacks).getToString();
    }

    @Nonnull
    public static <T> Function<T, JAXBElement<T>> createSimpleJAXBElement(@Nonnull QName aQName, @Nonnull Class<T> aClass) {
        return aValue -> new JAXBElement(aQName, aClass, null, aValue);
    }
}

