/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.charset.CharsetHelper;
import com.helger.commons.io.IHasInputStream;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.io.stream.ByteBufferInputStream;
import com.helger.commons.io.stream.NonBlockingByteArrayInputStream;
import com.helger.commons.io.stream.NonBlockingStringReader;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.jaxb.IJAXBUnmarshaller;
import com.helger.xml.sax.InputSourceFactory;
import com.helger.xml.serialize.read.SAXReaderFactory;
import com.helger.xml.serialize.read.SAXReaderSettings;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public interface IJAXBReader<JAXBTYPE> {
    public boolean isUseSchema();

    @Nullable
    default public JAXBTYPE read(@Nonnull InputSource aInputSource) {
        return this.read(new SAXReaderSettings(), aInputSource);
    }

    @Nullable
    default public JAXBTYPE read(@Nonnull SAXReaderSettings aSettings, @Nonnull InputSource aInputSource) {
        ValueEnforcer.notNull((Object)aSettings, (String)"Settings");
        ValueEnforcer.notNull((Object)aInputSource, (String)"InputSource");
        XMLReader aParser = SAXReaderFactory.createXMLReader();
        aSettings.applyToSAXReader(aParser);
        return this.read(new SAXSource(aParser, aInputSource));
    }

    @Nullable
    default public JAXBTYPE read(@Nonnull InputStream aIS) {
        ValueEnforcer.notNull((Object)aIS, (String)"InputStream");
        CharsetHelper.InputStreamAndCharset aISAndBOM = CharsetHelper.getInputStreamAndCharsetFromBOM((InputStream)aIS);
        if (aISAndBOM.hasCharset()) {
            return this.read(StreamHelper.createReader((InputStream)aISAndBOM.getInputStream(), (Charset)aISAndBOM.getCharset()));
        }
        return this.read(InputSourceFactory.create((InputStream)aISAndBOM.getInputStream()));
    }

    @Nullable
    default public JAXBTYPE read(@Nonnull Reader aReader) {
        ValueEnforcer.notNull((Object)aReader, (String)"Reader");
        return this.read(InputSourceFactory.create((Reader)aReader));
    }

    @Nullable
    default public JAXBTYPE read(@Nonnull File aFile) {
        ValueEnforcer.notNull((Object)aFile, (String)"File");
        return this.read(InputSourceFactory.create((File)aFile));
    }

    @Nullable
    default public JAXBTYPE read(@Nonnull Path aPath) {
        ValueEnforcer.notNull((Object)aPath, (String)"Path");
        return this.read(InputSourceFactory.create((Path)aPath));
    }

    @Nullable
    default public JAXBTYPE read(@Nonnull IReadableResource aResource) {
        ValueEnforcer.notNull((Object)aResource, (String)"Resource");
        return this.read(InputSourceFactory.create((IReadableResource)aResource));
    }

    @Nullable
    default public JAXBTYPE read(@Nonnull IHasInputStream aISP) {
        ValueEnforcer.notNull((Object)aISP, (String)"Resource");
        return this.read(aISP.getInputStream());
    }

    @Nullable
    default public JAXBTYPE read(@Nonnull byte[] aXML) {
        ValueEnforcer.notNull((Object)aXML, (String)"XML");
        return this.read((InputStream)new NonBlockingByteArrayInputStream(aXML));
    }

    @Nullable
    default public JAXBTYPE read(@Nonnull byte[] aXML, @Nonnegative int nOfs, @Nonnegative int nLen) {
        ValueEnforcer.notNull((Object)aXML, (String)"XML");
        return this.read((InputStream)new NonBlockingByteArrayInputStream(aXML, nOfs, nLen));
    }

    @Nullable
    default public JAXBTYPE read(@Nonnull ByteBuffer aXML) {
        ValueEnforcer.notNull((Object)aXML, (String)"XML");
        return this.read((InputStream)new ByteBufferInputStream(aXML));
    }

    @Nullable
    default public JAXBTYPE read(@Nonnull String sXML) {
        ValueEnforcer.notNull((Object)sXML, (String)"XML");
        return this.read((Reader)new NonBlockingStringReader(sXML));
    }

    @Nullable
    default public JAXBTYPE read(@Nonnull char[] aXML) {
        ValueEnforcer.notNull((Object)aXML, (String)"XML");
        return this.read((Reader)new NonBlockingStringReader(aXML));
    }

    @Nullable
    public JAXBTYPE read(@Nonnull IJAXBUnmarshaller<JAXBTYPE> var1);

    @Nullable
    default public JAXBTYPE read(@Nonnull Source aSource) {
        ValueEnforcer.notNull((Object)aSource, (String)"Source");
        return this.read((Unmarshaller aUnmarshaller, Class<JAXBTYPE> aClass) -> aUnmarshaller.unmarshal(aSource, aClass));
    }

    @Nullable
    default public JAXBTYPE read(@Nonnull Node aNode) {
        ValueEnforcer.notNull((Object)aNode, (String)"Node");
        return this.read((Unmarshaller aUnmarshaller, Class<JAXBTYPE> aClass) -> aUnmarshaller.unmarshal(aNode, aClass));
    }

    @Nullable
    default public JAXBTYPE read(@Nonnull XMLStreamReader aReader) {
        ValueEnforcer.notNull((Object)aReader, (String)"Reader");
        return this.read((Unmarshaller aUnmarshaller, Class<JAXBTYPE> aClass) -> aUnmarshaller.unmarshal(aReader, aClass));
    }

    @Nullable
    default public JAXBTYPE read(@Nonnull XMLEventReader aReader) {
        ValueEnforcer.notNull((Object)aReader, (String)"Reader");
        return this.read((Unmarshaller aUnmarshaller, Class<JAXBTYPE> aClass) -> aUnmarshaller.unmarshal(aReader, aClass));
    }
}

