/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb;

import com.helger.commons.io.EAppend;
import com.helger.commons.io.file.FileHelper;
import com.helger.commons.io.resource.IWritableResource;
import com.helger.commons.io.stream.ByteBufferOutputStream;
import com.helger.commons.io.stream.NonBlockingBufferedOutputStream;
import com.helger.commons.io.stream.NonBlockingByteArrayInputStream;
import com.helger.commons.io.stream.NonBlockingStringWriter;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.state.ESuccess;
import com.helger.commons.string.StringHelper;
import com.helger.commons.system.ENewLineMode;
import com.helger.jaxb.IJAXBMarshaller;
import com.helger.xml.XMLFactory;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.serialize.MicroSAXHandler;
import com.helger.xml.serialize.write.EXMLIncorrectCharacterHandling;
import com.helger.xml.serialize.write.EXMLSerializeIndent;
import com.helger.xml.serialize.write.IXMLWriterSettings;
import com.helger.xml.serialize.write.SafeXMLStreamWriter;
import com.helger.xml.serialize.write.XMLWriterSettings;
import com.helger.xml.transform.TransformResultFactory;
import java.io.File;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;

public interface IJAXBWriter<JAXBTYPE> {
    public static final boolean USE_JAXB_CHARSET_FIX = true;

    @Nullable
    public NamespaceContext getNamespaceContext();

    public boolean isFormattedOutput();

    @Nullable
    public Charset getCharset();

    default public boolean hasCharset() {
        return this.getCharset() != null;
    }

    @Nullable
    public String getIndentString();

    default public boolean hasIndentString() {
        return StringHelper.hasText((String)this.getIndentString());
    }

    public boolean isUseSchema();

    @Nullable
    public String getSchemaLocation();

    default public boolean hasSchemaLocation() {
        return StringHelper.hasText((String)this.getSchemaLocation());
    }

    @Nullable
    public String getNoNamespaceSchemaLocation();

    default public boolean hasNoNamespaceSchemaLocation() {
        return StringHelper.hasText((String)this.getNoNamespaceSchemaLocation());
    }

    @Nonnull
    default public IXMLWriterSettings getXMLWriterSettings() {
        XMLWriterSettings ret = new XMLWriterSettings().setNamespaceContext(this.getNamespaceContext()).setIndent(this.isFormattedOutput() ? EXMLSerializeIndent.INDENT_AND_ALIGN : EXMLSerializeIndent.NONE);
        if (this.hasIndentString()) {
            ret.setIndentationString(this.getIndentString());
        }
        if (this.hasCharset()) {
            ret.setCharset(this.getCharset());
        }
        return ret.setNewLineMode(ENewLineMode.DEFAULT).setIncorrectCharacterHandling(EXMLIncorrectCharacterHandling.DO_NOT_WRITE_LOG_WARNING);
    }

    @Nonnull
    default public ESuccess write(@Nonnull JAXBTYPE aObject, @Nonnull File aResultFile) {
        NonBlockingBufferedOutputStream aOS = FileHelper.getBufferedOutputStream((File)aResultFile);
        if (aOS == null) {
            return ESuccess.FAILURE;
        }
        return this.write(aObject, (OutputStream)aOS);
    }

    @Nonnull
    default public ESuccess write(@Nonnull JAXBTYPE aObject, @Nonnull Path aResultPath) {
        return this.write(aObject, aResultPath.toFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    default public ESuccess write(@Nonnull JAXBTYPE aObject, @Nonnull @WillClose OutputStream aOS) {
        try {
            ESuccess eSuccess = this.write(aObject, (XMLStreamWriter)SafeXMLStreamWriter.create((OutputStream)aOS, (IXMLWriterSettings)this.getXMLWriterSettings()));
            return eSuccess;
        }
        finally {
            StreamHelper.close((AutoCloseable)aOS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    default public ESuccess write(@Nonnull JAXBTYPE aObject, @Nonnull @WillClose Writer aWriter) {
        try {
            ESuccess eSuccess = this.write(aObject, (XMLStreamWriter)SafeXMLStreamWriter.create((Writer)aWriter, (IXMLWriterSettings)this.getXMLWriterSettings()));
            return eSuccess;
        }
        finally {
            StreamHelper.close((AutoCloseable)aWriter);
        }
    }

    @Nonnull
    default public ESuccess write(@Nonnull JAXBTYPE aObject, @Nonnull ByteBuffer aBuffer) {
        return this.write(aObject, (OutputStream)new ByteBufferOutputStream(aBuffer, false));
    }

    @Nonnull
    default public ESuccess write(@Nonnull JAXBTYPE aObject, @Nonnull IWritableResource aResource) {
        OutputStream aOS = aResource.getOutputStream(EAppend.TRUNCATE);
        if (aOS == null) {
            return ESuccess.FAILURE;
        }
        return this.write(aObject, aOS);
    }

    @Nonnull
    public ESuccess write(@Nonnull JAXBTYPE var1, @Nonnull IJAXBMarshaller<JAXBTYPE> var2);

    @Nonnull
    default public ESuccess write(@Nonnull JAXBTYPE aObject, @Nonnull Result aResult) {
        if (aResult instanceof StreamResult) {
            LoggerFactory.getLogger(IJAXBWriter.class).warn("Potentially invalid XML is created by using StreamResult object: {}", (Object)aResult);
        }
        return this.write(aObject, (Marshaller m, JAXBElement<JAXBTYPE> e) -> m.marshal((Object)e, aResult));
    }

    @Nonnull
    default public ESuccess write(@Nonnull JAXBTYPE aObject, @Nonnull ContentHandler aHandler) {
        return this.write(aObject, (Marshaller m, JAXBElement<JAXBTYPE> e) -> m.marshal((Object)e, aHandler));
    }

    @Nonnull
    default public ESuccess write(@Nonnull JAXBTYPE aObject, @Nonnull @WillClose XMLStreamWriter aWriter) {
        ESuccess ret = this.write(aObject, (Marshaller m, JAXBElement<JAXBTYPE> e) -> m.marshal((Object)e, aWriter));
        try {
            aWriter.flush();
        }
        catch (XMLStreamException ex) {
            throw new IllegalStateException("Failed to flush XMLStreamWriter", ex);
        }
        try {
            aWriter.close();
        }
        catch (XMLStreamException ex) {
            throw new IllegalStateException("Failed to close XMLStreamWriter", ex);
        }
        return ret;
    }

    @Nullable
    default public Document getAsDocument(@Nonnull JAXBTYPE aObject) {
        Document aDoc = XMLFactory.newDocument();
        return this.write(aObject, TransformResultFactory.create((Node)aDoc)).isSuccess() ? aDoc : null;
    }

    @Nullable
    default public Element getAsElement(@Nonnull JAXBTYPE aObject) {
        Document aDoc = this.getAsDocument(aObject);
        return aDoc == null ? null : aDoc.getDocumentElement();
    }

    @Nullable
    default public IMicroDocument getAsMicroDocument(@Nonnull JAXBTYPE aObject) {
        MicroSAXHandler aHandler = new MicroSAXHandler(false, null, true);
        return this.write(aObject, (ContentHandler)aHandler).isSuccess() ? aHandler.getDocument() : null;
    }

    @Nullable
    default public IMicroElement getAsMicroElement(@Nonnull JAXBTYPE aObject) {
        IMicroDocument aDoc = this.getAsMicroDocument(aObject);
        if (aDoc == null) {
            return null;
        }
        IMicroElement ret = aDoc.getDocumentElement();
        ret.detachFromParent();
        return ret;
    }

    @Nullable
    default public String getAsString(@Nonnull JAXBTYPE aObject) {
        try (NonBlockingStringWriter aSW = new NonBlockingStringWriter();){
            String string = this.write(aObject, (XMLStreamWriter)SafeXMLStreamWriter.create((Writer)aSW, (IXMLWriterSettings)this.getXMLWriterSettings())).isSuccess() ? aSW.getAsString() : null;
            return string;
        }
    }

    @Nullable
    default public ByteBuffer getAsByteBuffer(@Nonnull JAXBTYPE aObject) {
        try (ByteBufferOutputStream aBBOS = new ByteBufferOutputStream();){
            ByteBuffer byteBuffer = this.write(aObject, (XMLStreamWriter)SafeXMLStreamWriter.create((OutputStream)aBBOS, (IXMLWriterSettings)this.getXMLWriterSettings())).isFailure() ? null : aBBOS.getBuffer();
            return byteBuffer;
        }
    }

    @Nullable
    default public byte[] getAsBytes(@Nonnull JAXBTYPE aObject) {
        try (ByteBufferOutputStream aBBOS = new ByteBufferOutputStream();){
            byte[] byArray = this.write(aObject, (XMLStreamWriter)SafeXMLStreamWriter.create((OutputStream)aBBOS, (IXMLWriterSettings)this.getXMLWriterSettings())).isFailure() ? null : aBBOS.getAsByteArray();
            return byArray;
        }
    }

    @Nullable
    default public NonBlockingByteArrayInputStream getAsInputStream(@Nonnull JAXBTYPE aObject) {
        byte[] aBytes = this.getAsBytes(aObject);
        return aBytes == null ? null : new NonBlockingByteArrayInputStream(aBytes);
    }
}

