/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb;

import com.helger.commons.cache.Cache;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.log.ConditionalLogger;
import com.helger.commons.log.IHasConditionalLogger;
import com.helger.commons.state.EChange;
import com.helger.jaxb.JAXBContextCacheKey;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.bind.JAXBContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class JAXBContextCache
extends Cache<JAXBContextCacheKey, JAXBContext>
implements IHasConditionalLogger {
    private static final Logger LOGGER = LoggerFactory.getLogger(JAXBContextCache.class);
    private static final ConditionalLogger CONDLOG = new ConditionalLogger(LOGGER, false);
    private static boolean s_bDefaultInstantiated = false;

    public static boolean isSilentMode() {
        return CONDLOG.isDisabled();
    }

    public static boolean setSilentMode(boolean bSilentMode) {
        return !CONDLOG.setEnabled(!bSilentMode);
    }

    private JAXBContextCache() {
        super(aCacheKey -> aCacheKey.createJAXBContext(CONDLOG), 500, JAXBContextCache.class.getName());
    }

    public static boolean isInstantiated() {
        return s_bDefaultInstantiated;
    }

    @Nonnull
    public static JAXBContextCache getInstance() {
        JAXBContextCache ret = SingletonHolder.INSTANCE;
        s_bDefaultInstantiated = true;
        return ret;
    }

    @Nullable
    @Deprecated(forRemoval=true, since="11.0.4")
    public JAXBContext getFromCache(@Nonnull Package aPackage) {
        return (JAXBContext)this.getFromCache(JAXBContextCacheKey.createForPackage(aPackage));
    }

    @Nullable
    @Deprecated(forRemoval=true, since="11.0.4")
    public JAXBContext getFromCache(@Nonnull Package aPackage, @Nullable ClassLoader aClassLoader) {
        return (JAXBContext)this.getFromCache(JAXBContextCacheKey.createForPackage(aPackage, aClassLoader));
    }

    @Nullable
    @Deprecated(forRemoval=true, since="11.0.4")
    public JAXBContext getFromCache(@Nonnull Class<?> aClass) {
        return (JAXBContext)this.getFromCache(JAXBContextCacheKey.createForClass(aClass));
    }

    @Nullable
    @Deprecated(forRemoval=true, since="11.0.4")
    public JAXBContext getFromCache(@Nonnull Class<?> aClass, @Nullable ClassLoader aClassLoader) {
        return (JAXBContext)this.getFromCache(JAXBContextCacheKey.createForClass(aClass, aClassLoader));
    }

    @Nullable
    @Deprecated(forRemoval=true, since="11.0.4")
    public JAXBContext getFromCache(@Nonnull ICommonsList<Class<?>> aClasses) {
        return (JAXBContext)this.getFromCache(JAXBContextCacheKey.createForClasses(aClasses));
    }

    @Nullable
    @Deprecated(forRemoval=true, since="11.0.4")
    public JAXBContext getFromCache(@Nonnull ICommonsList<Class<?>> aClasses, @Nullable Map<String, ?> aProperties) {
        return (JAXBContext)this.getFromCache(JAXBContextCacheKey.createForClasses(aClasses, aProperties));
    }

    @Nonnull
    @Deprecated(forRemoval=true, since="11.0.4")
    public EChange removeFromCache(@Nonnull Package aPackage) {
        return this.removeFromCache(JAXBContextCacheKey.createForPackage(aPackage));
    }

    @Nonnull
    @Deprecated(forRemoval=true, since="11.0.4")
    public EChange removeFromCache(@Nonnull Package aPackage, @Nullable ClassLoader aClassLoader) {
        return this.removeFromCache(JAXBContextCacheKey.createForPackage(aPackage, aClassLoader));
    }

    @Nonnull
    @Deprecated(forRemoval=true, since="11.0.4")
    public EChange removeFromCache(@Nonnull ICommonsList<Class<?>> aClasses) {
        return this.removeFromCache(JAXBContextCacheKey.createForClasses(aClasses));
    }

    @Nonnull
    @Deprecated(forRemoval=true, since="11.0.4")
    public EChange removeFromCache(@Nonnull ICommonsList<Class<?>> aClasses, @Nullable Map<String, ?> aProperties) {
        return this.removeFromCache(JAXBContextCacheKey.createForClasses(aClasses, aProperties));
    }

    private static final class SingletonHolder {
        static final JAXBContextCache INSTANCE = new JAXBContextCache();

        private SingletonHolder() {
        }
    }
}

