/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.ClassLoaderHelper;
import com.helger.commons.lang.GenericReflection;
import com.helger.commons.log.ConditionalLogger;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import java.lang.ref.WeakReference;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
@MustImplementEqualsAndHashcode
public class JAXBContextCacheKey {
    private static final Logger LOGGER = LoggerFactory.getLogger(JAXBContextCacheKey.class);
    private final ICommonsList<Package> m_aPackages;
    private final WeakReference<ClassLoader> m_aClassLoader;
    private final ICommonsList<WeakReference<Class<?>>> m_aClasses;
    private final Map<String, ?> m_aProperties;
    private final String m_sEqualsHashCodeKey;

    @Deprecated(forRemoval=true, since="11.0.4")
    public JAXBContextCacheKey(@Nonnull Package aPackage, @Nullable ClassLoader aClassLoader) {
        this((ICommonsList<Package>)new CommonsArrayList((Object)aPackage), aClassLoader);
    }

    public JAXBContextCacheKey(@Nonnull ICommonsList<Package> aPackages, @Nullable ClassLoader aClassLoader) {
        ValueEnforcer.notEmptyNoNullValue(aPackages, (String)"Packages");
        this.m_aPackages = (ICommonsList)aPackages.getClone();
        this.m_aClassLoader = new WeakReference<ClassLoader>(aClassLoader);
        this.m_aClasses = null;
        this.m_aProperties = null;
        this.m_sEqualsHashCodeKey = StringHelper.imploder().source(aPackages, Package::getName).separator(':').build();
        for (Package aPackage : aPackages) {
            if (aPackage.getAnnotation(XmlSchema.class) != null || GenericReflection.getClassFromNameSafe((String)(aPackage.getName() + ".ObjectFactory")) != null) continue;
            LOGGER.warn("The package '" + aPackage.getName() + "' does not seem to be JAXB generated! Trying to create a JAXBContext anyway.");
        }
    }

    public JAXBContextCacheKey(@Nonnull ICommonsList<Class<?>> aClasses, @Nullable Map<String, ?> aProperties) {
        ValueEnforcer.notEmptyNoNullValue(aClasses, (String)"Classes");
        this.m_aPackages = null;
        this.m_aClassLoader = null;
        this.m_aClasses = new CommonsArrayList(aClasses, WeakReference::new);
        this.m_aProperties = new CommonsHashMap(aProperties);
        this.m_sEqualsHashCodeKey = StringHelper.imploder().source(aClasses, Class::getName).separator(':').build();
    }

    @Nullable
    @ReturnsMutableCopy
    private ICommonsList<Class<?>> _getAllClasses() {
        CommonsArrayList ret = null;
        if (this.m_aClasses != null) {
            ret = new CommonsArrayList();
            for (WeakReference aItem : this.m_aClasses) {
                Class aClass = (Class)aItem.get();
                if (aClass == null) continue;
                ret.add((Object)aClass);
            }
        }
        return ret;
    }

    @Nullable
    private ClassLoader _getClassLoader() {
        ClassLoader ret = null;
        if (this.m_aClassLoader != null) {
            ret = (ClassLoader)this.m_aClassLoader.get();
        }
        return ret != null ? ret : ClassLoaderHelper.getDefaultClassLoader();
    }

    @Nonnull
    private JAXBContext _createFromPackageAndClassLoader(@Nonnull ConditionalLogger aCondLog) {
        ClassLoader aClassLoader = this._getClassLoader();
        aCondLog.info(() -> "Creating JAXB context for packages " + StringHelper.imploder().source(this.m_aPackages, x -> "'" + x.getName() + "'").separator(", ").build() + " using ClassLoader " + aClassLoader.toString());
        try {
            return JAXBContext.newInstance((String)this.m_sEqualsHashCodeKey, (ClassLoader)aClassLoader);
        }
        catch (JAXBException ex) {
            String sMsg = "Failed to create JAXB context for packages " + StringHelper.imploder().source(this.m_aPackages, x -> "'" + x.getName() + "'").separator(", ").build() + " using ClassLoader " + String.valueOf(aClassLoader);
            LOGGER.error(sMsg + ": " + ex.getMessage());
            throw new IllegalArgumentException(sMsg, ex);
        }
    }

    @Nonnull
    private JAXBContext _createFromClassesAndProperties(@Nonnull ConditionalLogger aCondLog) {
        ICommonsList<Class<?>> aClasses = this._getAllClasses();
        aCondLog.info(() -> "Creating JAXB context for classes " + StringHelper.imploder().source((Iterable)aClasses, x -> "'" + x.getName() + "'").separator(", ").build() + (String)(this.m_aProperties.isEmpty() ? "" : " with properties " + String.valueOf(this.m_aProperties.keySet())));
        try {
            Class[] aClassArray = (Class[])aClasses.toArray((Object[])ArrayHelper.EMPTY_CLASS_ARRAY);
            return JAXBContext.newInstance((Class[])aClassArray, this.m_aProperties);
        }
        catch (JAXBException ex) {
            String sMsg = "Failed to create JAXB context for classes " + StringHelper.imploder().source(aClasses, x -> "'" + x.getName() + "'").separator(", ").build() + (String)(this.m_aProperties.isEmpty() ? "" : " with properties " + String.valueOf(this.m_aProperties.keySet()));
            LOGGER.error(sMsg + ": " + ex.getMessage());
            throw new IllegalArgumentException(sMsg, ex);
        }
    }

    @Nonnull
    public JAXBContext createJAXBContext(@Nonnull ConditionalLogger aCondLog) {
        if (this.m_aPackages != null) {
            return this._createFromPackageAndClassLoader(aCondLog);
        }
        return this._createFromClassesAndProperties(aCondLog);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        JAXBContextCacheKey rhs = (JAXBContextCacheKey)o;
        return this.m_sEqualsHashCodeKey.equals(rhs.m_sEqualsHashCodeKey) && EqualsHelper.equals((Object)this._getClassLoader(), (Object)rhs._getClassLoader()) && EqualsHelper.equals(this.m_aProperties, rhs.m_aProperties);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sEqualsHashCodeKey).append((Object)this._getClassLoader()).append(this.m_aProperties).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIfNotNull("Packages", this.m_aPackages).appendIfNotNull("ClassLoader", this.m_aClassLoader).appendIfNotNull("Classes", this.m_aClasses).appendIfNotNull("Properties", this.m_aProperties).appendIfNotNull("EqualsHashCodeKey", (Object)this.m_sEqualsHashCodeKey).getToString();
    }

    @Nonnull
    public static JAXBContextCacheKey createForPackage(@Nonnull Package aPackage) {
        return JAXBContextCacheKey.createForPackage(aPackage, null);
    }

    @Nonnull
    public static JAXBContextCacheKey createForPackage(@Nonnull Package aPackage, @Nullable ClassLoader aClassLoader) {
        ValueEnforcer.notNull((Object)aPackage, (String)"Package");
        return new JAXBContextCacheKey((ICommonsList<Package>)new CommonsArrayList((Object)aPackage), aClassLoader);
    }

    @Nonnull
    public static JAXBContextCacheKey createForPackages(@Nonnull ICommonsList<Package> aPackages) {
        return JAXBContextCacheKey.createForPackages(aPackages, null);
    }

    @Nonnull
    public static JAXBContextCacheKey createForPackages(Package ... aPackages) {
        return JAXBContextCacheKey.createForPackages((ICommonsList<Package>)new CommonsArrayList((Object[])aPackages), null);
    }

    @Nonnull
    public static JAXBContextCacheKey createForPackages(@Nonnull ICommonsList<Package> aPackages, @Nullable ClassLoader aClassLoader) {
        return new JAXBContextCacheKey(aPackages, aClassLoader);
    }

    @Nonnull
    public static JAXBContextCacheKey createForClass(@Nonnull Class<?> aClass) {
        return JAXBContextCacheKey.createForClass(aClass, null);
    }

    @Nonnull
    public static JAXBContextCacheKey createForClass(@Nonnull Class<?> aClass, @Nullable ClassLoader aClassLoader) {
        ValueEnforcer.notNull(aClass, (String)"Class");
        Package aPackage = aClass.getPackage();
        if (aPackage.getAnnotation(XmlSchema.class) != null) {
            return JAXBContextCacheKey.createForPackage(aPackage, aClassLoader);
        }
        return new JAXBContextCacheKey((ICommonsList<Class<?>>)new CommonsArrayList(aClass), (Map)null);
    }

    @Nonnull
    public static JAXBContextCacheKey createForClasses(@Nonnull ICommonsList<Class<?>> aClasses) {
        return JAXBContextCacheKey.createForClasses(aClasses, null);
    }

    @Nonnull
    public static JAXBContextCacheKey createForClasses(Class<?> ... aClasses) {
        return JAXBContextCacheKey.createForClasses(new CommonsArrayList((Object[])aClasses), null);
    }

    @Nonnull
    public static JAXBContextCacheKey createForClasses(@Nonnull ICommonsList<Class<?>> aClasses, @Nullable Map<String, ?> aProperties) {
        ValueEnforcer.notEmptyNoNullValue(aClasses, (String)"Classes");
        return new JAXBContextCacheKey(aClasses, aProperties);
    }
}

