/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb;

import com.helger.jaxb.JAXBNamespacePrefixMapper;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.namespace.NamespaceContext;

@Immutable
public final class JAXBMarshallerHelper {
    private static final String JAXB_EXTERNAL_CLASS_NAME = "com.sun.xml.bind.v2.runtime.MarshallerImpl";
    private static final String JAKARTA_INDENT_STRING = "com.sun.xml.bind.indentString";
    private static final String JAKARTA_PREFIX_MAPPER = "com.sun.xml.bind.namespacePrefixMapper";
    private static final String JAKARTA_ENCODING_HANDLER2 = "com.sun.xml.bind.marshaller.CharacterEscapeHandler";
    private static final String JAKARTA_XML_HEADERS = "com.sun.xml.bind.xmlHeaders";
    private static final String JAKARTA_C14N = "com.sun.xml.bind.c14n";
    private static final String JAKARTA_OBJECT_IDENTITY_CYCLE_DETECTION = "com.sun.xml.bind.objectIdentitityCycleDetection";

    private JAXBMarshallerHelper() {
    }

    private static void _setProperty(@Nonnull Marshaller aMarshaller, @Nonnull String sPropertyName, @Nullable Object aValue) {
        try {
            aMarshaller.setProperty(sPropertyName, aValue);
        }
        catch (PropertyException ex) {
            throw new IllegalArgumentException("Failed to set JAXB property '" + sPropertyName + "' to " + String.valueOf(aValue), ex);
        }
    }

    @Nullable
    private static Object _getProperty(@Nonnull Marshaller aMarshaller, @Nonnull String sPropertyName) {
        try {
            return aMarshaller.getProperty(sPropertyName);
        }
        catch (PropertyException ex) {
            throw new IllegalArgumentException("Failed to get JAXB property '" + sPropertyName + "'", ex);
        }
    }

    private static boolean _getBooleanProperty(@Nonnull Marshaller aMarshaller, @Nonnull String sPropertyName) {
        return (Boolean)JAXBMarshallerHelper._getProperty(aMarshaller, sPropertyName);
    }

    @Nullable
    private static String _getStringProperty(@Nonnull Marshaller aMarshaller, @Nonnull String sPropertyName) {
        return (String)JAXBMarshallerHelper._getProperty(aMarshaller, sPropertyName);
    }

    @Nullable
    public static String getEncoding(@Nonnull Marshaller aMarshaller) {
        return JAXBMarshallerHelper._getStringProperty(aMarshaller, "jaxb.encoding");
    }

    public static void setEncoding(@Nonnull Marshaller aMarshaller, @Nullable Charset aEncoding) {
        JAXBMarshallerHelper.setEncoding(aMarshaller, aEncoding == null ? null : aEncoding.name());
    }

    public static void setEncoding(@Nonnull Marshaller aMarshaller, @Nullable String sEncoding) {
        JAXBMarshallerHelper._setProperty(aMarshaller, "jaxb.encoding", sEncoding);
    }

    public static boolean isFormattedOutput(@Nonnull Marshaller aMarshaller) {
        return JAXBMarshallerHelper._getBooleanProperty(aMarshaller, "jaxb.formatted.output");
    }

    public static void setFormattedOutput(@Nonnull Marshaller aMarshaller, boolean bFormattedOutput) {
        JAXBMarshallerHelper._setProperty(aMarshaller, "jaxb.formatted.output", bFormattedOutput);
    }

    @Nullable
    public static String getSchemaLocation(@Nonnull Marshaller aMarshaller) {
        return JAXBMarshallerHelper._getStringProperty(aMarshaller, "jaxb.schemaLocation");
    }

    public static void setSchemaLocation(@Nonnull Marshaller aMarshaller, @Nullable String sSchemaLocation) {
        JAXBMarshallerHelper._setProperty(aMarshaller, "jaxb.schemaLocation", sSchemaLocation);
    }

    @Nullable
    public static String getNoNamespaceSchemaLocation(@Nonnull Marshaller aMarshaller) {
        return JAXBMarshallerHelper._getStringProperty(aMarshaller, "jaxb.noNamespaceSchemaLocation");
    }

    public static void setNoNamespaceSchemaLocation(@Nonnull Marshaller aMarshaller, @Nullable String sSchemaLocation) {
        JAXBMarshallerHelper._setProperty(aMarshaller, "jaxb.noNamespaceSchemaLocation", sSchemaLocation);
    }

    public static boolean isFragment(@Nonnull Marshaller aMarshaller) {
        return JAXBMarshallerHelper._getBooleanProperty(aMarshaller, "jaxb.fragment");
    }

    public static void setFragment(@Nonnull Marshaller aMarshaller, boolean bFragment) {
        JAXBMarshallerHelper._setProperty(aMarshaller, "jaxb.fragment", bFragment);
    }

    @Nullable
    public static String getJakartaIndentString(@Nonnull Marshaller aMarshaller) {
        return JAXBMarshallerHelper._getStringProperty(aMarshaller, JAKARTA_INDENT_STRING);
    }

    public static void setJakartaIndentString(@Nonnull Marshaller aMarshaller, @Nullable String sIndentString) {
        JAXBMarshallerHelper._setProperty(aMarshaller, JAKARTA_INDENT_STRING, sIndentString);
    }

    @Nullable
    public static Object getJakartaCharacterEscapeHandler(@Nonnull Marshaller aMarshaller) {
        return JAXBMarshallerHelper._getProperty(aMarshaller, JAKARTA_ENCODING_HANDLER2);
    }

    public static void setJakartaCharacterEscapeHandler(@Nonnull Marshaller aMarshaller, @Nonnull Object aCharacterEscapeHandler) {
        JAXBMarshallerHelper._setProperty(aMarshaller, JAKARTA_ENCODING_HANDLER2, aCharacterEscapeHandler);
    }

    @Nullable
    public static JAXBNamespacePrefixMapper getJakartaNamespacePrefixMapper(@Nonnull Marshaller aMarshaller) {
        return (JAXBNamespacePrefixMapper)((Object)JAXBMarshallerHelper._getProperty(aMarshaller, JAKARTA_PREFIX_MAPPER));
    }

    public static void setJakartaNamespacePrefixMapper(@Nonnull Marshaller aMarshaller, @Nonnull NamespaceContext aNamespaceContext) {
        JAXBNamespacePrefixMapper aNamespacePrefixMapper = new JAXBNamespacePrefixMapper(aNamespaceContext);
        JAXBMarshallerHelper.setJakartaNamespacePrefixMapper(aMarshaller, aNamespacePrefixMapper);
    }

    public static void setJakartaNamespacePrefixMapper(@Nonnull Marshaller aMarshaller, @Nonnull JAXBNamespacePrefixMapper aNamespacePrefixMapper) {
        JAXBMarshallerHelper._setProperty(aMarshaller, JAKARTA_PREFIX_MAPPER, (Object)aNamespacePrefixMapper);
    }

    @Nullable
    public static String getJakartaXMLHeaders(@Nonnull Marshaller aMarshaller) {
        return JAXBMarshallerHelper._getStringProperty(aMarshaller, JAKARTA_XML_HEADERS);
    }

    public static void setJakartaXMLHeaders(@Nonnull Marshaller aMarshaller, @Nonnull String sXMLHeaders) {
        JAXBMarshallerHelper._setProperty(aMarshaller, JAKARTA_XML_HEADERS, sXMLHeaders);
    }

    public static boolean isJakartaCanonicalization(@Nonnull Marshaller aMarshaller) {
        return JAXBMarshallerHelper._getBooleanProperty(aMarshaller, JAKARTA_C14N);
    }

    public static void setJakartaCanonicalization(@Nonnull Marshaller aMarshaller, boolean bCanonicalize) {
        JAXBMarshallerHelper._setProperty(aMarshaller, JAKARTA_C14N, bCanonicalize);
    }

    public static boolean isJakartaObjectIdentityCycleDetection(@Nonnull Marshaller aMarshaller) {
        return JAXBMarshallerHelper._getBooleanProperty(aMarshaller, JAKARTA_OBJECT_IDENTITY_CYCLE_DETECTION);
    }

    public static void setJakartaObjectIdentityCycleDetection(@Nonnull Marshaller aMarshaller, boolean bObjectIdentityCycleDetection) {
        JAXBMarshallerHelper._setProperty(aMarshaller, JAKARTA_OBJECT_IDENTITY_CYCLE_DETECTION, bObjectIdentityCycleDetection);
    }

    public static boolean isJakartaJAXBMarshaller(@Nullable Marshaller aMarshaller) {
        if (aMarshaller == null) {
            return false;
        }
        String sClassName = aMarshaller.getClass().getName();
        return sClassName.equals(JAXB_EXTERNAL_CLASS_NAME);
    }
}

