/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb;

import com.helger.commons.callback.exception.IExceptionCallback;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshalException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXParseException;

@Immutable
public class LoggingJAXBReadExceptionHandler
implements IExceptionCallback<JAXBException> {
    public static final LoggingJAXBReadExceptionHandler INSTANCE = new LoggingJAXBReadExceptionHandler();
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingJAXBReadExceptionHandler.class);

    public void onException(@Nonnull JAXBException ex) {
        if (ex instanceof UnmarshalException) {
            Throwable aLinked = ((UnmarshalException)ex).getLinkedException();
            if (aLinked instanceof SAXParseException) {
                LOGGER.error("Failed to parse XML document: " + aLinked.getMessage());
            } else {
                LOGGER.error("Unmarshal exception reading document", (Throwable)ex);
            }
        } else {
            LOGGER.warn("JAXB Exception reading document", (Throwable)ex);
        }
    }
}

