/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb.builder;

import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.jaxb.validation.LoggingValidationEventHandler;
import com.helger.xml.serialize.write.XMLWriterSettings;
import java.nio.charset.Charset;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.namespace.NamespaceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class JAXBBuilderDefaultSettings {
    private static final Logger LOGGER = LoggerFactory.getLogger(JAXBBuilderDefaultSettings.class);
    public static final boolean DEFAULT_USE_CONTEXT_CACHE = true;
    public static final ValidationEventHandler DEFAULT_VALIDATION_EVENT_HANDLER = LoggingValidationEventHandler.DEFAULT_INSTANCE;
    public static final boolean DEFAULT_FORMATTED_OUTPUT = false;
    public static final Charset DEFAULT_CHARSET = XMLWriterSettings.DEFAULT_XML_CHARSET_OBJ;
    public static final boolean DEFAULT_USE_SCHEMA = true;
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    @GuardedBy(value="RW_LOCK")
    private static boolean s_bUseContextCache = true;
    @GuardedBy(value="RW_LOCK")
    private static ValidationEventHandler s_aEventHandler = DEFAULT_VALIDATION_EVENT_HANDLER;
    @GuardedBy(value="RW_LOCK")
    private static NamespaceContext s_aNamespaceContext;
    @GuardedBy(value="RW_LOCK")
    private static boolean s_bFormattedOutput;
    @GuardedBy(value="RW_LOCK")
    private static Charset s_aCharset;
    @GuardedBy(value="RW_LOCK")
    private static String s_sIndentString;
    @GuardedBy(value="RW_LOCK")
    private static boolean s_bUseSchema;
    @GuardedBy(value="RW_LOCK")
    private static String s_sSchemaLocation;
    @GuardedBy(value="RW_LOCK")
    private static String s_sNoNamespaceSchemaLocation;

    private JAXBBuilderDefaultSettings() {
    }

    public static boolean isDefaultUseContextCache() {
        return RW_LOCK.readLockedBoolean(() -> s_bUseContextCache);
    }

    public static void setDefaultUseContextCache(boolean bUseContextCache) {
        LOGGER.info("The default JAXB Context Cache is now " + (bUseContextCache ? "enabled" : "disabled"));
        RW_LOCK.writeLocked(() -> {
            s_bUseContextCache = bUseContextCache;
        });
    }

    @Nullable
    public static ValidationEventHandler getDefaultValidationEventHandler() {
        return (ValidationEventHandler)RW_LOCK.readLockedGet(() -> s_aEventHandler);
    }

    public static void setDefaultValidationEventHandler(@Nullable ValidationEventHandler aEventHandler) {
        LOGGER.info("The default JAXB Validation Event Handler is now " + String.valueOf(aEventHandler));
        RW_LOCK.writeLocked(() -> {
            s_aEventHandler = aEventHandler;
        });
    }

    @Nullable
    public static NamespaceContext getDefaultNamespaceContext() {
        return (NamespaceContext)RW_LOCK.readLockedGet(() -> s_aNamespaceContext);
    }

    public static void setDefaultNamespaceContext(@Nullable NamespaceContext aNamespaceContext) {
        LOGGER.info("The default JAXB XML Namespace Context is now " + String.valueOf(aNamespaceContext));
        RW_LOCK.writeLocked(() -> {
            s_aNamespaceContext = aNamespaceContext;
        });
    }

    public static boolean isDefaultFormattedOutput() {
        return RW_LOCK.readLockedBoolean(() -> s_bFormattedOutput);
    }

    public static void setDefaultFormattedOutput(boolean bFormattedOutput) {
        LOGGER.info("The default JAXB XML output is now " + (bFormattedOutput ? "formatted" : "unformatted"));
        RW_LOCK.writeLocked(() -> {
            s_bFormattedOutput = bFormattedOutput;
        });
    }

    @Nullable
    public static Charset getDefaultCharset() {
        return (Charset)RW_LOCK.readLockedGet(() -> s_aCharset);
    }

    public static void setDefaultCharset(@Nullable Charset aCharset) {
        LOGGER.info("The default JAXB Charset is now " + (String)(aCharset == null ? "null" : "'" + aCharset.name() + "'"));
        RW_LOCK.writeLocked(() -> {
            s_aCharset = aCharset;
        });
    }

    @Nullable
    public static String getDefaultIndentString() {
        return (String)RW_LOCK.readLockedGet(() -> s_sIndentString);
    }

    @Nullable
    private static String _getNice(@Nullable String s) {
        if (s == null) {
            return null;
        }
        char[] aChars = s.toCharArray();
        if (aChars.length == 0) {
            return "";
        }
        StringBuilder ret = new StringBuilder(aChars.length * 3);
        for (char c : aChars) {
            if (c == '\f') {
                ret.append("\\f");
                continue;
            }
            if (c == '\n') {
                ret.append("\\n");
                continue;
            }
            if (c == '\r') {
                ret.append("\\r");
                continue;
            }
            if (c == '\t') {
                ret.append("\\t");
                continue;
            }
            ret.append(c);
        }
        return ret.toString();
    }

    public static void setDefaultIndentString(@Nullable String sIndentString) {
        LOGGER.info("The default JAXB Indent String is now '" + JAXBBuilderDefaultSettings._getNice(sIndentString) + "'");
        RW_LOCK.writeLocked(() -> {
            s_sIndentString = sIndentString;
        });
    }

    public static boolean isDefaultUseSchema() {
        return RW_LOCK.readLockedBoolean(() -> s_bUseSchema);
    }

    public static void setDefaultUseSchema(boolean bUseSchema) {
        LOGGER.info("The default JAXB XML Schema usage is now " + (bUseSchema ? "enabled" : "disabled"));
        RW_LOCK.writeLocked(() -> {
            s_bUseSchema = bUseSchema;
        });
    }

    @Nullable
    public static String getDefaultSchemaLocation() {
        return (String)RW_LOCK.readLockedGet(() -> s_sSchemaLocation);
    }

    public static void setDefaultSchemaLocation(@Nullable String sSchemaLocation) {
        LOGGER.info("The default JAXB XML Schema Location is now " + (String)(sSchemaLocation == null ? "null" : "'" + sSchemaLocation + "'"));
        RW_LOCK.writeLocked(() -> {
            s_sSchemaLocation = sSchemaLocation;
        });
    }

    @Nullable
    public static String getDefaultNoNamespaceSchemaLocation() {
        return (String)RW_LOCK.readLockedGet(() -> s_sNoNamespaceSchemaLocation);
    }

    public static void setDefaultNoNamespaceSchemaLocation(@Nullable String sNoNamespaceSchemaLocation) {
        LOGGER.info("The default JAXB XML Schema No-Namespace Schema Location is now " + (String)(sNoNamespaceSchemaLocation == null ? "null" : "'" + sNoNamespaceSchemaLocation + "'"));
        RW_LOCK.writeLocked(() -> {
            s_sNoNamespaceSchemaLocation = sNoNamespaceSchemaLocation;
        });
    }

    static {
        s_bFormattedOutput = false;
        s_aCharset = DEFAULT_CHARSET;
        s_bUseSchema = true;
    }
}

