/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb.builder;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.jaxb.builder.IJAXBDocumentType;
import com.helger.xml.schema.XMLSchemaCache;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchema;
import javax.xml.bind.annotation.XmlType;
import javax.xml.validation.Schema;

@Deprecated(forRemoval=true, since="11.0.3")
@NotThreadSafe
public class JAXBDocumentType
implements IJAXBDocumentType {
    public static final String JAXB_DEFAULT = "##default";
    private final Class<?> m_aClass;
    private final ICommonsList<ClassPathResource> m_aXSDs = new CommonsArrayList();
    private Supplier<XMLSchemaCache> m_aXMLSchemaCacheProvider = XMLSchemaCache::getInstance;
    private final String m_sNamespaceURI;
    private final String m_sLocalName;
    private Schema m_aCachedSchema;

    public JAXBDocumentType(@Nonnull Class<?> aClass, @Nullable List<? extends ClassPathResource> aXSDs, @Nullable Function<? super String, ? extends String> aTypeToElementNameMapper) {
        String sLocalName;
        String sNamespaceURI;
        XmlType aXmlType;
        ValueEnforcer.notNull(aClass, (String)"Class");
        if (aXSDs != null) {
            ValueEnforcer.notEmptyNoNullValue(aXSDs, (String)"XSDs");
            for (ClassPathResource classPathResource : aXSDs) {
                ValueEnforcer.isTrue((boolean)classPathResource.hasClassLoader(), () -> "ClassPathResource " + String.valueOf(aRes) + " MUST define its ClassLoader!");
            }
        }
        if ((aXmlType = aClass.getAnnotation(XmlType.class)) == null) {
            throw new IllegalArgumentException("The passed class '" + aClass.getName() + "' does not have an @XmlType annotation!");
        }
        Package package_ = aClass.getPackage();
        XmlSchema aXmlSchema = package_.getAnnotation(XmlSchema.class);
        if (aXmlSchema != null && aXmlSchema.namespace() == null) {
            throw new IllegalArgumentException("The package '" + package_.getName() + "' has no namespace URI in the @XmlSchema annotation!");
        }
        XmlRootElement aRootElement = aClass.getAnnotation(XmlRootElement.class);
        if (aRootElement != null) {
            sNamespaceURI = aRootElement.namespace();
            if (JAXB_DEFAULT.equals(sNamespaceURI) && aXmlSchema != null) {
                sNamespaceURI = aXmlSchema.namespace();
            }
            if (JAXB_DEFAULT.equals(sLocalName = aRootElement.name())) {
                sLocalName = aXmlType.name();
            }
        } else {
            sNamespaceURI = aXmlSchema != null ? aXmlSchema.namespace() : null;
            sLocalName = aXmlType.name();
        }
        if (aTypeToElementNameMapper != null) {
            sLocalName = aTypeToElementNameMapper.apply(sLocalName);
        }
        if (StringHelper.hasNoText((String)sLocalName)) {
            throw new IllegalArgumentException("Failed to determine the local name of the element to be created!");
        }
        this.m_aClass = aClass;
        if (aXSDs != null) {
            this.m_aXSDs.addAll(aXSDs);
        }
        this.m_sNamespaceURI = StringHelper.getNotNull((String)sNamespaceURI);
        this.m_sLocalName = sLocalName;
    }

    public JAXBDocumentType(@Nonnull Class<?> aClass, @Nullable List<? extends ClassPathResource> aXSDs, @Nullable String sNamespaceURI, @Nonnull @Nonempty String sLocalName) {
        ValueEnforcer.notNull(aClass, (String)"Class");
        if (aXSDs != null) {
            ValueEnforcer.notEmptyNoNullValue(aXSDs, (String)"XSDs");
            for (ClassPathResource classPathResource : aXSDs) {
                ValueEnforcer.isTrue((boolean)classPathResource.hasClassLoader(), () -> "ClassPathResource " + String.valueOf(aRes) + " MUST define its ClassLoader!");
            }
        }
        ValueEnforcer.notEmpty((CharSequence)sLocalName, (String)"sLocalName");
        XmlType aXmlType = aClass.getAnnotation(XmlType.class);
        if (aXmlType == null) {
            throw new IllegalArgumentException("The passed class '" + aClass.getName() + "' does not have an @XmlType annotation!");
        }
        Package package_ = aClass.getPackage();
        XmlSchema aXmlSchema = package_.getAnnotation(XmlSchema.class);
        if (aXmlSchema != null && aXmlSchema.namespace() == null) {
            throw new IllegalArgumentException("The package '" + package_.getName() + "' has no namespace URI in the @XmlSchema annotation!");
        }
        this.m_aClass = aClass;
        if (aXSDs != null) {
            this.m_aXSDs.addAll(aXSDs);
        }
        this.m_sNamespaceURI = sNamespaceURI;
        this.m_sLocalName = sLocalName;
    }

    @Override
    @Nonnull
    public final Class<?> getImplementationClass() {
        return this.m_aClass;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsList<ClassPathResource> getAllXSDResources() {
        return (ICommonsList)this.m_aXSDs.getClone();
    }

    @Nonnull
    public final Supplier<XMLSchemaCache> getXMLSchemaCacheProvider() {
        return this.m_aXMLSchemaCacheProvider;
    }

    @Nonnull
    public final JAXBDocumentType setXMLSchemaCacheProvider(@Nonnull Supplier<XMLSchemaCache> aXMLSchemaCacheProvider) {
        ValueEnforcer.notNull(aXMLSchemaCacheProvider, (String)"SchemaCacheProvider");
        this.m_aXMLSchemaCacheProvider = aXMLSchemaCacheProvider;
        return this;
    }

    @Override
    @Nonnull
    public final String getNamespaceURI() {
        return this.m_sNamespaceURI;
    }

    @Override
    @Nonnull
    @Nonempty
    public final String getLocalName() {
        return this.m_sLocalName;
    }

    @Override
    @Nullable
    public Schema getSchema() {
        if (this.m_aXSDs.isEmpty()) {
            return null;
        }
        if (this.m_aCachedSchema == null) {
            XMLSchemaCache aSchemaCache = this.m_aXMLSchemaCacheProvider.get();
            if (aSchemaCache == null) {
                throw new IllegalStateException("Failed to get an instance of XMLSchemaCache from " + String.valueOf(this.m_aXMLSchemaCacheProvider));
            }
            this.m_aCachedSchema = aSchemaCache.getSchema(this.m_aXSDs);
        }
        return this.m_aCachedSchema;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        JAXBDocumentType rhs = (JAXBDocumentType)o;
        return this.m_aClass.equals(rhs.m_aClass) && this.m_aXSDs.equals(rhs.m_aXSDs);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aClass).append(this.m_aXSDs).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Class", this.m_aClass).append("XSDPaths", this.m_aXSDs).append("XMLSchemaCacheProvider", this.m_aXMLSchemaCacheProvider).append("NamespaceURI", (Object)this.m_sNamespaceURI).append("LocalName", (Object)this.m_sLocalName).getToString();
    }
}

