/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb.builder;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.callback.ICallback;
import com.helger.commons.lang.GenericReflection;
import com.helger.commons.string.ToStringGenerator;
import com.helger.jaxb.IJAXBReader;
import com.helger.jaxb.IJAXBUnmarshaller;
import com.helger.jaxb.LoggingJAXBReadExceptionHandler;
import com.helger.jaxb.builder.AbstractJAXBBuilder;
import com.helger.jaxb.builder.IJAXBDocumentType;
import com.helger.jaxb.builder.JAXBBuilderDefaultSettings;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.validation.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(forRemoval=true, since="11.0.0")
@NotThreadSafe
public class JAXBReaderBuilder<JAXBTYPE, IMPLTYPE extends JAXBReaderBuilder<JAXBTYPE, IMPLTYPE>>
extends AbstractJAXBBuilder<IMPLTYPE>
implements IJAXBReader<JAXBTYPE> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JAXBReaderBuilder.class);
    private final Class<JAXBTYPE> m_aImplClass;
    private ValidationEventHandler m_aEventHandler = JAXBBuilderDefaultSettings.getDefaultValidationEventHandler();
    private Consumer<? super Unmarshaller> m_aUnmarshallerCustomizer;

    public JAXBReaderBuilder(@Nonnull IJAXBDocumentType aDocType) {
        this(aDocType, (Class)GenericReflection.uncheckedCast(aDocType.getImplementationClass()));
    }

    public JAXBReaderBuilder(@Nonnull IJAXBDocumentType aDocType, @Nonnull Class<JAXBTYPE> aImplClass) {
        super(aDocType);
        this.m_aImplClass = (Class)ValueEnforcer.notNull(aImplClass, (String)"ImplClass");
        this.exceptionCallbacks().add((ICallback)new LoggingJAXBReadExceptionHandler());
    }

    @Nonnull
    protected final Class<JAXBTYPE> getImplClass() {
        return this.m_aImplClass;
    }

    @Nullable
    public final ValidationEventHandler getValidationEventHandler() {
        return this.m_aEventHandler;
    }

    @Nonnull
    public final IMPLTYPE setValidationEventHandler(@Nullable ValidationEventHandler aEventHandler) {
        this.m_aEventHandler = aEventHandler;
        return (IMPLTYPE)((JAXBReaderBuilder)this.thisAsT());
    }

    @Nullable
    public final Consumer<? super Unmarshaller> getUnmarshallerCustomizer() {
        return this.m_aUnmarshallerCustomizer;
    }

    @Nonnull
    public final IMPLTYPE setUnmarshallerCustomizer(@Nullable Consumer<? super Unmarshaller> aUnmarshallerCustomizer) {
        this.m_aUnmarshallerCustomizer = aUnmarshallerCustomizer;
        return (IMPLTYPE)((JAXBReaderBuilder)this.thisAsT());
    }

    @Nonnull
    protected Unmarshaller createUnmarshaller() throws JAXBException {
        Schema aSchema;
        JAXBContext aJAXBContext = this.getJAXBContext();
        Unmarshaller aUnmarshaller = aJAXBContext.createUnmarshaller();
        if (this.m_aEventHandler != null) {
            aUnmarshaller.setEventHandler(this.m_aEventHandler);
        }
        if ((aSchema = this.getSchema()) != null) {
            aUnmarshaller.setSchema(aSchema);
        }
        return aUnmarshaller;
    }

    @Override
    @Nullable
    public JAXBTYPE read(@Nonnull IJAXBUnmarshaller<JAXBTYPE> aHandler) {
        ValueEnforcer.notNull(aHandler, (String)"Handler");
        Schema aSchema = this.getSchema();
        if (aSchema == null && this.isUseSchema()) {
            LOGGER.warn("Don't know how to read JAXB document of type " + this.m_aImplClass.getName());
        }
        Object ret = null;
        try {
            JAXBElement<JAXBTYPE> aElement;
            Unmarshaller aUnmarshaller = this.createUnmarshaller();
            if (this.m_aUnmarshallerCustomizer != null) {
                this.m_aUnmarshallerCustomizer.accept((Unmarshaller)aUnmarshaller);
            }
            if ((ret = (aElement = aHandler.doUnmarshal(aUnmarshaller, this.m_aImplClass)).getValue()) == null) {
                throw new IllegalStateException("Failed to read JAXB document of class " + this.m_aImplClass.getName() + " - without exception!");
            }
        }
        catch (JAXBException ex) {
            this.exceptionCallbacks().forEach(x -> x.onException((Throwable)ex));
        }
        return (JAXBTYPE)ret;
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("ImplClass", this.m_aImplClass).append("EventHandler", (Object)this.m_aEventHandler).append("UnmarshallerCustomizer", this.m_aUnmarshallerCustomizer).getToString();
    }
}

