/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb.builder;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.state.ESuccess;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.jaxb.IJAXBMarshaller;
import com.helger.jaxb.IJAXBWriter;
import com.helger.jaxb.JAXBMarshallerHelper;
import com.helger.jaxb.builder.AbstractWritingJAXBBuilder;
import com.helger.jaxb.builder.IJAXBDocumentType;
import com.helger.jaxb.builder.JAXBBuilderDefaultSettings;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.namespace.NamespaceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(forRemoval=true, since="11.0.0")
@NotThreadSafe
public class JAXBWriterBuilder<JAXBTYPE, IMPLTYPE extends JAXBWriterBuilder<JAXBTYPE, IMPLTYPE>>
extends AbstractWritingJAXBBuilder<JAXBTYPE, IMPLTYPE>
implements IJAXBWriter<JAXBTYPE> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JAXBWriterBuilder.class);
    private ValidationEventHandler m_aEventHandler = JAXBBuilderDefaultSettings.getDefaultValidationEventHandler();
    private NamespaceContext m_aNSContext = JAXBBuilderDefaultSettings.getDefaultNamespaceContext();
    private boolean m_bFormattedOutput = JAXBBuilderDefaultSettings.isDefaultFormattedOutput();
    private Charset m_aCharset = JAXBBuilderDefaultSettings.getDefaultCharset();
    private String m_sIndentString = JAXBBuilderDefaultSettings.getDefaultIndentString();
    private String m_sSchemaLocation = JAXBBuilderDefaultSettings.getDefaultSchemaLocation();
    private String m_sNoNamespaceSchemaLocation = JAXBBuilderDefaultSettings.getDefaultNoNamespaceSchemaLocation();

    public JAXBWriterBuilder(@Nonnull IJAXBDocumentType aDocType) {
        super(aDocType);
    }

    @Nullable
    public ValidationEventHandler getValidationEventHandler() {
        return this.m_aEventHandler;
    }

    @Nonnull
    public final IMPLTYPE setValidationEventHandler(@Nullable ValidationEventHandler aEventHandler) {
        this.m_aEventHandler = aEventHandler;
        return (IMPLTYPE)((JAXBWriterBuilder)this.thisAsT());
    }

    @Override
    @Nullable
    public NamespaceContext getNamespaceContext() {
        return this.m_aNSContext;
    }

    @Nonnull
    public final IMPLTYPE setNamespaceContext(@Nullable NamespaceContext aNSContext) {
        this.m_aNSContext = aNSContext;
        return (IMPLTYPE)((JAXBWriterBuilder)this.thisAsT());
    }

    @Override
    public boolean isFormattedOutput() {
        return this.m_bFormattedOutput;
    }

    @Nonnull
    public final IMPLTYPE setFormattedOutput(boolean bFormattedOutput) {
        this.m_bFormattedOutput = bFormattedOutput;
        return (IMPLTYPE)((JAXBWriterBuilder)this.thisAsT());
    }

    @Override
    @Nullable
    public Charset getCharset() {
        return this.m_aCharset;
    }

    @Nonnull
    public final IMPLTYPE setCharset(@Nullable Charset aCharset) {
        this.m_aCharset = aCharset;
        return (IMPLTYPE)((JAXBWriterBuilder)this.thisAsT());
    }

    @Override
    @Nullable
    public String getIndentString() {
        return this.m_sIndentString;
    }

    @Nonnull
    public final IMPLTYPE setIndentString(@Nullable String sIndentString) {
        this.m_sIndentString = sIndentString;
        return (IMPLTYPE)((JAXBWriterBuilder)this.thisAsT());
    }

    @Override
    @Nullable
    public String getSchemaLocation() {
        return this.m_sSchemaLocation;
    }

    @Nonnull
    public final IMPLTYPE setSchemaLocation(@Nullable String sSchemaLocation) {
        this.m_sSchemaLocation = sSchemaLocation;
        return (IMPLTYPE)((JAXBWriterBuilder)this.thisAsT());
    }

    @Override
    @Nullable
    public String getNoNamespaceSchemaLocation() {
        return this.m_sNoNamespaceSchemaLocation;
    }

    @Nonnull
    public final IMPLTYPE setNoNamespaceSchemaLocation(@Nullable String sNoNamespaceSchemaLocation) {
        this.m_sNoNamespaceSchemaLocation = sNoNamespaceSchemaLocation;
        return (IMPLTYPE)((JAXBWriterBuilder)this.thisAsT());
    }

    @Override
    @Nonnull
    protected Marshaller createMarshaller() throws JAXBException {
        Marshaller aMarshaller = super.createMarshaller();
        if (this.m_aEventHandler != null) {
            aMarshaller.setEventHandler(this.m_aEventHandler);
        }
        if (this.m_aNSContext != null) {
            try {
                JAXBMarshallerHelper.setJakartaNamespacePrefixMapper(aMarshaller, this.m_aNSContext);
            }
            catch (Exception | NoClassDefFoundError ex) {
                LOGGER.error("Failed to set the namespace context " + String.valueOf(this.m_aNSContext) + ": " + ex.getClass().getName() + " -- " + ex.getMessage());
            }
        }
        JAXBMarshallerHelper.setFormattedOutput(aMarshaller, this.m_bFormattedOutput);
        if (this.m_aCharset != null) {
            JAXBMarshallerHelper.setEncoding(aMarshaller, this.m_aCharset);
        }
        if (this.m_sIndentString != null) {
            JAXBMarshallerHelper.setJakartaIndentString(aMarshaller, this.m_sIndentString);
        }
        if (this.m_sSchemaLocation != null) {
            JAXBMarshallerHelper.setSchemaLocation(aMarshaller, this.m_sSchemaLocation);
        }
        if (this.m_sNoNamespaceSchemaLocation != null) {
            JAXBMarshallerHelper.setNoNamespaceSchemaLocation(aMarshaller, this.m_sNoNamespaceSchemaLocation);
        }
        return aMarshaller;
    }

    @Override
    @Nonnull
    public ESuccess write(@Nonnull JAXBTYPE aJAXBDocument, @Nonnull IJAXBMarshaller<JAXBTYPE> aMarshallerFunc) {
        ValueEnforcer.notNull(aJAXBDocument, (String)"JAXBDocument");
        ValueEnforcer.notNull(aMarshallerFunc, (String)"MarshallerFunc");
        try {
            Marshaller aMarshaller = this.createMarshaller();
            Consumer<Marshaller> aCustomizer = this.getMarshallerCustomizer();
            if (aCustomizer != null) {
                aCustomizer.accept(aMarshaller);
            }
            JAXBElement<JAXBTYPE> aJAXBElement = this.createJAXBElement(aJAXBDocument);
            aMarshallerFunc.doMarshal(aMarshaller, aJAXBElement);
            return ESuccess.SUCCESS;
        }
        catch (JAXBException ex) {
            this.exceptionCallbacks().forEach(x -> x.onException((Throwable)ex));
            return ESuccess.FAILURE;
        }
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("EventHandler", (Object)this.m_aEventHandler).append("NamespaceContext", (Object)this.m_aNSContext).append("FormattedOutput", this.m_bFormattedOutput).append("Charset", (Object)this.m_aCharset).append("IndentString", (Object)StringHelper.getHexEncoded((String)this.m_sIndentString, (Charset)StandardCharsets.ISO_8859_1)).append("SchemaLocation", (Object)this.m_sSchemaLocation).append("NoNamespaceSchemaLocation", (Object)this.m_sNoNamespaceSchemaLocation).getToString();
    }
}

