/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb.validation;

import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.error.IError;
import com.helger.commons.error.SingleError;
import com.helger.commons.error.level.EErrorLevel;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.location.ILocation;
import com.helger.commons.location.SimpleLocation;
import com.helger.commons.string.ToStringGenerator;
import com.helger.jaxb.validation.IValidationEventHandler;
import com.helger.xml.serialize.write.XMLWriter;
import java.net.URL;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

@NotThreadSafe
public abstract class AbstractValidationEventHandler
implements IValidationEventHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractValidationEventHandler.class);

    protected AbstractValidationEventHandler() {
    }

    @Nonnull
    @OverrideOnDemand
    protected IErrorLevel getErrorLevel(int nSeverity) {
        switch (nSeverity) {
            case 0: {
                return EErrorLevel.WARN;
            }
            case 1: {
                return EErrorLevel.ERROR;
            }
            case 2: {
                return EErrorLevel.FATAL_ERROR;
            }
        }
        LOGGER.warn("Unknown JAXB validation severity: " + nSeverity + "; defaulting to error");
        return EErrorLevel.ERROR;
    }

    @Nullable
    @OverrideOnDemand
    protected String getLocationResourceID(@Nullable ValidationEventLocator aLocator) {
        URL aURL;
        if (aLocator != null && (aURL = aLocator.getURL()) != null) {
            return aURL.toString();
        }
        return null;
    }

    @Nullable
    @OverrideOnDemand
    protected String getErrorFieldName(@Nullable ValidationEventLocator aLocator) {
        if (aLocator != null) {
            Object aObj = aLocator.getObject();
            if (aObj != null) {
                return "obj: " + aObj.toString();
            }
            Node aNode = aLocator.getNode();
            if (aNode != null) {
                return XMLWriter.getNodeAsString((Node)aNode);
            }
        }
        return null;
    }

    @OverrideOnDemand
    protected abstract void onEvent(@Nonnull IError var1);

    @OverrideOnDemand
    protected boolean continueProcessing(@Nonnull IErrorLevel aErrorLevel) {
        return aErrorLevel.isLT((IErrorLevel)EErrorLevel.FATAL_ERROR);
    }

    public final boolean handleEvent(@Nonnull ValidationEvent aEvent) {
        IErrorLevel aErrorLevel = this.getErrorLevel(aEvent.getSeverity());
        SingleError.Builder aErrBuilder = (SingleError.Builder)SingleError.builder().errorLevel(aErrorLevel);
        ValidationEventLocator aLocator = aEvent.getLocator();
        ((SingleError.Builder)aErrBuilder.errorLocation((ILocation)new SimpleLocation(this.getLocationResourceID(aLocator), aLocator != null ? aLocator.getLineNumber() : -1, aLocator != null ? aLocator.getColumnNumber() : -1))).errorFieldName(this.getErrorFieldName(aLocator));
        String sMsg = aEvent.getMessage();
        if (sMsg == null) {
            if (aEvent.getLinkedException() != null) {
                sMsg = aEvent.getLinkedException().getMessage();
                if (sMsg == null) {
                    sMsg = "Exception";
                }
            } else {
                sMsg = "Validation event";
            }
        }
        ((SingleError.Builder)aErrBuilder.errorText(sMsg)).linkedException(aEvent.getLinkedException());
        this.onEvent((IError)aErrBuilder.build());
        return this.continueProcessing(aErrorLevel);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).getToString();
    }
}

