/*
 * Decompiled with CFR 0.152.
 */
package com.github.blutorange.primefaces.component.monacoeditor;

import com.github.blutorange.primefaces.component.monacoeditor.BasePropertyKeys;
import com.github.blutorange.primefaces.component.monacoeditor.MonacoEditorBase;
import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import org.apache.commons.lang3.StringEscapeUtils;
import org.primefaces.context.PrimeRequestContext;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;
import org.primefaces.util.WidgetBuilder;

abstract class MonacoEditorBaseRenderer<T extends MonacoEditorBase>
extends InputRenderer {
    private final Class<T> clazz;

    protected MonacoEditorBaseRenderer(Class<T> clazz) {
        this.clazz = clazz;
    }

    public final void decode(FacesContext context, UIComponent component) {
        MonacoEditorBase monacoEditor = (MonacoEditorBase)((Object)this.clazz.cast(component));
        if (monacoEditor.isDisabled() || monacoEditor.isReadonly()) {
            return;
        }
        String clientId = monacoEditor.getClientId() + "_input";
        Map params = context.getExternalContext().getRequestParameterMap();
        if (params.containsKey(clientId)) {
            monacoEditor.setSubmittedValue(params.get(clientId));
        }
        this.decodeBehaviors(context, component);
    }

    public final Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) {
        MonacoEditorBase monacoEditor = (MonacoEditorBase)((Object)this.clazz.cast(component));
        String value = (String)submittedValue;
        Converter converter = ComponentUtils.getConverter((FacesContext)context, (UIComponent)monacoEditor);
        if (converter != null) {
            return converter.getAsObject(context, (UIComponent)monacoEditor, value);
        }
        return value;
    }

    public final void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        MonacoEditorBase monacoEditor = (MonacoEditorBase)((Object)this.clazz.cast(component));
        this.encodeMarkup(context, monacoEditor);
        this.encodeScript(context, monacoEditor);
    }

    protected final void encodeMarkup(FacesContext context, T monacoEditor) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = monacoEditor.getClientId();
        String style = monacoEditor.getStyle() != null ? monacoEditor.getStyle() : "";
        style = style.concat(";");
        if (((MonacoEditorBase)((Object)monacoEditor)).getWidth() != null && !((MonacoEditorBase)((Object)monacoEditor)).getWidth().isEmpty()) {
            style = style.concat("width:" + ((MonacoEditorBase)((Object)monacoEditor)).getWidth() + ";");
        }
        if (((MonacoEditorBase)((Object)monacoEditor)).getHeight() != null && !((MonacoEditorBase)((Object)monacoEditor)).getHeight().isEmpty()) {
            style = style.concat("height:" + ((MonacoEditorBase)((Object)monacoEditor)).getHeight() + ";");
        }
        StringBuilder styleClass = new StringBuilder();
        styleClass.append(this.getMainStyleClass() + " ui-hidden-container ");
        if (((MonacoEditorBase)((Object)monacoEditor)).isDisabled() || ((MonacoEditorBase)((Object)monacoEditor)).isReadonly()) {
            styleClass.append("ui-state-disabled ");
        }
        if (monacoEditor.getStyleClass() != null) {
            styleClass.append(monacoEditor.getStyleClass());
        }
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("data-widget-var", (Object)((MonacoEditorBase)((Object)monacoEditor)).resolveWidgetVar(), null);
        writer.writeAttribute("class", (Object)styleClass.toString(), null);
        writer.writeAttribute("style", (Object)style, null);
        this.encodeHiddenInput(context, monacoEditor);
        this.encodeMonacoEditor(context, monacoEditor);
        writer.endElement("div");
    }

    protected final void encodeHiddenInput(FacesContext context, T monacoEditor) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = monacoEditor.getClientId();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-helper-hidden-accessible", null);
        writer.startElement("textarea", monacoEditor);
        writer.writeAttribute("id", (Object)(clientId + "_input"), null);
        writer.writeAttribute("name", (Object)(clientId + "_input"), null);
        writer.writeAttribute("autocomplete", (Object)"off", null);
        if (((MonacoEditorBase)((Object)monacoEditor)).isReadonly()) {
            writer.writeAttribute("readonly", (Object)"readonly", null);
        }
        if (((MonacoEditorBase)((Object)monacoEditor)).isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (((MonacoEditorBase)((Object)monacoEditor)).getTabindex() != null) {
            writer.writeAttribute("tabindex", (Object)((MonacoEditorBase)((Object)monacoEditor)).getTabindex(), null);
        }
        this.renderPassThruAttributes(context, (UIComponent)monacoEditor, HTML.TEXTAREA_ATTRS_WITHOUT_EVENTS);
        String valueToRender = ComponentUtils.getValueToRender((FacesContext)context, monacoEditor);
        if (valueToRender != null) {
            writer.writeText((Object)valueToRender, null);
        }
        writer.endElement("textarea");
        writer.endElement("div");
    }

    protected final void encodeScript(FacesContext context, T monacoEditor) throws IOException {
        WidgetBuilder wb = PrimeRequestContext.getCurrentInstance((FacesContext)context).getWidgetBuilder();
        wb.init(this.getWidgetName(), ((MonacoEditorBase)((Object)monacoEditor)).resolveWidgetVar(), monacoEditor.getClientId());
        wb.attr("version", "0.21.0");
        wb.attr(BasePropertyKeys.AUTO_RESIZE.toString(), ((MonacoEditorBase)((Object)monacoEditor)).isAutoResize(), false);
        wb.attr(BasePropertyKeys.BASENAME.toString(), ((MonacoEditorBase)((Object)monacoEditor)).getBasename(), "");
        wb.attr(BasePropertyKeys.DIRECTORY.toString(), ((MonacoEditorBase)((Object)monacoEditor)).getDirectory(), "");
        wb.attr(BasePropertyKeys.DISABLED.toString(), ((MonacoEditorBase)((Object)monacoEditor)).isDisabled(), false);
        wb.attr(BasePropertyKeys.EDITOR_OPTIONS.toString(), ((MonacoEditorBase)((Object)monacoEditor)).getEditorOptions().toString());
        wb.attr(BasePropertyKeys.EXTENSION.toString(), ((MonacoEditorBase)((Object)monacoEditor)).getExtension(), "");
        wb.attr(BasePropertyKeys.LANGUAGE.toString(), ((MonacoEditorBase)((Object)monacoEditor)).getEditorOptions().getLanguage(), "plaintext");
        wb.attr(BasePropertyKeys.READONLY.toString(), ((MonacoEditorBase)((Object)monacoEditor)).isReadonly(), false);
        wb.attr(BasePropertyKeys.UI_LANGUAGE.toString(), ((MonacoEditorBase)((Object)monacoEditor)).getUiLanguage(), "en");
        wb.attr(BasePropertyKeys.UI_LANGUAGE_URI.toString(), ((MonacoEditorBase)((Object)monacoEditor)).getUiLanguageUri(), "");
        wb.attr(BasePropertyKeys.HEIGHT.toString(), ((MonacoEditorBase)((Object)monacoEditor)).getHeight(), "600px");
        wb.attr(BasePropertyKeys.WIDTH.toString(), ((MonacoEditorBase)((Object)monacoEditor)).getWidth(), "200px");
        this.array(wb, BasePropertyKeys.AVAILABLE_EVENTS.toString(), ((MonacoEditorBase)((Object)monacoEditor)).getEventNames());
        this.callback(wb, BasePropertyKeys.ONBLUR.toString(), ((MonacoEditorBase)((Object)monacoEditor)).getOnblur(), "");
        this.callback(wb, BasePropertyKeys.ONFOCUS.toString(), ((MonacoEditorBase)((Object)monacoEditor)).getOnfocus(), "");
        this.callback(wb, BasePropertyKeys.ONCHANGE.toString(), ((MonacoEditorBase)((Object)monacoEditor)).getOnchange(), "");
        this.callback(wb, BasePropertyKeys.ONPASTE.toString(), ((MonacoEditorBase)((Object)monacoEditor)).getOnpaste(), "");
        this.callback(wb, BasePropertyKeys.ONMOUSEDOWN.toString(), ((MonacoEditorBase)((Object)monacoEditor)).getOnmousedown(), "");
        this.callback(wb, BasePropertyKeys.ONMOUSEMOVE.toString(), ((MonacoEditorBase)((Object)monacoEditor)).getOnmousemove(), "");
        this.callback(wb, BasePropertyKeys.ONMOUSEUP.toString(), ((MonacoEditorBase)((Object)monacoEditor)).getOnmouseup(), "");
        this.callback(wb, BasePropertyKeys.ONKEYDOWN.toString(), ((MonacoEditorBase)((Object)monacoEditor)).getOnkeydown(), "");
        this.callback(wb, BasePropertyKeys.ONKEYPRESS.toString(), ((MonacoEditorBase)((Object)monacoEditor)).getOnkeypress(), "");
        this.callback(wb, BasePropertyKeys.ONKEYUP.toString(), ((MonacoEditorBase)((Object)monacoEditor)).getOnkeyup(), "");
        this.addWidgetProperties(wb, monacoEditor);
        this.encodeClientBehaviors(context, (ClientBehaviorHolder)monacoEditor);
        wb.finish();
    }

    protected final void callback(WidgetBuilder wb, String key, String callback, String defaultValue) throws IOException {
        String cb;
        String string = cb = callback != null ? callback : defaultValue;
        if (cb == null || cb.length() == 0) {
            return;
        }
        String fn = "function(){" + cb + "}";
        wb.callback(key, fn);
    }

    protected final void array(WidgetBuilder wb, String key, Iterable<String> values) throws IOException {
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        for (String item : values) {
            builder.append('\"');
            builder.append(StringEscapeUtils.escapeEcmaScript((String)item));
            builder.append('\"');
            builder.append(',');
        }
        if (builder.length() > 1) {
            builder.setLength(builder.length() - 1);
        }
        builder.append(']');
        wb.nativeAttr(key, builder.toString());
    }

    protected final void expression(WidgetBuilder wb, String key, String expression, String defaultValue) throws IOException {
        String ex;
        String string = ex = expression != null ? expression : defaultValue;
        if (ex == null || ex.length() == 0) {
            return;
        }
        String fn = "function(){return " + ex + ";}";
        wb.callback(key, fn);
    }

    protected abstract void addWidgetProperties(WidgetBuilder var1, T var2) throws IOException;

    protected abstract void encodeMonacoEditor(FacesContext var1, T var2) throws IOException;

    protected abstract String getMainStyleClass();

    protected abstract String getWidgetName();
}

