/*
 * Decompiled with CFR 0.152.
 */
package com.github.bogdanlivadariu.gifwebdriver;

import com.github.bogdanlivadariu.gifwebdriver.Giffer;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.stream.FileImageOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;

public class GifScreenshotWorker {
    final List<String> screenshotsTaken = new ArrayList<String>();
    private final Logger logger = LogManager.getLogger(GifScreenshotWorker.class);
    private final WebDriver driver;
    private final String uniqueName = RandomStringUtils.randomAlphabetic((int)10);
    private final String separator = File.separator;
    private String rootDir;
    private String screenshotsFolderName;
    private String generatedGIFsFolderName;
    private int timeBetweenFramesInMilliseconds = 500;
    private boolean loopContinuously = false;
    private int counter = 0;

    public GifScreenshotWorker(WebDriver driver) {
        this.driver = driver;
        this.setRootDir(String.format("gifScreenshotWorker%s%s", this.separator, this.getUniqueName()));
        this.setScreenshotsFolderName("screenshots");
        this.setGeneratedGIFsFolderName("generatedGifs");
    }

    public GifScreenshotWorker(WebDriver driver, String rootDir, String screenshotsFolder, String generatedGIFsFolderName, boolean loopContinuously) {
        this.driver = driver;
        this.loopContinuously = loopContinuously;
        this.setRootDir(rootDir + this.separator + this.getUniqueName());
        this.setScreenshotsFolderName(screenshotsFolder);
        this.setGeneratedGIFsFolderName(generatedGIFsFolderName);
    }

    public void takeScreenshot() {
        try {
            byte[] screenShotData = (byte[])((TakesScreenshot)this.driver).getScreenshotAs(OutputType.BYTES);
            File screenshotFile = new File(this.getScreenshotsFolderName() + this.counter++ + RandomStringUtils.randomAlphanumeric((int)10) + ".png");
            FileUtils.writeByteArrayToFile((File)screenshotFile, (byte[])screenShotData);
            this.logger.info(String.format("Screenshot taken at: '%s'", screenshotFile.getAbsolutePath()));
            this.screenshotsTaken.add(screenshotFile.getAbsolutePath());
        }
        catch (Throwable e) {
            this.logger.warn("Screenshot could not be taken or saved");
            this.logger.trace((Object)e);
        }
    }

    public File createGif() {
        if (this.screenshotsTaken.isEmpty()) {
            this.logger.info("There are no screenshots to process");
            return null;
        }
        try {
            BufferedImage firstImage = ImageIO.read(new File(this.screenshotsTaken.get(0)));
            File outputFile = new File(this.getGeneratedGIFsFolderName() + this.uniqueName + ".gif");
            if (!outputFile.exists()) {
                outputFile.getParentFile().mkdirs();
                outputFile.createNewFile();
            }
            FileImageOutputStream output = new FileImageOutputStream(outputFile);
            Giffer gif = new Giffer(output, firstImage.getType(), this.getTimeBetweenFramesInMilliseconds(), this.isLoopContinuously());
            for (int i = 1; i < this.screenshotsTaken.size(); ++i) {
                BufferedImage nextImage = ImageIO.read(new File(this.screenshotsTaken.get(i)));
                gif.writeToSequence(nextImage);
            }
            gif.close();
            output.close();
            this.logger.info(String.format("Gif created at: '%s'", outputFile.getAbsolutePath()));
            this.screenshotsTaken.clear();
            return outputFile;
        }
        catch (Throwable e) {
            this.logger.warn("Gif could not be created or saved");
            this.logger.trace((Object)e);
            return null;
        }
    }

    public int getTimeBetweenFramesInMilliseconds() {
        return this.timeBetweenFramesInMilliseconds;
    }

    public void setTimeBetweenFramesInMilliseconds(int timeBetweenFramesInMilliseconds) {
        this.timeBetweenFramesInMilliseconds = timeBetweenFramesInMilliseconds;
    }

    public boolean isLoopContinuously() {
        return this.loopContinuously;
    }

    public void setLoopContinuously(boolean loopContinuously) {
        this.loopContinuously = loopContinuously;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public String getRootDir() {
        return this.rootDir;
    }

    public void setRootDir(String rootDir) {
        this.rootDir = rootDir + this.separator;
    }

    public String getScreenshotsFolderName() {
        return this.screenshotsFolderName;
    }

    public void setScreenshotsFolderName(String screenshotsFolderName) {
        this.screenshotsFolderName = this.getRootDir() + screenshotsFolderName + this.separator;
    }

    public String getGeneratedGIFsFolderName() {
        return this.generatedGIFsFolderName;
    }

    public void setGeneratedGIFsFolderName(String generatedGIFsFolderName) {
        this.generatedGIFsFolderName = this.getRootDir() + generatedGIFsFolderName + this.separator;
    }
}

