/*
 * Decompiled with CFR 0.152.
 */
package com.github.bogdanlivadariu.gifwebdriver;

import com.github.bogdanlivadariu.gifwebdriver.GifScreenshotWorker;
import java.util.List;
import java.util.Set;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.events.AbstractWebDriverEventListener;
import org.openqa.selenium.support.events.EventFiringWebDriver;
import org.openqa.selenium.support.events.WebDriverEventListener;

public class GifWebDriver
extends AbstractWebDriverEventListener
implements WebDriver,
JavascriptExecutor {
    private final WebDriver driver;
    private final GifScreenshotWorker gifScreenshotWorker;

    public GifWebDriver(WebDriver driver) {
        EventFiringWebDriver handle = new EventFiringWebDriver(driver);
        handle.register((WebDriverEventListener)this);
        this.driver = handle;
        this.gifScreenshotWorker = new GifScreenshotWorker(this.driver);
    }

    public GifWebDriver(WebDriver driver, GifScreenshotWorker gifScreenshotWorker) {
        EventFiringWebDriver handle = new EventFiringWebDriver(driver);
        handle.register((WebDriverEventListener)this);
        this.driver = handle;
        this.gifScreenshotWorker = gifScreenshotWorker;
    }

    public void afterClickOn(WebElement element, WebDriver driver) {
        super.afterClickOn(element, driver);
    }

    public void beforeClickOn(WebElement element, WebDriver driver) {
        this.gifScreenshotWorker.takeScreenshot();
        super.beforeClickOn(element, driver);
    }

    public void get(String s) {
        this.driver.get(s);
    }

    public String getCurrentUrl() {
        return this.driver.getCurrentUrl();
    }

    public String getTitle() {
        return this.driver.getTitle();
    }

    public List<WebElement> findElements(By by) {
        return this.driver.findElements(by);
    }

    public WebElement findElement(By by) {
        return this.driver.findElement(by);
    }

    public String getPageSource() {
        return this.driver.getPageSource();
    }

    public void close() {
        this.gifScreenshotWorker.takeScreenshot();
        this.driver.close();
    }

    public void quit() {
        this.gifScreenshotWorker.takeScreenshot();
        this.gifScreenshotWorker.createGif();
        this.driver.quit();
    }

    public Set<String> getWindowHandles() {
        return this.driver.getWindowHandles();
    }

    public String getWindowHandle() {
        return this.driver.getWindowHandle();
    }

    public WebDriver.TargetLocator switchTo() {
        return this.driver.switchTo();
    }

    public WebDriver.Navigation navigate() {
        return this.driver.navigate();
    }

    public WebDriver.Options manage() {
        return this.driver.manage();
    }

    public Object executeScript(String s, Object ... objects) {
        return ((JavascriptExecutor)this.driver).executeScript(s, objects);
    }

    public Object executeAsyncScript(String s, Object ... objects) {
        return ((JavascriptExecutor)this.driver).executeAsyncScript(s, objects);
    }

    public GifScreenshotWorker getGifScreenshotWorker() {
        return this.gifScreenshotWorker;
    }
}

