package com.bonnguyen.uberseekbar;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.PixelFormat;
import android.graphics.drawable.Drawable;
import android.util.TypedValue;
import android.widget.SeekBar;

/**
 * Created by nguyenbon on 3/28/16.
 */
public class UberProgressDrawable extends Drawable {

    private static final String TAG = "CustomDrawable";
    private final SeekBar mySlider;
    private final Drawable myBase;
    private final int myDots;
    private Paint unSelectLinePaint;

    public UberProgressDrawable(Drawable base, SeekBar slider, int dots, int color) {
        mySlider = slider;
        myBase = base;
        myDots = dots;

        unSelectLinePaint = new Paint();
        unSelectLinePaint.setColor(color);
        unSelectLinePaint.setStrokeWidth(toPix(10));
    }

    @Override
    public final void draw(Canvas canvas) {
        float height = toPix(30) / 2;
        float width = getBounds().width();
        float radius = toPix((int) height / myDots);
        float mY = height;
        canvas.drawLine(0, height, width, height, unSelectLinePaint);
        float mX = 0;
        canvas.drawCircle(mX, mY, radius, unSelectLinePaint);
        for (int i = 0; i < myDots; i++) {
            mX = mX + width / 3;
            canvas.drawCircle(mX, mY, radius, unSelectLinePaint);
        }
    }

    private float toPix(int size) {
        return TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, size, mySlider.getContext().getResources().getDisplayMetrics());
    }


    @Override
    public final int getOpacity() {
        return PixelFormat.TRANSLUCENT;
    }

    @Override
    public void setAlpha(int i) {

    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {

    }
}
