/*
 * Decompiled with CFR 0.152.
 */
package com.bonnguyen.uberseekbar;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.widget.SeekBar;

public class UberProgressDrawable
extends Drawable {
    private static final String TAG = "CustomDrawable";
    private final SeekBar mySlider;
    private final Drawable myBase;
    private final int myDots;
    private Paint unSelectLinePaint;

    public UberProgressDrawable(Drawable base, SeekBar slider, int dots, int color) {
        this.mySlider = slider;
        this.myBase = base;
        this.myDots = dots;
        this.unSelectLinePaint = new Paint();
        this.unSelectLinePaint.setColor(color);
        this.unSelectLinePaint.setStrokeWidth(this.toPix(10));
    }

    public final void draw(Canvas canvas) {
        float height = this.toPix(30) / 2.0f;
        float width = this.getBounds().width();
        float radius = this.toPix((int)height / this.myDots);
        float mY = height;
        canvas.drawLine(0.0f, height, width, height, this.unSelectLinePaint);
        float mX = 0.0f;
        canvas.drawCircle(mX, mY, radius, this.unSelectLinePaint);
        for (int i = 0; i < this.myDots; ++i) {
            canvas.drawCircle(mX += width / 3.0f, mY, radius, this.unSelectLinePaint);
        }
    }

    private float toPix(int size) {
        return TypedValue.applyDimension((int)1, (float)size, (DisplayMetrics)this.mySlider.getContext().getResources().getDisplayMetrics());
    }

    public final int getOpacity() {
        return -3;
    }

    public void setAlpha(int i) {
    }

    public void setColorFilter(ColorFilter colorFilter) {
    }
}

