/*
 * Decompiled with CFR 0.152.
 */
package com.bonnguyen.uberseekbar;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import com.bonnguyen.uberseekbar.R;
import com.bonnguyen.uberseekbar.UberProgressDrawable;

public class UberSeekBar
extends LinearLayout {
    private static final String TAG = "UberSeekBar";
    private boolean isShowTitle;
    private CharSequence[] titles;
    private Drawable[] bgItems;
    private Drawable thumbSeekBar;
    private int valueOfProgress = 0;
    private int lengthOfItems = 0;
    private int maxOfProgress = 0;
    private OnSeekBarChangeListener mOnSeekBarChangeListener;

    public UberSeekBar(Context context) {
        super(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UberSeekBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.UberSeekBar, 0, 0);
        try {
            this.isShowTitle = a.getBoolean(R.styleable.UberSeekBar_showTitle, false);
            this.maxOfProgress = a.getInteger(R.styleable.UberSeekBar_maxProgress, 0);
            if (this.maxOfProgress == 0) {
                throw new IllegalArgumentException("IntegerListPreference: error - max of progress is not zero");
            }
            this.valueOfProgress = a.getInteger(R.styleable.UberSeekBar_valueProgress, -1);
            if (this.valueOfProgress == -1) {
                throw new IllegalArgumentException("IntegerListPreference: error - max of progress is not less than zero");
            }
            this.thumbSeekBar = a.getDrawable(R.styleable.UberSeekBar_thumb);
            if (this.thumbSeekBar == null) {
                throw new IllegalArgumentException("IntegerListPreference: error - thumb is not null");
            }
            this.titles = a.getTextArray(R.styleable.UberSeekBar_titles);
            if (this.titles == null) {
                throw new IllegalArgumentException("IntegerListPreference: error - titles is not null");
            }
            int valuesResId = a.getResourceId(R.styleable.UberSeekBar_bgItems, -1);
            if (valuesResId == -1) {
                throw new IllegalArgumentException("IntegerListPreference: error - bg items is not zero");
            }
            TypedArray drawableArray = this.getResources().obtainTypedArray(valuesResId);
            this.lengthOfItems = drawableArray.length();
            if (this.lengthOfItems == 0) {
                throw new IllegalArgumentException("IntegerListPreference: error - items is not zero");
            }
            this.bgItems = new Drawable[this.lengthOfItems];
            for (int i = 0; i < this.lengthOfItems; ++i) {
                this.bgItems[i] = drawableArray.getDrawable(i);
            }
            drawableArray.recycle();
        }
        finally {
            a.recycle();
        }
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        View view = inflater.inflate(R.layout.layout_uber_seekbar, (ViewGroup)this, true);
        this.displayTitles(context, view);
        this.displayProgressDrawable(view);
    }

    public UberSeekBar(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public void setOnSeekBarChangeListener(OnSeekBarChangeListener onSeekBarChangeListener) {
        this.mOnSeekBarChangeListener = onSeekBarChangeListener;
    }

    private void displayTitles(Context context, View view) {
        LinearLayout llTitle = (LinearLayout)view.findViewById(R.id.llTitle);
        if (this.isShowTitle && this.titles != null) {
            llTitle.setVisibility(0);
            llTitle.removeAllViewsInLayout();
            for (CharSequence title : this.titles) {
                TextView tvTitle = new TextView(context);
                llTitle.addView((View)tvTitle);
                if (Build.VERSION.SDK_INT < 23) {
                    tvTitle.setTextAppearance(context, R.style.TitleTextViewStyle);
                } else {
                    tvTitle.setTextAppearance(R.style.TitleTextViewStyle);
                }
                tvTitle.setText(title);
                tvTitle.setGravity(17);
                tvTitle.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2, 1.0f));
            }
        } else {
            llTitle.setVisibility(8);
        }
    }

    private void displayProgressDrawable(View view) {
        SeekBar uberSeekBar = (SeekBar)view.findViewById(R.id.seekBar);
        uberSeekBar.setMax(this.maxOfProgress);
        uberSeekBar.setProgress(this.valueOfProgress);
        uberSeekBar.setThumb(this.thumbSeekBar);
        uberSeekBar.setProgressDrawable((Drawable)new UberProgressDrawable(uberSeekBar.getProgressDrawable(), uberSeekBar, this.lengthOfItems, -7829368));
        uberSeekBar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int value, boolean b) {
                if (UberSeekBar.this.mOnSeekBarChangeListener != null) {
                    UberSeekBar.this.mOnSeekBarChangeListener.onProgressChanged(seekBar, value, b);
                }
                UberSeekBar.this.valueOfProgress = value;
                if (UberSeekBar.this.valueOfProgress >= 0 && UberSeekBar.this.valueOfProgress <= 50) {
                    seekBar.setThumb(UberSeekBar.this.bgItems[0]);
                } else if (UberSeekBar.this.valueOfProgress > 50 && UberSeekBar.this.valueOfProgress < 150) {
                    seekBar.setThumb(UberSeekBar.this.bgItems[1]);
                } else if (UberSeekBar.this.valueOfProgress >= 150 && UberSeekBar.this.valueOfProgress < 250) {
                    seekBar.setThumb(UberSeekBar.this.bgItems[2]);
                } else if (UberSeekBar.this.valueOfProgress >= 250 && UberSeekBar.this.valueOfProgress <= 300) {
                    seekBar.setThumb(UberSeekBar.this.bgItems[3]);
                }
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
                if (UberSeekBar.this.mOnSeekBarChangeListener != null) {
                    UberSeekBar.this.mOnSeekBarChangeListener.onStartTrackingTouch(seekBar);
                }
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
                if (UberSeekBar.this.mOnSeekBarChangeListener != null) {
                    UberSeekBar.this.mOnSeekBarChangeListener.onStopTrackingTouch(seekBar);
                }
                if (UberSeekBar.this.valueOfProgress >= 0 && UberSeekBar.this.valueOfProgress <= 50) {
                    seekBar.setProgress(0);
                } else if (UberSeekBar.this.valueOfProgress > 50 && UberSeekBar.this.valueOfProgress < 150) {
                    seekBar.setProgress(100);
                } else if (UberSeekBar.this.valueOfProgress >= 150 && UberSeekBar.this.valueOfProgress < 250) {
                    seekBar.setProgress(200);
                } else if (UberSeekBar.this.valueOfProgress >= 250 && UberSeekBar.this.valueOfProgress <= 300) {
                    seekBar.setProgress(300);
                }
            }
        });
    }

    public static interface OnSeekBarChangeListener {
        public void onProgressChanged(SeekBar var1, int var2, boolean var3);

        public void onStartTrackingTouch(SeekBar var1);

        public void onStopTrackingTouch(SeekBar var1);
    }
}

