/*
 * Decompiled with CFR 0.152.
 */
package com.github.bottomlessarchive.warc.service;

import com.github.bottomlessarchive.warc.service.WarcRecordStreamFactory;
import com.github.bottomlessarchive.warc.service.content.domain.WarcContentBlock;
import com.github.bottomlessarchive.warc.service.record.domain.WarcRecord;
import com.github.bottomlessarchive.warc.service.record.domain.WarcRecordType;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import lombok.NonNull;
import org.jetbrains.annotations.NotNull;
import reactor.core.publisher.Flux;

public class WarcRecordFluxFactory {
    private static final List<WarcRecordType> EVERY_WARC_RECORD_TYPE = Arrays.asList(WarcRecordType.values());

    private WarcRecordFluxFactory() {
    }

    public static <T extends WarcContentBlock> Flux<WarcRecord<T>> buildWarcRecordFlux(@NotNull @NonNull String warcLocation) {
        if (warcLocation == null) {
            throw new NullPointerException("warcLocation is marked non-null but is null");
        }
        return Flux.fromStream(() -> WarcRecordStreamFactory.streamOf((String)warcLocation, EVERY_WARC_RECORD_TYPE));
    }

    public static <T extends WarcContentBlock> Flux<WarcRecord<T>> buildWarcRecordFlux(@NotNull @NonNull String warcLocation, WarcRecordType ... requiredRecordTypes) {
        if (warcLocation == null) {
            throw new NullPointerException("warcLocation is marked non-null but is null");
        }
        if (requiredRecordTypes == null) {
            throw new NullPointerException("requiredRecordTypes is marked non-null but is null");
        }
        return Flux.fromStream(() -> WarcRecordStreamFactory.streamOf((String)warcLocation, (WarcRecordType[])requiredRecordTypes));
    }

    public static <T extends WarcContentBlock> Flux<WarcRecord<T>> buildWarcRecordFlux(@NotNull @NonNull String warcLocation, @NotNull @NonNull List<WarcRecordType> requiredRecordTypes) {
        if (warcLocation == null) {
            throw new NullPointerException("warcLocation is marked non-null but is null");
        }
        if (requiredRecordTypes == null) {
            throw new NullPointerException("requiredRecordTypes is marked non-null but is null");
        }
        return Flux.fromStream(() -> WarcRecordStreamFactory.streamOf((String)warcLocation, (List)requiredRecordTypes));
    }

    public static <T extends WarcContentBlock> Flux<WarcRecord<T>> buildWarcRecordFlux(@NotNull @NonNull URI warcLocation) {
        if (warcLocation == null) {
            throw new NullPointerException("warcLocation is marked non-null but is null");
        }
        return Flux.fromStream(() -> WarcRecordStreamFactory.streamOf((URI)warcLocation, EVERY_WARC_RECORD_TYPE));
    }

    public static <T extends WarcContentBlock> Flux<WarcRecord<T>> buildWarcRecordFlux(@NotNull @NonNull URI warcLocation, WarcRecordType ... requiredRecordTypes) {
        if (warcLocation == null) {
            throw new NullPointerException("warcLocation is marked non-null but is null");
        }
        if (requiredRecordTypes == null) {
            throw new NullPointerException("requiredRecordTypes is marked non-null but is null");
        }
        return Flux.fromStream(() -> WarcRecordStreamFactory.streamOf((URI)warcLocation, (WarcRecordType[])requiredRecordTypes));
    }

    public static <T extends WarcContentBlock> Flux<WarcRecord<T>> buildWarcRecordFlux(@NotNull @NonNull URI warcLocation, @NotNull @NonNull List<WarcRecordType> requiredRecordTypes) {
        if (warcLocation == null) {
            throw new NullPointerException("warcLocation is marked non-null but is null");
        }
        if (requiredRecordTypes == null) {
            throw new NullPointerException("requiredRecordTypes is marked non-null but is null");
        }
        return Flux.fromStream(() -> WarcRecordStreamFactory.streamOf((URI)warcLocation, (List)requiredRecordTypes));
    }

    public static <T extends WarcContentBlock> Flux<WarcRecord<T>> buildWarcRecordFlux(@NotNull @NonNull URL warcLocation) {
        if (warcLocation == null) {
            throw new NullPointerException("warcLocation is marked non-null but is null");
        }
        return Flux.fromStream(() -> WarcRecordStreamFactory.streamOf((URL)warcLocation, EVERY_WARC_RECORD_TYPE));
    }

    public static <T extends WarcContentBlock> Flux<WarcRecord<T>> buildWarcRecordFlux(@NotNull @NonNull URL warcLocation, WarcRecordType ... requiredRecordTypes) {
        if (warcLocation == null) {
            throw new NullPointerException("warcLocation is marked non-null but is null");
        }
        if (requiredRecordTypes == null) {
            throw new NullPointerException("requiredRecordTypes is marked non-null but is null");
        }
        return Flux.fromStream(() -> WarcRecordStreamFactory.streamOf((URL)warcLocation, (WarcRecordType[])requiredRecordTypes));
    }

    public static <T extends WarcContentBlock> Flux<WarcRecord<T>> buildWarcRecordFlux(@NotNull @NonNull URL warcLocation, @NotNull @NonNull List<WarcRecordType> requiredRecordTypes) {
        if (warcLocation == null) {
            throw new NullPointerException("warcLocation is marked non-null but is null");
        }
        if (requiredRecordTypes == null) {
            throw new NullPointerException("requiredRecordTypes is marked non-null but is null");
        }
        return Flux.fromStream(() -> WarcRecordStreamFactory.streamOf((URL)warcLocation, (List)requiredRecordTypes));
    }

    public static <T extends WarcContentBlock> Flux<WarcRecord<T>> buildWarcRecordFlux(@NotNull @NonNull InputStream warcFileLocation) {
        if (warcFileLocation == null) {
            throw new NullPointerException("warcFileLocation is marked non-null but is null");
        }
        return Flux.fromStream(() -> WarcRecordStreamFactory.streamOf((InputStream)warcFileLocation));
    }

    public static <T extends WarcContentBlock> Flux<WarcRecord<T>> buildWarcRecordFlux(@NotNull @NonNull InputStream warcFileLocation, @NotNull @NonNull List<WarcRecordType> requiredRecordTypes) {
        if (warcFileLocation == null) {
            throw new NullPointerException("warcFileLocation is marked non-null but is null");
        }
        if (requiredRecordTypes == null) {
            throw new NullPointerException("requiredRecordTypes is marked non-null but is null");
        }
        return Flux.fromStream(() -> WarcRecordStreamFactory.streamOf((InputStream)warcFileLocation, (List)requiredRecordTypes));
    }

    public static <T extends WarcContentBlock> Flux<WarcRecord<T>> buildWarcRecordFlux(@NotNull @NonNull InputStream warcFileLocation, @NotNull @NonNull Charset charset) {
        if (warcFileLocation == null) {
            throw new NullPointerException("warcFileLocation is marked non-null but is null");
        }
        if (charset == null) {
            throw new NullPointerException("charset is marked non-null but is null");
        }
        return Flux.fromStream(() -> WarcRecordStreamFactory.streamOf((InputStream)warcFileLocation, (Charset)charset));
    }

    public static <T extends WarcContentBlock> Flux<WarcRecord<T>> buildWarcRecordFlux(@NotNull @NonNull InputStream warcFileLocation, @NotNull @NonNull Charset charset, @NotNull @NonNull List<WarcRecordType> requiredRecordTypes) {
        if (warcFileLocation == null) {
            throw new NullPointerException("warcFileLocation is marked non-null but is null");
        }
        if (charset == null) {
            throw new NullPointerException("charset is marked non-null but is null");
        }
        if (requiredRecordTypes == null) {
            throw new NullPointerException("requiredRecordTypes is marked non-null but is null");
        }
        return Flux.fromStream(() -> WarcRecordStreamFactory.streamOf((InputStream)warcFileLocation, (Charset)charset, (List)requiredRecordTypes));
    }

    public static <T extends WarcContentBlock> Flux<WarcRecord<T>> buildWarcRecordFlux(@NotNull @NonNull InputStream warcFileLocation, @NotNull @NonNull Charset charset, boolean compressed) {
        if (warcFileLocation == null) {
            throw new NullPointerException("warcFileLocation is marked non-null but is null");
        }
        if (charset == null) {
            throw new NullPointerException("charset is marked non-null but is null");
        }
        return Flux.fromStream(() -> WarcRecordStreamFactory.streamOf((InputStream)warcFileLocation, (Charset)charset, (boolean)compressed));
    }

    public static <T extends WarcContentBlock> Flux<WarcRecord<T>> buildWarcRecordFlux(@NotNull @NonNull InputStream warcFileLocation, @NotNull @NonNull Charset charset, boolean compressed, @NotNull @NonNull List<WarcRecordType> requiredRecordTypes) {
        if (warcFileLocation == null) {
            throw new NullPointerException("warcFileLocation is marked non-null but is null");
        }
        if (charset == null) {
            throw new NullPointerException("charset is marked non-null but is null");
        }
        if (requiredRecordTypes == null) {
            throw new NullPointerException("requiredRecordTypes is marked non-null but is null");
        }
        return Flux.fromStream(() -> WarcRecordStreamFactory.streamOf((InputStream)warcFileLocation, (Charset)charset, (boolean)compressed, (List)requiredRecordTypes));
    }
}

