/*
 * Decompiled with CFR 0.152.
 */
package com.github.brainlag.nsq.netty;

import com.github.brainlag.nsq.NSQCommand;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.util.List;

public class NSQEncoder
extends MessageToMessageEncoder<NSQCommand> {
    protected void encode(ChannelHandlerContext ctx, NSQCommand message, List<Object> out) throws Exception {
        ByteBuf buf = Unpooled.buffer();
        buf.writeBytes(message.getLine().getBytes("utf8"));
        if (message.getData().size() > 1) {
            int bodySize = 4;
            for (byte[] data : message.getData()) {
                bodySize += 4;
                bodySize += data.length;
            }
            buf.writeInt(bodySize);
            buf.writeInt(message.getData().size());
        }
        for (byte[] data : message.getData()) {
            buf.writeInt(data.length);
            buf.writeBytes(data);
        }
        out.add(buf);
    }
}

