/*
 * Decompiled with CFR 0.152.
 */
package threegpp.milenage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import javax.crypto.Cipher;
import threegpp.milenage.CConstants;
import threegpp.milenage.MilenageBuffer;
import threegpp.milenage.MilenageBufferFactory;
import threegpp.milenage.MilenageResult;
import threegpp.milenage.RConstants;

public class Milenage<B extends MilenageBuffer> {
    public static final short BLOCK_LEN_BYTES = 16;
    public static final short HALF_BUFFER_BYTES = 8;
    public static final short AK_LENGTH_BYTES = 6;
    public static final short BLOCK_LEN_BITS = 128;
    public static final short SQN_LEN_BYTES = 6;
    public static final short AK_LEN_BYTES = 6;
    public static final short AMF_LEN_BYTES = 2;
    private final B opc;
    private final Cipher key;
    private final CConstants<B> c;
    private final RConstants r;
    private final MilenageBufferFactory<B> factory;

    public static <B extends MilenageBuffer> byte[] calculateOPc(byte[] op, Cipher k, MilenageBufferFactory<B> factory) {
        Milenage.validateCipherOrThrowException(k);
        B opBuffer = factory.create(op);
        return opBuffer.encrypt(k).xor(opBuffer).toBytes();
    }

    public Milenage(byte[] OPc, Cipher k, CConstants<B> cConstants, RConstants rConstants, MilenageBufferFactory<B> bufferFactory) {
        Milenage.validateCipherOrThrowException(k);
        this.opc = bufferFactory.create(OPc);
        this.key = k;
        this.c = cConstants;
        this.r = rConstants;
        this.factory = bufferFactory;
    }

    public Milenage(byte[] OPc, Cipher k, byte[] c1, byte[] c2, byte[] c3, byte[] c4, byte[] c5, RConstants rConstants, MilenageBufferFactory<B> bufferFactory) {
        this(OPc, k, new CConstants<B>(c1, c2, c3, c4, c5, bufferFactory), rConstants, bufferFactory);
    }

    public Milenage(byte[] OPc, Cipher k, MilenageBufferFactory<B> bufferFactory) {
        this(OPc, k, new CConstants<B>(bufferFactory), new RConstants(), bufferFactory);
    }

    public Map<MilenageResult, byte[]> f1All(byte[] rand, byte[] sqn, byte[] amf) {
        B randBuffer = this.factory.create(rand);
        B in1Buffer = this.factory.create(sqn, amf);
        return this.makeF1Result(this.out1(this.temp(randBuffer), in1Buffer));
    }

    public Map<MilenageResult, byte[]> f2f5(byte[] rand) {
        B randBuffer = this.factory.create(rand);
        return this.makeF2F5Result(this.outX(this.temp(randBuffer), 1));
    }

    public byte[] f3(byte[] rand) {
        return this.outX(this.temp(this.factory.create(rand)), 2).toBytes();
    }

    public byte[] f4(byte[] rand) {
        return this.outX(this.temp(this.factory.create(rand)), 3).toBytes();
    }

    public byte[] f5Star(byte[] rand) {
        return this.makeF5StarResult(this.outX(this.temp(this.factory.create(rand)), 4));
    }

    public Map<MilenageResult, byte[]> calculateAll(byte[] rand, byte[] sqn, byte[] amf, ExecutorService executor) throws InterruptedException, ExecutionException {
        int[] indexes;
        B tmp = this.temp(this.factory.create(rand));
        ArrayList<Callable<B>> routines = new ArrayList<Callable<B>>();
        routines.add(this.getOUT1Callable(tmp, this.factory.create(sqn, amf)));
        for (int i : indexes = new int[]{1, 2, 3, 4}) {
            routines.add(this.getOUTXCallable(tmp, i));
        }
        List futures = executor.invokeAll(routines);
        HashMap<MilenageResult, byte[]> result = new HashMap<MilenageResult, byte[]>(5);
        result.putAll(this.makeF1Result((MilenageBuffer)futures.get(0).get()));
        result.putAll(this.makeF2F5Result((MilenageBuffer)futures.get(1).get()));
        result.put(MilenageResult.CK, ((MilenageBuffer)futures.get(2).get()).toBytes());
        result.put(MilenageResult.IK, ((MilenageBuffer)futures.get(3).get()).toBytes());
        result.put(MilenageResult.AK_R, this.makeF5StarResult((MilenageBuffer)futures.get(4).get()));
        return result;
    }

    private B temp(B rand) {
        return (B)rand.xor(this.opc).encrypt(this.key);
    }

    private B out1(B tmp, B in1) {
        return (B)in1.xor(this.opc).leftCircularBitRotation((Byte)this.r.get(0)).xor(tmp).xor((MilenageBuffer)this.c.get(0)).encrypt(this.key).xor(this.opc);
    }

    private B outX(B tmp, int constIndex) {
        return (B)tmp.xor(this.opc).leftCircularBitRotation((Byte)this.r.get(constIndex)).xor((MilenageBuffer)this.c.get(constIndex)).encrypt(this.key).xor(this.opc);
    }

    private Callable<B> getOUT1Callable(B tmp, B in1Val) {
        return new Callable<B>((MilenageBuffer)tmp, (MilenageBuffer)in1Val){
            final /* synthetic */ MilenageBuffer val$tmp;
            final /* synthetic */ MilenageBuffer val$in1Val;
            {
                this.val$tmp = milenageBuffer;
                this.val$in1Val = milenageBuffer2;
            }

            @Override
            public B call() throws Exception {
                return Milenage.this.out1(this.val$tmp, this.val$in1Val);
            }
        };
    }

    private Callable<B> getOUTXCallable(B tmp, int constIndex) {
        return new Callable<B>((MilenageBuffer)tmp, constIndex){
            final /* synthetic */ MilenageBuffer val$tmp;
            final /* synthetic */ int val$constIndex;
            {
                this.val$tmp = milenageBuffer;
                this.val$constIndex = n;
            }

            @Override
            public B call() throws Exception {
                return Milenage.this.outX(this.val$tmp, this.val$constIndex);
            }
        };
    }

    private Map<MilenageResult, byte[]> makeF1Result(B buf) {
        byte[][] bytes = buf.takeBytes(0, 8, 8, 16);
        HashMap<MilenageResult, byte[]> result = new HashMap<MilenageResult, byte[]>();
        result.put(MilenageResult.MAC_A, bytes[0]);
        result.put(MilenageResult.MAC_S, bytes[1]);
        return result;
    }

    private Map<MilenageResult, byte[]> makeF2F5Result(B buf) {
        byte[][] out2 = buf.takeBytes(0, 6, 8, 16);
        HashMap<MilenageResult, byte[]> result = new HashMap<MilenageResult, byte[]>(2);
        result.put(MilenageResult.AK, out2[0]);
        result.put(MilenageResult.RES, out2[1]);
        return result;
    }

    private byte[] makeF5StarResult(B buf) {
        return buf.takeBytes(0, 6)[0];
    }

    private static void validateCipherOrThrowException(Cipher k) {
        if (k.getOutputSize(16) != 16) {
            throw new IllegalArgumentException("Cipher supplied is not suitable for Milenage");
        }
    }
}

