/*
 * Decompiled with CFR 0.152.
 */
package threegpp.milenage;

import java.util.Arrays;
import threegpp.milenage.Constants;

public class RConstants
extends Constants<Byte> {
    private static final byte LOWER_BOUND = 0;
    private static final byte UPPER_BOUND = 127;
    public static final byte R1_SAMPLE = 64;
    public static final byte R2_SAMPLE = 0;
    public static final byte R3_SAMPLE = 32;
    public static final byte R4_SAMPLE = 64;
    public static final byte R5_SAMPLE = 96;

    public RConstants(byte r1, byte r2, byte r3, byte r4, byte r5) throws IllegalArgumentException {
        super(r1, r2, r3, r4, r5);
    }

    public RConstants() {
        this(64, 0, 32, 64, 96);
    }

    @Override
    protected void validateArgs(Byte r1, Byte r2, Byte r3, Byte r4, Byte r5) throws IllegalArgumentException {
        super.validateArgs(r1, r2, r3, r4, r5);
        for (byte r : Arrays.asList(r1, r2, r3, r4, r5)) {
            if (RConstants.isConstantValid(r)) continue;
            throw new IllegalArgumentException("R constant value must be between0 and 127 (inclusive)");
        }
    }

    private static boolean isConstantValid(byte v) {
        return v >= 0 && v <= 127;
    }
}

