/*
 * Decompiled with CFR 0.152.
 */
package threegpp.milenage.biginteger;

import java.math.BigInteger;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import threegpp.milenage.MilenageBuffer;
import threegpp.milenage.biginteger.BigIntegerHelper;

public class BigIntegerBuffer
implements MilenageBuffer<BigInteger> {
    private static final BigInteger ALL_ONES = BigIntegerHelper.getAllOnes();
    private static final int SQN_AMF_LENGTH = 8;
    private static final int HEX_BUFFER_LENGTH = 32;
    private final BigInteger buffer;

    public BigIntegerBuffer(byte[] bytes) {
        this(BigIntegerBuffer.hexlify(bytes));
    }

    public BigIntegerBuffer(BigInteger val) {
        this.buffer = BigIntegerHelper.ensureUnsigned(val);
    }

    public BigIntegerBuffer(String hexVal) {
        if (hexVal.length() != 32) {
            throw new IllegalArgumentException("Hex value have to represent 16bytes");
        }
        this.buffer = BigIntegerHelper.unhexlify(hexVal);
    }

    @Override
    public MilenageBuffer<BigInteger> xor(MilenageBuffer<BigInteger> that) {
        return new BigIntegerBuffer(this.buffer.xor(that.getRawBuffer()));
    }

    @Override
    public MilenageBuffer<BigInteger> leftCircularBitRotation(byte numBits) throws IllegalArgumentException {
        if (numBits < 0) {
            throw new IllegalArgumentException("leftCircularBitRotation(): numBits can not be negative");
        }
        if (numBits == 0) {
            return new BigIntegerBuffer(this.buffer);
        }
        int reversedShift = 128 - numBits;
        BigInteger lShifted = this.buffer.shiftLeft(numBits);
        BigInteger rShifted = this.buffer.shiftRight(reversedShift);
        BigInteger cleanResult = lShifted.or(rShifted).and(ALL_ONES);
        return new BigIntegerBuffer(cleanResult);
    }

    @Override
    public MilenageBuffer<BigInteger> encrypt(Cipher cipher) {
        try {
            return new BigIntegerBuffer(cipher.doFinal(this.toBytes()));
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[][] takeBytes(int ... args) throws IndexOutOfBoundsException {
        if (args.length % 2 != 0) {
            throw new IllegalArgumentException("takeBytes() expects an even number of arguments");
        }
        byte[] buf = this.toBytes();
        byte[][] result = new byte[args.length / 2][];
        int i = 0;
        int j = 0;
        while (i < args.length) {
            int beg = args[i++];
            int end = args[i++];
            result[j] = Arrays.copyOfRange(buf, beg, end);
            ++j;
        }
        return result;
    }

    @Override
    public byte[] toBytes() {
        byte[] result = this.buffer.toByteArray();
        int delta = 16 - result.length;
        if (delta < 0) {
            return Arrays.copyOfRange(result, 1, 17);
        }
        if (delta > 0) {
            return BigIntegerBuffer.arrayPadLeft(result, 16);
        }
        return result;
    }

    @Override
    public BigInteger getRawBuffer() {
        return this.buffer;
    }

    public String toString() {
        return BigIntegerBuffer.hexlify(this.toBytes());
    }

    public static String hexlify(byte[] bytes) {
        StringBuilder hexVal = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            hexVal.append(String.format("%02X", b));
        }
        return hexVal.toString();
    }

    private static byte[] arrayPadLeft(byte[] src, int newLength) {
        byte[] result = new byte[newLength];
        System.arraycopy(src, 0, result, result.length - src.length, src.length);
        return result;
    }

    public static BigIntegerBuffer createIN1(byte[] sqn, byte[] amf) {
        String errorMessage = null;
        if (sqn.length != 6) {
            errorMessage = "Invalid length of SQN buffer";
        } else if (amf.length != 2) {
            errorMessage = "Invalid length of AMF buffer";
        }
        if (null != errorMessage) {
            throw new IllegalArgumentException(errorMessage);
        }
        byte[] n1 = Arrays.copyOf(sqn, 16);
        System.arraycopy(amf, 0, n1, 6, 2);
        System.arraycopy(n1, 0, n1, 8, 8);
        return new BigIntegerBuffer(n1);
    }
}

