/*
 * Decompiled with CFR 0.152.
 */
package threegpp.milenage.biginteger;

import java.math.BigInteger;
import threegpp.milenage.MilenageBufferFactory;
import threegpp.milenage.biginteger.BigIntegerBuffer;

public class BigIntegerBufferFactory
implements MilenageBufferFactory<BigIntegerBuffer> {
    private static BigIntegerBufferFactory ourInstance = new BigIntegerBufferFactory();

    public static BigIntegerBufferFactory getInstance() {
        return ourInstance;
    }

    private BigIntegerBufferFactory() {
    }

    @Override
    public BigIntegerBuffer create(byte[] data) {
        return new BigIntegerBuffer(data);
    }

    @Override
    public BigIntegerBuffer create(String hexString) {
        return new BigIntegerBuffer(hexString);
    }

    public BigIntegerBuffer[] createSampleCConstants() {
        return new BigIntegerBuffer[]{new BigIntegerBuffer(BigInteger.ZERO), new BigIntegerBuffer(BigInteger.valueOf(1L)), new BigIntegerBuffer(BigInteger.valueOf(2L)), new BigIntegerBuffer(BigInteger.valueOf(4L)), new BigIntegerBuffer(BigInteger.valueOf(8L))};
    }

    @Override
    public BigIntegerBuffer create(byte[] sqn, byte[] amf) {
        return BigIntegerBuffer.createIN1(sqn, amf);
    }

    public BigIntegerBuffer[] createArray(byte[] ... buffers) {
        BigIntegerBuffer[] array = new BigIntegerBuffer[buffers.length];
        for (int i = 0; i < buffers.length; ++i) {
            array[i] = this.create(buffers[i]);
        }
        return array;
    }

    public BigIntegerBuffer[] createArray(String ... buffers) {
        BigIntegerBuffer[] array = new BigIntegerBuffer[buffers.length];
        for (int i = 0; i < buffers.length; ++i) {
            array[i] = this.create(buffers[i]);
        }
        return array;
    }
}

