/*
 * Decompiled with CFR 0.152.
 */
package threegpp.milenage.biginteger;

import java.math.BigInteger;

public class BigIntegerHelper {
    public static BigInteger unhexlify(String hexString) {
        return new BigInteger("00" + hexString, 16);
    }

    public static boolean isPositive(BigInteger i) {
        return i.signum() > 0;
    }

    public static boolean isNegative(BigInteger i) {
        return i.signum() < 0;
    }

    public static boolean isZero(BigInteger i) {
        return i.signum() == 0;
    }

    public static BigInteger getAllOnes() {
        return new BigInteger(new String(new char[32]).replace('\u0000', 'F'), 16);
    }

    public static BigInteger ensureUnsigned(BigInteger that, int bitLength) {
        if (BigIntegerHelper.isNegative(that)) {
            if (bitLength <= 0) {
                throw new IllegalArgumentException("ensureUnsigned(): bitLength should be positive");
            }
            return BigInteger.ONE.shiftLeft(bitLength).add(that);
        }
        return that;
    }

    public static BigInteger ensureUnsigned(BigInteger that) {
        return BigIntegerHelper.ensureUnsigned(that, 16);
    }
}

