/*
 * Decompiled with CFR 0.152.
 */
package threegpp.charset.gsm;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import threegpp.charset.gsm.GSMCharset;

public class GSMDecoder
extends CharsetDecoder {
    private static final float AVG_CHARS_PER_BYTE = 1.0f;
    private static final float MAX_CHARS_PER_BYTE = 1.0f;
    private boolean nextCharIsExtended = false;

    GSMDecoder(GSMCharset cs) {
        super(cs, 1.0f, 1.0f);
    }

    @Override
    protected void implReset() {
        this.nextCharIsExtended = false;
    }

    @Override
    protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
        while (in.hasRemaining()) {
            if (!out.hasRemaining()) {
                return CoderResult.OVERFLOW;
            }
            byte code = in.get();
            if (!this.nextCharIsExtended && GSMDecoder.isExtendedMarker(code)) {
                this.nextCharIsExtended = true;
                continue;
            }
            char decoded = GSMDecoder.GSMCode2Char(code, this.nextCharIsExtended);
            if (decoded == '\uffff') {
                return CoderResult.unmappableForLength(in.position());
            }
            out.put(decoded);
            this.nextCharIsExtended = false;
        }
        return CoderResult.UNDERFLOW;
    }

    private static char GSMCode2Char(int code, boolean ext) {
        try {
            if (ext) {
                return "          \n         ^                   {}     \\            [~] |                                    \u20ac                          ".charAt(code);
            }
            return "@\u00a3$\u00a5\u00e8\u00e9\u00f9\u00ec\u00f2\u00c7\n\u00d8\u00f8\r\u00c5\u00e5\u0394_\u03a6\u0393\u039b\u03a9\u03a0\u03a8\u03a3\u0398\u039e\uffff\u00c6\u00e6\u00df\u00c9 !\"#\u00a4%&'()*+,-./0123456789:;<=>?\u00a1ABCDEFGHIJKLMNOPQRSTUVWXYZ\u00c4\u00d6\u00d1\u00dc\u00a7\u00bfabcdefghijklmnopqrstuvwxyz\u00e4\u00f6\u00f1\u00fc\u00e0".charAt(code);
        }
        catch (IndexOutOfBoundsException whatever) {
            return '\uffff';
        }
    }

    private static boolean isExtendedMarker(int code) {
        return code == 27;
    }
}

