/*
 * Decompiled with CFR 0.152.
 */
package threegpp.charset.ucs2;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import threegpp.charset.Util;
import threegpp.charset.ucs2.UCS2Charset80;

public class UCS2Decoder80
extends CharsetDecoder {
    private static final float AVG_CHARS_PER_BYTE = 0.5f;
    private static final float MAX_CHARS_PER_BYTE = 1.0f;
    private boolean inInitialState = true;
    private CharsetDecoder decoder = UCS2Charset80.underlyingCharset.newDecoder();
    private InputStorage inputStorage;

    UCS2Decoder80(UCS2Charset80 cs) {
        super(cs, 0.5f, 1.0f);
    }

    @Override
    protected CoderResult implFlush(CharBuffer out) {
        if (this.directDecodingInProgress()) {
            return this.finalizeAndFlushDecoder(out);
        }
        if (!this.inputStorage.isClosedForInput()) {
            this.inputStorage.closeForInput();
        }
        if (!this.inputStorage.buffer().hasRemaining()) {
            return this.finalizeAndFlushDecoder(out);
        }
        return this.decoder.decode(this.inputStorage.buffer(), out, false);
    }

    @Override
    protected void implReset() {
        this.decoder.reset();
        this.inInitialState = true;
        this.inputStorage = null;
    }

    @Override
    protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
        if (this.inInitialState) {
            if (!UCS2Decoder80.isTagValid(in.get())) {
                return CoderResult.malformedForLength(in.position());
            }
            this.inInitialState = false;
        }
        if (this.directDecodingInProgress() && UCS2Decoder80.isCurrentInputCorrect(in)) {
            return this.decoder.decode(in, out, false);
        }
        this.initInputStorageIfEmpty(in.remaining());
        this.collectBytes(in);
        return CoderResult.UNDERFLOW;
    }

    private void finalizeDecoder() {
        this.decoder.decode(ByteBuffer.allocate(0), CharBuffer.allocate(0), true);
    }

    private static boolean isTagValid(byte tag) {
        return Util.keepUnsigned(tag) == UCS2Charset80.CHARSET_TAG;
    }

    private boolean directDecodingInProgress() {
        return null == this.inputStorage;
    }

    private static boolean isCurrentInputCorrect(ByteBuffer in) {
        return in.remaining() % 2 == 0;
    }

    private void collectBytes(ByteBuffer in) {
        if (in.hasArray()) {
            this.collectBytesFromArrayBackedBuffer(in);
        } else {
            this.collectBytesFromBuffer(in);
        }
    }

    private void collectBytesFromArrayBackedBuffer(ByteBuffer in) {
        this.inputStorage.write(in.array(), in.position(), in.remaining());
        in.position(in.limit());
    }

    private void collectBytesFromBuffer(ByteBuffer in) {
        while (in.hasRemaining()) {
            this.inputStorage.write(in.get());
        }
    }

    private void initInputStorageIfEmpty(int initialSize) {
        if (null == this.inputStorage) {
            this.inputStorage = new InputStorage(initialSize);
        }
    }

    private CoderResult finalizeAndFlushDecoder(CharBuffer out) {
        this.finalizeDecoder();
        return this.decoder.flush(out);
    }

    private static class InputStorage {
        private ByteArrayOutputStream storage;
        private ByteBuffer result;

        InputStorage(int initialSize) {
            this.storage = new ByteArrayOutputStream(initialSize);
        }

        void write(int b) {
            if (this.isClosedForInput()) {
                throw new IllegalStateException();
            }
            this.storage.write(b);
        }

        void write(byte[] b, int off, int len) {
            if (this.isClosedForInput()) {
                throw new IllegalStateException();
            }
            this.storage.write(b, off, len);
        }

        void closeForInput() {
            if (this.isClosedForInput()) {
                throw new IllegalStateException();
            }
            this.result = ByteBuffer.wrap(this.storage.toByteArray());
        }

        boolean isClosedForInput() {
            return null != this.result;
        }

        ByteBuffer buffer() {
            if (!this.isClosedForInput()) {
                throw new IllegalStateException();
            }
            return this.result;
        }
    }
}

