/*
 * Decompiled with CFR 0.152.
 */
package threegpp.charset.ucs2;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import threegpp.charset.ucs2.UCS2Charset80;

public class UCS2Encoder80
extends CharsetEncoder {
    private static final float AVG_BYTES_PER_CHAR = 2.0f;
    private static final float MAX_BYTES_PER_CHAR = 3.0f;
    private CharsetEncoder encoder = UCS2Charset80.underlyingCharset.newEncoder();
    private boolean inInitialState = true;

    UCS2Encoder80(UCS2Charset80 cs) {
        super(cs, 2.0f, 3.0f);
    }

    @Override
    protected CoderResult implFlush(ByteBuffer out) {
        this.finalizeEncoder();
        return this.encoder.flush(out);
    }

    @Override
    protected void implReset() {
        this.encoder.reset();
        this.inInitialState = true;
    }

    @Override
    public boolean canEncode(char c) {
        return this.encoder.canEncode(c);
    }

    @Override
    public boolean canEncode(CharSequence cs) {
        return this.encoder.canEncode(cs);
    }

    @Override
    protected CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
        if (this.inInitialState) {
            out.put((byte)UCS2Charset80.CHARSET_TAG);
            this.inInitialState = false;
        }
        return this.encoder.encode(in, out, false);
    }

    @Override
    public boolean isLegalReplacement(byte[] replacement) {
        return true;
    }

    private void finalizeEncoder() {
        CharBuffer emptyIn = CharBuffer.wrap("");
        ByteBuffer out = ByteBuffer.allocate(0);
        this.encoder.encode(emptyIn, out, true);
    }
}

