/*
 * Decompiled with CFR 0.152.
 */
package com.github.brandtg.stl;

public final class StlConfig {
    protected static final int DEFAULT_INNER_LOOP_PASSES = 10;
    protected static final int DEFAULT_ROBUSTNESS_ITERATIONS = 1;
    protected static final double DEFAULT_TREND_BANDWIDTH = 0.2;
    protected static final double DEFAULT_SEASONAL_BANDWIDTH = 0.4;
    protected static final int DEFAULT_LOESS_ROBUSTNESS_ITERATIONS = 0;
    private final int numberOfObservations;
    private int numberOfInnerLoopPasses = 10;
    private int numberOfRobustnessIterations = 1;
    private double trendComponentBandwidth = 0.2;
    private double seasonalComponentBandwidth = 0.4;
    private int loessRobustnessIterations = 0;
    private boolean periodic = true;

    protected StlConfig(int numberOfObservations) {
        this.numberOfObservations = numberOfObservations;
    }

    public int getNumberOfObservations() {
        return this.numberOfObservations;
    }

    public int getNumberOfInnerLoopPasses() {
        return this.numberOfInnerLoopPasses;
    }

    public void setNumberOfInnerLoopPasses(int numberOfInnerLoopPasses) {
        this.numberOfInnerLoopPasses = numberOfInnerLoopPasses;
    }

    public int getNumberOfRobustnessIterations() {
        return this.numberOfRobustnessIterations;
    }

    public void setNumberOfRobustnessIterations(int numberOfRobustnessIterations) {
        this.numberOfRobustnessIterations = numberOfRobustnessIterations;
    }

    public double getTrendComponentBandwidth() {
        return this.trendComponentBandwidth;
    }

    public void setTrendComponentBandwidth(double trendComponentBandwidth) {
        this.trendComponentBandwidth = trendComponentBandwidth;
    }

    public double getSeasonalComponentBandwidth() {
        return this.seasonalComponentBandwidth;
    }

    public void setSeasonalComponentBandwidth(double seasonalComponentBandwidth) {
        this.seasonalComponentBandwidth = seasonalComponentBandwidth;
    }

    public boolean isPeriodic() {
        return this.periodic;
    }

    public void setPeriodic(boolean periodic) {
        this.periodic = periodic;
    }

    public int getLoessRobustnessIterations() {
        return this.loessRobustnessIterations;
    }

    public void setLoessRobustnessIterations(int loessRobustnessIterations) {
        this.loessRobustnessIterations = loessRobustnessIterations;
    }

    protected void check(int numberOfDataPoints) {
        int numSeasons;
        int seasonalBandwidthInPoints;
        if (this.numberOfObservations < 2) {
            throw new IllegalArgumentException("Periodicity (numberOfObservations) must be >= 2");
        }
        if (numberOfDataPoints <= 2 * this.numberOfObservations) {
            throw new IllegalArgumentException("numberOfDataPoints(total length) must contain at least 2 * Periodicity (numberOfObservations) points");
        }
        int trendBandwidthInPoints = (int)(this.trendComponentBandwidth * (double)numberOfDataPoints);
        if (trendBandwidthInPoints < 2) {
            this.setTrendComponentBandwidth(2.0 / (double)numberOfDataPoints);
        }
        if ((seasonalBandwidthInPoints = (int)(this.seasonalComponentBandwidth * (double)(numSeasons = numberOfDataPoints / this.numberOfObservations))) < 2) {
            this.setSeasonalComponentBandwidth(2.0 / (double)numSeasons);
        }
        if (this.periodic) {
            double windowSpan = 1.5 * (double)this.numberOfObservations / (1.0 - 1.5 / ((double)numberOfDataPoints * this.seasonalComponentBandwidth)) / (double)numberOfDataPoints;
            this.setTrendComponentBandwidth(windowSpan);
        } else {
            double trendWindow = this.trendComponentBandwidth * (double)numberOfDataPoints;
            double seasonalWindow = this.seasonalComponentBandwidth * (double)numberOfDataPoints;
            double minTrendWindow = 1.5 * (double)this.numberOfObservations / (1.0 - 1.5 / seasonalWindow);
            if (trendWindow < minTrendWindow) {
                throw new IllegalArgumentException("Trend component bandwidth too small: trendWindow=" + trendWindow + " min=" + minTrendWindow);
            }
        }
    }
}

