/*
 * Decompiled with CFR 0.152.
 */
package com.github.brandtg.stl;

import com.github.brandtg.stl.StlConfig;
import com.github.brandtg.stl.StlResult;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.analysis.interpolation.LoessInterpolator;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StlDecomposition {
    private final StlConfig config;

    public StlDecomposition(int numberOfObservations) {
        this.config = new StlConfig(numberOfObservations);
    }

    public StlConfig getConfig() {
        return this.config;
    }

    public StlResult decompose(List<Number> times, List<Number> series) {
        double[] timesArray = new double[times.size()];
        double[] seriesArray = new double[series.size()];
        int idx = 0;
        for (Number time : times) {
            timesArray[idx++] = time.doubleValue();
        }
        idx = 0;
        for (Number value : series) {
            seriesArray[idx++] = value.doubleValue();
        }
        return this.decompose(timesArray, seriesArray);
    }

    public StlResult decompose(double[] times, double[] series) {
        int i;
        if (times.length != series.length) {
            throw new IllegalArgumentException("Times (" + times.length + ") and series (" + series.length + ") must be same size");
        }
        int numberOfDataPoints = series.length;
        this.config.check(numberOfDataPoints);
        double[] trend = new double[numberOfDataPoints];
        double[] seasonal = new double[numberOfDataPoints];
        double[] remainder = new double[numberOfDataPoints];
        double[] robustness = null;
        double[] detrend = new double[numberOfDataPoints];
        double[] combinedSmoothed = new double[numberOfDataPoints + 2 * this.config.getNumberOfObservations()];
        double[] combinedSmoothedTimes = new double[numberOfDataPoints + 2 * this.config.getNumberOfObservations()];
        for (i = 0; i < combinedSmoothedTimes.length; ++i) {
            combinedSmoothedTimes[i] = i;
        }
        for (int l = 0; l < this.config.getNumberOfRobustnessIterations(); ++l) {
            for (int k = 0; k < this.config.getNumberOfInnerLoopPasses(); ++k) {
                int i2;
                int i3;
                for (int i4 = 0; i4 < numberOfDataPoints; ++i4) {
                    detrend[i4] = series[i4] - trend[i4];
                }
                int numberOfObservations = this.config.getNumberOfObservations();
                CycleSubSeries cycle = new CycleSubSeries(times, series, robustness, detrend, numberOfObservations);
                cycle.compute();
                List<double[]> cycleSubseries = cycle.getCycleSubSeries();
                List<double[]> cycleTimes = cycle.getCycleTimes();
                List<double[]> cycleRobustnessWeights = cycle.getCycleRobustnessWeights();
                for (i3 = 0; i3 < cycleSubseries.size(); ++i3) {
                    double[] paddedTimes = new double[cycleTimes.get(i3).length + 2];
                    for (int j = 0; j < paddedTimes.length; ++j) {
                        paddedTimes[j] = j;
                    }
                    double[] paddedSeries = new double[cycleSubseries.get(i3).length + 2];
                    System.arraycopy(cycleSubseries.get(i3), 0, paddedSeries, 1, cycleSubseries.get(i3).length);
                    double[] weights = cycleRobustnessWeights.get(i3);
                    double[] paddedWeights = null;
                    if (weights != null) {
                        paddedWeights = new double[weights.length + 2];
                        System.arraycopy(weights, 0, paddedWeights, 1, weights.length);
                    }
                    double[] smoothed = this.loessSmooth(paddedTimes, paddedSeries, this.config.getSeasonalComponentBandwidth(), paddedWeights);
                    cycleSubseries.set(i3, smoothed);
                }
                for (i3 = 0; i3 < cycleSubseries.size(); ++i3) {
                    double[] subseriesValues = cycleSubseries.get(i3);
                    for (int cycleIdx = 0; cycleIdx < subseriesValues.length; ++cycleIdx) {
                        combinedSmoothed[numberOfObservations * cycleIdx + i3] = subseriesValues[cycleIdx];
                    }
                }
                double[] filtered = this.lowPassFilter(combinedSmoothedTimes, combinedSmoothed, null);
                int offset = this.config.getNumberOfObservations();
                for (i2 = 0; i2 < seasonal.length; ++i2) {
                    seasonal[i2] = combinedSmoothed[i2 + offset] - filtered[i2 + offset];
                }
                for (i2 = 0; i2 < numberOfDataPoints; ++i2) {
                    trend[i2] = series[i2] - seasonal[i2];
                }
                trend = this.loessSmooth(times, trend, this.config.getTrendComponentBandwidth(), robustness);
            }
            for (int i5 = 0; i5 < numberOfDataPoints; ++i5) {
                remainder[i5] = series[i5] - trend[i5] - seasonal[i5];
            }
            robustness = this.robustnessWeights(remainder);
        }
        if (this.config.isPeriodic()) {
            for (i = 0; i < this.config.getNumberOfObservations(); ++i) {
                double sum = 0.0;
                int count = 0;
                for (int j = i; j < numberOfDataPoints; j += this.config.getNumberOfObservations()) {
                    sum += seasonal[j];
                    ++count;
                }
                double mean = sum / (double)count;
                for (int j = i; j < numberOfDataPoints; j += this.config.getNumberOfObservations()) {
                    seasonal[j] = mean;
                }
            }
            for (i = 0; i < series.length; ++i) {
                remainder[i] = series[i] - trend[i] - seasonal[i];
            }
        }
        return new StlResult(times, series, trend, seasonal, remainder);
    }

    private double[] robustnessWeights(double[] remainder) {
        double[] absRemainder = new double[remainder.length];
        for (int i = 0; i < remainder.length; ++i) {
            absRemainder[i] = Math.abs(remainder[i]);
        }
        DescriptiveStatistics stats = new DescriptiveStatistics(absRemainder);
        double outlierThreshold = 6.0 * stats.getPercentile(50.0);
        double[] robustness = new double[remainder.length];
        for (int i = 0; i < remainder.length; ++i) {
            robustness[i] = this.biSquareWeight(absRemainder[i] / outlierThreshold);
        }
        return robustness;
    }

    private double biSquareWeight(double value) {
        if (value < 0.0) {
            throw new IllegalArgumentException("Invalid value, must be >= 0: " + value);
        }
        if (value < 1.0) {
            return Math.pow(1.0 - Math.pow(value, 2.0), 2.0);
        }
        return 0.0;
    }

    private double[] lowPassFilter(double[] times, double[] series, double[] weights) {
        double nextOdd = this.config.getNumberOfObservations() % 2 == 1 ? (double)this.config.getNumberOfObservations() : (double)(this.config.getNumberOfObservations() + 1);
        double lowPassBandwidth = nextOdd / (double)series.length;
        series = this.movingAverage(series, this.config.getNumberOfObservations());
        series = this.movingAverage(series, this.config.getNumberOfObservations());
        series = this.movingAverage(series, 3);
        series = this.loessSmooth(times, series, lowPassBandwidth, weights);
        return series;
    }

    private double[] loessSmooth(double[] times, double[] series, double bandwidth, double[] weights) {
        if (weights == null) {
            return new LoessInterpolator(bandwidth, this.config.getLoessRobustnessIterations()).smooth(times, series);
        }
        return new LoessInterpolator(bandwidth, this.config.getLoessRobustnessIterations()).smooth(times, series, weights);
    }

    private double[] movingAverage(double[] series, int window) {
        int i;
        double[] movingAverage = new double[series.length];
        double average = 0.0;
        for (i = 0; i < window; ++i) {
            movingAverage[i] = average += series[i] / (double)window;
        }
        for (i = window; i < series.length; ++i) {
            average -= series[i - window] / (double)window;
            movingAverage[i] = average += series[i] / (double)window;
        }
        return movingAverage;
    }

    public static void main(String[] args) throws Exception {
        String line;
        ArrayList<Number> times = new ArrayList<Number>();
        ArrayList<Number> measures = new ArrayList<Number>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        while ((line = reader.readLine()) != null) {
            String[] tokens = line.split(",");
            times.add(Long.valueOf(tokens[0]));
            measures.add(Double.valueOf(tokens[1]));
        }
        StlDecomposition stl = new StlDecomposition(Integer.valueOf(args[0]));
        stl.getConfig().setSeasonalComponentBandwidth(Double.valueOf(System.getProperty("seasonal.bandwidth", String.valueOf(0.4))));
        stl.getConfig().setTrendComponentBandwidth(Double.valueOf(System.getProperty("trend.bandwidth", String.valueOf(0.2))));
        stl.getConfig().setNumberOfInnerLoopPasses(Integer.valueOf(System.getProperty("inner.loop", String.valueOf(10))));
        StlResult res = stl.decompose(times, measures);
        for (int i = 0; i < times.size(); ++i) {
            System.out.println(String.format("%d,%02f,%02f,%02f,%02f", (long)res.getTimes()[i], res.getSeries()[i], res.getTrend()[i], res.getSeasonal()[i], res.getRemainder()[i]));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CycleSubSeries {
        private final List<double[]> cycleSubSeries = new ArrayList<double[]>();
        private final List<double[]> cycleTimes = new ArrayList<double[]>();
        private final List<double[]> cycleRobustnessWeights = new ArrayList<double[]>();
        private final int numberOfObservations;
        private final double[] times;
        private final double[] series;
        private final double[] robustness;
        private final double[] detrend;

        CycleSubSeries(double[] times, double[] series, double[] robustness, double[] detrend, int numberOfObservations) {
            this.times = times;
            this.series = series;
            this.robustness = robustness;
            this.detrend = detrend;
            this.numberOfObservations = numberOfObservations;
        }

        List<double[]> getCycleSubSeries() {
            return this.cycleSubSeries;
        }

        List<double[]> getCycleTimes() {
            return this.cycleTimes;
        }

        List<double[]> getCycleRobustnessWeights() {
            return this.cycleRobustnessWeights;
        }

        void compute() {
            for (int i = 0; i < this.numberOfObservations; ++i) {
                int subseriesLength = this.series.length / this.numberOfObservations;
                double[] subseriesValues = new double[subseriesLength += i < this.series.length % this.numberOfObservations ? 1 : 0];
                double[] subseriesTimes = new double[subseriesLength];
                double[] subseriesRobustnessWeights = null;
                if (this.robustness != null) {
                    subseriesRobustnessWeights = new double[subseriesLength];
                }
                for (int cycleIdx = 0; cycleIdx < subseriesLength; ++cycleIdx) {
                    subseriesValues[cycleIdx] = this.detrend[cycleIdx * this.numberOfObservations + i];
                    subseriesTimes[cycleIdx] = this.times[cycleIdx * this.numberOfObservations + i];
                    if (subseriesRobustnessWeights == null) continue;
                    subseriesRobustnessWeights[cycleIdx] = this.robustness[cycleIdx * this.numberOfObservations + i];
                    if (!(subseriesRobustnessWeights[cycleIdx] < 0.001)) continue;
                    subseriesRobustnessWeights[cycleIdx] = 0.01;
                }
                this.cycleSubSeries.add(subseriesValues);
                this.cycleTimes.add(subseriesTimes);
                this.cycleRobustnessWeights.add(subseriesRobustnessWeights);
            }
        }
    }
}

