/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.StringUtil;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import picard.PicardException;
import picard.analysis.BaseDistributionByCycleMetrics;
import picard.analysis.SinglePassSamProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.Metrics;
import picard.util.RExecutor;

@CommandLineProgramProperties(usage="Program to chart the nucleotide distribution per cycle in a SAM or BAM file.", usageShort="Program to chart the nucleotide distribution per cycle in a SAM or BAM file.", programGroup=Metrics.class)
public class CollectBaseDistributionByCycle
extends SinglePassSamProgram {
    @Option(shortName="CHART", doc="A file (with .pdf extension) to write the chart to.")
    public File CHART_OUTPUT;
    @Option(doc="If set to true, calculate the base distribution over aligned reads only.")
    public boolean ALIGNED_READS_ONLY = false;
    @Option(doc="If set to true calculate the base distribution over PF reads only.")
    public boolean PF_READS_ONLY = false;
    private HistogramGenerator hist;
    private String plotSubtitle = "";
    private final Log log = Log.getInstance(CollectBaseDistributionByCycle.class);

    public static void main(String[] stringArray) {
        System.exit(new CollectBaseDistributionByCycle().instanceMain(stringArray));
    }

    @Override
    protected void setup(SAMFileHeader sAMFileHeader, File file) {
        IOUtil.assertFileIsWritable((File)this.CHART_OUTPUT);
        List list = sAMFileHeader.getReadGroups();
        if (list.size() == 1) {
            this.plotSubtitle = StringUtil.asEmptyIfNull((Object)((SAMReadGroupRecord)list.get(0)).getLibrary());
        }
        this.hist = new HistogramGenerator();
    }

    @Override
    protected void acceptRead(SAMRecord sAMRecord, ReferenceSequence referenceSequence) {
        if (this.PF_READS_ONLY && sAMRecord.getReadFailsVendorQualityCheckFlag()) {
            return;
        }
        if (this.ALIGNED_READS_ONLY && sAMRecord.getReadUnmappedFlag()) {
            return;
        }
        if (sAMRecord.isSecondaryOrSupplementary()) {
            return;
        }
        this.hist.addRecord(sAMRecord);
    }

    @Override
    protected void finish() {
        MetricsFile metricsFile = this.getMetricsFile();
        this.hist.addToMetricsFile(metricsFile);
        metricsFile.write(this.OUTPUT);
        if (this.hist.isEmpty()) {
            this.log.warn(new Object[]{"No valid bases found in input file. No plot will be produced."});
        } else {
            int n = RExecutor.executeFromClasspath("picard/analysis/baseDistributionByCycle.R", this.OUTPUT.getAbsolutePath(), this.CHART_OUTPUT.getAbsolutePath(), this.INPUT.getName(), this.plotSubtitle);
            if (n != 0) {
                throw new PicardException("R script nucleotideDistributionByCycle.R failed with return code " + n);
            }
        }
    }

    private class HistogramGenerator {
        private int maxLengthSoFar = 0;
        private final long[][] firstReadTotalsByCycle = new long[5][this.maxLengthSoFar];
        private long[] firstReadCountsByCycle = new long[this.maxLengthSoFar];
        private final long[][] secondReadTotalsByCycle = new long[5][this.maxLengthSoFar];
        private long[] secondReadCountsByCycle = new long[this.maxLengthSoFar];
        private boolean seenSecondEnd = false;

        private HistogramGenerator() {
        }

        private int baseToInt(byte by) {
            switch (by) {
                case 65: 
                case 97: {
                    return 0;
                }
                case 67: 
                case 99: {
                    return 1;
                }
                case 71: 
                case 103: {
                    return 2;
                }
                case 84: 
                case 116: {
                    return 3;
                }
            }
            return 4;
        }

        void addRecord(SAMRecord sAMRecord) {
            byte[] byArray = sAMRecord.getReadBases();
            if (byArray == null) {
                return;
            }
            int n = byArray.length;
            boolean bl = sAMRecord.getReadNegativeStrandFlag();
            this.ensureArraysBigEnough(n + 1);
            if (sAMRecord.getReadPairedFlag() && sAMRecord.getSecondOfPairFlag()) {
                this.seenSecondEnd = true;
                for (int i = 0; i < n; ++i) {
                    int n2 = bl ? n - i : i + 1;
                    long[] lArray = this.secondReadTotalsByCycle[this.baseToInt(byArray[i])];
                    int n3 = n2;
                    lArray[n3] = lArray[n3] + 1L;
                    int n4 = n2;
                    this.secondReadCountsByCycle[n4] = this.secondReadCountsByCycle[n4] + 1L;
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    int n5 = bl ? n - i : i + 1;
                    long[] lArray = this.firstReadTotalsByCycle[this.baseToInt(byArray[i])];
                    int n6 = n5;
                    lArray[n6] = lArray[n6] + 1L;
                    int n7 = n5;
                    this.firstReadCountsByCycle[n7] = this.firstReadCountsByCycle[n7] + 1L;
                }
            }
        }

        private void ensureArraysBigEnough(int n) {
            if (n > this.maxLengthSoFar) {
                for (int i = 0; i < 5; ++i) {
                    this.firstReadTotalsByCycle[i] = Arrays.copyOf(this.firstReadTotalsByCycle[i], n);
                    this.secondReadTotalsByCycle[i] = Arrays.copyOf(this.secondReadTotalsByCycle[i], n);
                }
                this.firstReadCountsByCycle = Arrays.copyOf(this.firstReadCountsByCycle, n);
                this.secondReadCountsByCycle = Arrays.copyOf(this.secondReadCountsByCycle, n);
                this.maxLengthSoFar = n;
            }
        }

        boolean isEmpty() {
            return this.maxLengthSoFar == 0;
        }

        public void addToMetricsFile(MetricsFile<BaseDistributionByCycleMetrics, ?> metricsFile) {
            BaseDistributionByCycleMetrics baseDistributionByCycleMetrics;
            int n;
            int n2 = 0;
            for (n = 0; n < this.maxLengthSoFar; ++n) {
                if (0L == this.firstReadCountsByCycle[n]) continue;
                baseDistributionByCycleMetrics = new BaseDistributionByCycleMetrics();
                baseDistributionByCycleMetrics.READ_END = 1;
                baseDistributionByCycleMetrics.CYCLE = n;
                baseDistributionByCycleMetrics.PCT_A = 100.0 * (double)this.firstReadTotalsByCycle[0][n] / (double)this.firstReadCountsByCycle[n];
                baseDistributionByCycleMetrics.PCT_C = 100.0 * (double)this.firstReadTotalsByCycle[1][n] / (double)this.firstReadCountsByCycle[n];
                baseDistributionByCycleMetrics.PCT_G = 100.0 * (double)this.firstReadTotalsByCycle[2][n] / (double)this.firstReadCountsByCycle[n];
                baseDistributionByCycleMetrics.PCT_T = 100.0 * (double)this.firstReadTotalsByCycle[3][n] / (double)this.firstReadCountsByCycle[n];
                baseDistributionByCycleMetrics.PCT_N = 100.0 * (double)this.firstReadTotalsByCycle[4][n] / (double)this.firstReadCountsByCycle[n];
                metricsFile.addMetric((MetricBase)baseDistributionByCycleMetrics);
                n2 = n;
            }
            if (this.seenSecondEnd) {
                for (n = 0; n < this.maxLengthSoFar; ++n) {
                    if (0L == this.secondReadCountsByCycle[n]) continue;
                    baseDistributionByCycleMetrics = new BaseDistributionByCycleMetrics();
                    baseDistributionByCycleMetrics.READ_END = 2;
                    baseDistributionByCycleMetrics.CYCLE = n + n2;
                    baseDistributionByCycleMetrics.PCT_A = 100.0 * (double)this.secondReadTotalsByCycle[0][n] / (double)this.secondReadCountsByCycle[n];
                    baseDistributionByCycleMetrics.PCT_C = 100.0 * (double)this.secondReadTotalsByCycle[1][n] / (double)this.secondReadCountsByCycle[n];
                    baseDistributionByCycleMetrics.PCT_G = 100.0 * (double)this.secondReadTotalsByCycle[2][n] / (double)this.secondReadCountsByCycle[n];
                    baseDistributionByCycleMetrics.PCT_T = 100.0 * (double)this.secondReadTotalsByCycle[3][n] / (double)this.secondReadCountsByCycle[n];
                    baseDistributionByCycleMetrics.PCT_N = 100.0 * (double)this.secondReadTotalsByCycle[4][n] / (double)this.secondReadCountsByCycle[n];
                    metricsFile.addMetric((MetricBase)baseDistributionByCycleMetrics);
                }
            }
        }
    }
}

