/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.IOUtil;
import java.io.File;
import java.text.NumberFormat;
import java.util.List;
import java.util.Set;
import picard.analysis.GcBiasDetailMetrics;
import picard.analysis.GcBiasMetricsCollector;
import picard.analysis.GcBiasUtils;
import picard.analysis.MetricAccumulationLevel;
import picard.analysis.SinglePassSamProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.Metrics;
import picard.metrics.GcBiasMetrics;
import picard.util.RExecutor;

@CommandLineProgramProperties(usage="Tool to collect information about GC bias in the reads in a given BAM file. Computes the number of windows (of size specified by SCAN_WINDOW_SIZE) in the genome at each GC% and counts the number of read starts in each GC bin.  What is output and plotted is the \"normalized coverage\" in each bin - i.e. the number of reads per window normalized to the average number of reads per window across the whole genome..\n", usageShort="Collects information about GC bias in the reads in the provided SAM or BAM", programGroup=Metrics.class)
public class CollectGcBiasMetrics
extends SinglePassSamProgram {
    private static final String R_SCRIPT = "picard/analysis/gcBias.R";
    @Option(shortName="CHART", doc="The PDF file to render the chart to.")
    public File CHART_OUTPUT;
    @Option(shortName="S", doc="The text file to write summary metrics to.")
    public File SUMMARY_OUTPUT;
    @Option(shortName="WINDOW_SIZE", doc="The size of the scanning windows on the reference genome that are used to bin reads.")
    public int SCAN_WINDOW_SIZE = 100;
    @Option(shortName="MGF", doc="For summary metrics, exclude GC windows that include less than this fraction of the genome.")
    public double MINIMUM_GENOME_FRACTION = 1.0E-5;
    @Option(shortName="BS", doc="Whether the SAM or BAM file consists of bisulfite sequenced reads.")
    public boolean IS_BISULFITE_SEQUENCED = false;
    @Option(shortName="LEVEL", doc="The level(s) at which to accumulate metrics.")
    public Set<MetricAccumulationLevel> METRIC_ACCUMULATION_LEVEL = CollectionUtil.makeSet((Object[])new MetricAccumulationLevel[]{MetricAccumulationLevel.ALL_READS});
    private GcBiasMetricsCollector multiCollector;
    private static final int BINS = 101;

    public static void main(String[] stringArray) {
        System.exit(new CollectGcBiasMetrics().instanceMain(stringArray));
    }

    @Override
    protected void setup(SAMFileHeader sAMFileHeader, File file) {
        IOUtil.assertFileIsWritable((File)this.CHART_OUTPUT);
        IOUtil.assertFileIsWritable((File)this.SUMMARY_OUTPUT);
        IOUtil.assertFileIsReadable((File)this.REFERENCE_SEQUENCE);
        int[] nArray = GcBiasUtils.calculateRefWindowsByGc(101, this.REFERENCE_SEQUENCE, this.SCAN_WINDOW_SIZE);
        this.multiCollector = new GcBiasMetricsCollector(this.METRIC_ACCUMULATION_LEVEL, nArray, sAMFileHeader.getReadGroups(), this.SCAN_WINDOW_SIZE, this.IS_BISULFITE_SEQUENCED);
    }

    @Override
    protected void acceptRead(SAMRecord sAMRecord, ReferenceSequence referenceSequence) {
        this.multiCollector.acceptRecord(sAMRecord, referenceSequence);
    }

    @Override
    protected void finish() {
        this.multiCollector.finish();
        MetricsFile metricsFile = this.getMetricsFile();
        MetricsFile metricsFile2 = this.getMetricsFile();
        MetricsFile metricsFile3 = this.getMetricsFile();
        this.multiCollector.addAllLevelsToFile(metricsFile);
        List list = metricsFile.getMetrics();
        for (GcBiasMetrics gcBiasMetrics : list) {
            List list2 = gcBiasMetrics.DETAILS.getMetrics();
            for (GcBiasDetailMetrics gcBiasDetailMetrics : list2) {
                metricsFile2.addMetric((MetricBase)gcBiasDetailMetrics);
            }
            metricsFile3.addMetric((MetricBase)gcBiasMetrics.SUMMARY);
        }
        metricsFile2.write(this.OUTPUT);
        metricsFile3.write(this.SUMMARY_OUTPUT);
        NumberFormat numberFormat = NumberFormat.getIntegerInstance();
        numberFormat.setGroupingUsed(true);
        RExecutor.executeFromClasspath(R_SCRIPT, this.OUTPUT.getAbsolutePath(), this.SUMMARY_OUTPUT.getAbsolutePath(), this.CHART_OUTPUT.getAbsolutePath(), String.valueOf(this.SCAN_WINDOW_SIZE));
    }
}

