/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.SamPairUtil;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.Histogram;
import htsjdk.samtools.util.IOUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import picard.PicardException;
import picard.analysis.JumpingLibraryMetrics;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.Metrics;
import picard.sam.DuplicationMetrics;

@CommandLineProgramProperties(usage="Computes jumping library metrics.  Gets all data for computation from the firstread in each pair and assumes that the MQ tag is set with the mate's mapping quality.  If the MQ tag is not set, then the program assumes that the mate's mapping quality is >= MINIMUM_MAPPING_QUALITY", usageShort="Produces jumping library metrics for the provided SAM/BAMs", programGroup=Metrics.class)
public class CollectJumpingLibraryMetrics
extends CommandLineProgram {
    @Option(shortName="I", doc="BAM file(s) of reads with duplicates marked")
    public List<File> INPUT = new ArrayList<File>();
    @Option(shortName="O", doc="File to which metrics should be written")
    public File OUTPUT;
    @Option(shortName="MQ", doc="Mapping quality minimum cutoff")
    public Integer MINIMUM_MAPPING_QUALITY = 0;
    @Option(shortName="T", doc="When calculating mean and stdev stop when the bins in the tail of the distribution contain fewer than mode/TAIL_LIMIT items")
    public int TAIL_LIMIT = 10000;
    @Option(doc="Jumps greater than or equal to the greater of this value or 2 times the mode of the outward-facing pairs are considered chimeras")
    public int CHIMERA_KB_MIN = 100000;
    private static final int SAMPLE_FOR_MODE = 50000;

    public static void main(String[] stringArray) {
        System.exit(new CollectJumpingLibraryMetrics().instanceMain(stringArray));
    }

    @Override
    protected int doWork() {
        File file22;
        for (File file22 : this.INPUT) {
            IOUtil.assertFileIsReadable((File)file22);
        }
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        Histogram histogram = new Histogram();
        file22 = new Histogram();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        double d = Math.max(this.getOutieMode(), (double)this.CHIMERA_KB_MIN);
        for (File object2 : this.INPUT) {
            SamReader d2 = SamReaderFactory.makeDefault().open(object2);
            if (d2.getFileHeader().getSortOrder() != SAMFileHeader.SortOrder.coordinate) {
                throw new PicardException("SAM file must " + object2.getName() + " must be sorted in coordintate order");
            }
            for (SAMRecord sAMRecord : d2) {
                if (!sAMRecord.getFirstOfPairFlag()) continue;
                if (sAMRecord.getReadUnmappedFlag()) {
                    if (!sAMRecord.getMateUnmappedFlag()) {
                        ++n;
                        continue;
                    }
                    if (sAMRecord.getReferenceIndex() != -1) continue;
                    break;
                }
                if (sAMRecord.getMateUnmappedFlag()) {
                    ++n;
                    continue;
                }
                if (sAMRecord.getAttribute(SAMTag.MQ.name()) != null && sAMRecord.getIntegerAttribute(SAMTag.MQ.name()) < this.MINIMUM_MAPPING_QUALITY || sAMRecord.getMappingQuality() < this.MINIMUM_MAPPING_QUALITY) continue;
                int n9 = Math.abs(sAMRecord.getInferredInsertSize());
                if ((double)n9 > d) {
                    ++n7;
                    continue;
                }
                if (sAMRecord.getMateNegativeStrandFlag() == sAMRecord.getReadNegativeStrandFlag()) {
                    ++n8;
                    continue;
                }
                if (!sAMRecord.getMateReferenceIndex().equals(sAMRecord.getReferenceIndex())) {
                    ++n6;
                    continue;
                }
                SamPairUtil.PairOrientation pairOrientation = SamPairUtil.getPairOrientation((SAMRecord)sAMRecord);
                if (pairOrientation == SamPairUtil.PairOrientation.RF) {
                    file22.increment(Integer.valueOf(n9));
                    ++n3;
                    if (!sAMRecord.getDuplicateReadFlag()) continue;
                    ++n5;
                    continue;
                }
                if (pairOrientation == SamPairUtil.PairOrientation.FR) {
                    histogram.increment((Comparable)Integer.valueOf(n9));
                    ++n2;
                    if (!sAMRecord.getDuplicateReadFlag()) continue;
                    ++n4;
                    continue;
                }
                throw new IllegalStateException("This should never happen");
            }
            CloserUtil.close((Object)d2);
        }
        Iterator<File> iterator = this.getMetricsFile();
        JumpingLibraryMetrics jumpingLibraryMetrics = new JumpingLibraryMetrics();
        jumpingLibraryMetrics.JUMP_PAIRS = n3;
        jumpingLibraryMetrics.JUMP_DUPLICATE_PAIRS = n5;
        jumpingLibraryMetrics.JUMP_DUPLICATE_PCT = n3 != 0 ? (double)n5 / (double)n3 : 0.0;
        jumpingLibraryMetrics.JUMP_LIBRARY_SIZE = n3 > 0 && n5 > 0 ? DuplicationMetrics.estimateLibrarySize(n3, n3 - n5) : 0L;
        file22.trimByTailLimit(this.TAIL_LIMIT);
        jumpingLibraryMetrics.JUMP_MEAN_INSERT_SIZE = file22.getMean();
        jumpingLibraryMetrics.JUMP_STDEV_INSERT_SIZE = file22.getStandardDeviation();
        jumpingLibraryMetrics.NONJUMP_PAIRS = n2;
        jumpingLibraryMetrics.NONJUMP_DUPLICATE_PAIRS = n4;
        jumpingLibraryMetrics.NONJUMP_DUPLICATE_PCT = n2 != 0 ? (double)n4 / (double)n2 : 0.0;
        jumpingLibraryMetrics.NONJUMP_LIBRARY_SIZE = n2 > 0 && n4 > 0 ? DuplicationMetrics.estimateLibrarySize(n2, n2 - n4) : 0L;
        histogram.trimByTailLimit(this.TAIL_LIMIT);
        jumpingLibraryMetrics.NONJUMP_MEAN_INSERT_SIZE = histogram.getMean();
        jumpingLibraryMetrics.NONJUMP_STDEV_INSERT_SIZE = histogram.getStandardDeviation();
        jumpingLibraryMetrics.CHIMERIC_PAIRS = n6 + n7 + n8;
        jumpingLibraryMetrics.FRAGMENTS = n;
        double d2 = (long)(n3 + n2) + jumpingLibraryMetrics.CHIMERIC_PAIRS;
        jumpingLibraryMetrics.PCT_JUMPS = d2 != 0.0 ? (double)n3 / d2 : 0.0;
        jumpingLibraryMetrics.PCT_NONJUMPS = d2 != 0.0 ? (double)n2 / d2 : 0.0;
        jumpingLibraryMetrics.PCT_CHIMERAS = d2 != 0.0 ? (double)jumpingLibraryMetrics.CHIMERIC_PAIRS / d2 : 0.0;
        iterator.addMetric(jumpingLibraryMetrics);
        iterator.write(this.OUTPUT);
        return 0;
    }

    private double getOutieMode() {
        int n = 50000 / this.INPUT.size();
        Histogram histogram = new Histogram();
        for (File file : this.INPUT) {
            SamReader samReader = SamReaderFactory.makeDefault().open(file);
            int n2 = 0;
            SAMRecordIterator sAMRecordIterator = samReader.iterator();
            while (sAMRecordIterator.hasNext() && n2 < n) {
                SAMRecord sAMRecord = (SAMRecord)sAMRecordIterator.next();
                if (!sAMRecord.getFirstOfPairFlag()) continue;
                if (sAMRecord.getReadUnmappedFlag() && sAMRecord.getReferenceIndex() == -1) break;
                if (sAMRecord.getReadUnmappedFlag() || sAMRecord.getMateUnmappedFlag() || sAMRecord.getAttribute(SAMTag.MQ.name()) != null && sAMRecord.getIntegerAttribute(SAMTag.MQ.name()) < this.MINIMUM_MAPPING_QUALITY || sAMRecord.getMappingQuality() < this.MINIMUM_MAPPING_QUALITY || sAMRecord.getMateNegativeStrandFlag() == sAMRecord.getReadNegativeStrandFlag() || !sAMRecord.getMateReferenceIndex().equals(sAMRecord.getReferenceIndex()) || SamPairUtil.getPairOrientation((SAMRecord)sAMRecord) != SamPairUtil.PairOrientation.RF) continue;
                histogram.increment((Comparable)Integer.valueOf(Math.abs(sAMRecord.getInferredInsertSize())));
                ++n2;
            }
            CloserUtil.close((Object)samReader);
        }
        return histogram.size() > 0 ? histogram.getMode() : 0.0;
    }
}

