/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.filter.DuplicateReadFilter;
import htsjdk.samtools.filter.InsertSizeFilter;
import htsjdk.samtools.filter.NotPrimaryAlignmentFilter;
import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.reference.ReferenceSequenceFileWalker;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.CodeUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.ListMap;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.SamLocusIterator;
import htsjdk.samtools.util.SequenceUtil;
import htsjdk.samtools.util.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.Metrics;
import picard.util.DbSnpBitSetUtil;

@CommandLineProgramProperties(usage="Collects metrics quantifying the CpCG -> CpCA error rate from the provided SAM/BAM", usageShort="Collects metrics quantifying the CpCG -> CpCA error rate from the provided SAM/BAM", programGroup=Metrics.class)
public class CollectOxoGMetrics
extends CommandLineProgram {
    static final String USAGE = "Collects metrics quantifying the CpCG -> CpCA error rate from the provided SAM/BAM";
    @Option(shortName="I", doc="Input BAM file for analysis.")
    public File INPUT;
    @Option(shortName="O", doc="Location of output metrics file to write.")
    public File OUTPUT;
    @Option(shortName="R", doc="Reference sequence to which BAM is aligned.")
    public File REFERENCE_SEQUENCE;
    @Option(doc="An optional list of intervals to restrict analysis to.", optional=true)
    public File INTERVALS;
    @Option(doc="VCF format dbSNP file, used to exclude regions around known polymorphisms from analysis.", optional=true)
    public File DB_SNP;
    @Option(shortName="Q", doc="The minimum base quality score for a base to be included in analysis.")
    public int MINIMUM_QUALITY_SCORE = 20;
    @Option(shortName="MQ", doc="The minimum mapping quality score for a base to be included in analysis.")
    public int MINIMUM_MAPPING_QUALITY = 30;
    @Option(shortName="MIN_INS", doc="The minimum insert size for a read to be included in analysis. Set of 0 to allow unpaired reads.")
    public int MINIMUM_INSERT_SIZE = 60;
    @Option(shortName="MAX_INS", doc="The maximum insert size for a read to be included in analysis. Set of 0 to allow unpaired reads.")
    public int MAXIMUM_INSERT_SIZE = 600;
    @Option(doc="When available, use original quality scores for filtering.")
    public boolean USE_OQ = true;
    @Option(doc="The number of context bases to include on each side of the assayed G/C base.")
    public int CONTEXT_SIZE = 1;
    @Option(doc="The optional set of sequence contexts to restrict analysis to. If not supplied all contexts are analyzed.")
    public Set<String> CONTEXTS = new HashSet<String>();
    @Option(doc="For debugging purposes: stop after visiting this many sites with at least 1X coverage.")
    public int STOP_AFTER = Integer.MAX_VALUE;
    private final Log log = Log.getInstance(CollectOxoGMetrics.class);
    private static final String UNKNOWN_LIBRARY = "UnknownLibrary";
    private static final String UNKNOWN_SAMPLE = "UnknownSample";

    public static void main(String[] stringArray) {
        new CollectOxoGMetrics().instanceMainWithExit(stringArray);
    }

    @Override
    protected String[] customCommandLineValidation() {
        int n = 1 + 2 * this.CONTEXT_SIZE;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.CONTEXTS) {
            if (string.length() != n) {
                arrayList.add("Context " + string + " is not " + n + " long as implied by CONTEXT_SIZE=" + this.CONTEXT_SIZE);
                continue;
            }
            if (string.charAt(string.length() / 2) == 'C') continue;
            arrayList.add("Middle base of context sequence " + string + " must be C");
        }
        if (this.MINIMUM_INSERT_SIZE < 0) {
            arrayList.add("MINIMUM_INSERT_SIZE cannot be negative");
        }
        if (this.MAXIMUM_INSERT_SIZE < 0) {
            arrayList.add("MAXIMUM_INSERT_SIZE cannot be negative");
        }
        if (this.MAXIMUM_INSERT_SIZE < this.MINIMUM_INSERT_SIZE) {
            arrayList.add("MAXIMUM_INSERT_SIZE cannot be less than MINIMUM_INSERT_SIZE");
        }
        return arrayList.isEmpty() ? null : arrayList.toArray(new String[arrayList.size()]);
    }

    @Override
    protected int doWork() {
        Object object;
        Object object2;
        String string;
        SAMReadGroupRecord sAMReadGroupRecord22;
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        if (this.INTERVALS != null) {
            IOUtil.assertFileIsReadable((File)this.INTERVALS);
        }
        IOUtil.assertFileIsReadable((File)this.REFERENCE_SEQUENCE);
        ReferenceSequenceFileWalker referenceSequenceFileWalker = new ReferenceSequenceFileWalker(this.REFERENCE_SEQUENCE);
        SamReader samReader = SamReaderFactory.makeDefault().open(this.INPUT);
        HashSet<Object> hashSet = new HashSet<Object>();
        HashSet<Object> hashSet2 = new HashSet<Object>();
        if (samReader.getFileHeader().getReadGroups().isEmpty()) {
            throw new PicardException("This analysis requires a read group entry in the alignment file header");
        }
        for (SAMReadGroupRecord sAMReadGroupRecord22 : samReader.getFileHeader().getReadGroups()) {
            hashSet.add(CodeUtil.getOrElse((Object)sAMReadGroupRecord22.getSample(), (Object)UNKNOWN_SAMPLE));
            hashSet2.add(CodeUtil.getOrElse((Object)sAMReadGroupRecord22.getLibrary(), (Object)UNKNOWN_LIBRARY));
        }
        Set<String> set = this.CONTEXTS.isEmpty() ? this.makeContextStrings(this.CONTEXT_SIZE) : this.CONTEXTS;
        sAMReadGroupRecord22 = new ListMap();
        Object object3 = set.iterator();
        while (object3.hasNext()) {
            string = (String)object3.next();
            for (String string2 : hashSet2) {
                sAMReadGroupRecord22.add((Object)string, (Object)new Calculator(string2, string));
            }
        }
        this.log.info(new Object[]{"Loading dbSNP File: " + this.DB_SNP});
        object3 = this.DB_SNP != null ? new DbSnpBitSetUtil(this.DB_SNP, samReader.getFileHeader().getSequenceDictionary()) : null;
        if (this.INTERVALS != null) {
            object2 = IntervalList.fromFile((File)this.INTERVALS);
            string = new SamLocusIterator(samReader, object2.uniqued(), false);
        } else {
            string = new SamLocusIterator(samReader);
        }
        string.setEmitUncoveredLoci(false);
        string.setMappingQualityScoreCutoff(this.MINIMUM_MAPPING_QUALITY);
        object2 = new ArrayList();
        object2.add(new NotPrimaryAlignmentFilter());
        object2.add(new DuplicateReadFilter());
        if (this.MINIMUM_INSERT_SIZE > 0 || this.MAXIMUM_INSERT_SIZE > 0) {
            object2.add(new InsertSizeFilter(this.MINIMUM_INSERT_SIZE, this.MAXIMUM_INSERT_SIZE));
        }
        string.setSamFilters((List)object2);
        this.log.info(new Object[]{"Starting iteration."});
        long l = 0L;
        int n = 0;
        MetricsFile metricsFile = string.iterator();
        while (metricsFile.hasNext()) {
            long l2;
            byte by;
            SamLocusIterator.LocusInfo locusInfo = (SamLocusIterator.LocusInfo)metricsFile.next();
            Object object4 = locusInfo.getSequenceName();
            int n2 = locusInfo.getPosition();
            int n3 = n2 - 1;
            if (object3 != null && ((DbSnpBitSetUtil)object3).isDbSnpSite((String)object4, n2)) continue;
            object = referenceSequenceFileWalker.get(locusInfo.getSequenceIndex()).getBases();
            if (n2 < 3 || n2 > ((byte[])object).length - 3 || (by = StringUtil.toUpperCase((byte)object[n3])) != 67 && by != 71) continue;
            Object object5 = StringUtil.bytesToString((byte[])object, (int)(n3 - this.CONTEXT_SIZE), (int)(1 + 2 * this.CONTEXT_SIZE)).toUpperCase();
            Object object6 = by == 67 ? object5 : SequenceUtil.reverseComplement((String)object5);
            object5 = (List)sAMReadGroupRecord22.get(object6);
            if (object5 == null) continue;
            Iterator iterator = object5.iterator();
            while (iterator.hasNext()) {
                Calculator calculator = (Calculator)iterator.next();
                calculator.accept(locusInfo, by);
            }
            if (++n % 100 == 0 && (l2 = System.currentTimeMillis()) > l) {
                this.log.info(new Object[]{"Visited " + n + " sites of interest. Last site: " + (String)object4 + ":" + n2});
                l = l2 + 60000L;
            }
            if (n < this.STOP_AFTER) continue;
            break;
        }
        metricsFile = this.getMetricsFile();
        for (Object object4 : sAMReadGroupRecord22.values()) {
            Iterator iterator = object4.iterator();
            while (iterator.hasNext()) {
                Calculator calculator = (Calculator)iterator.next();
                object = (Object)calculator.finish();
                object.SAMPLE_ALIAS = StringUtil.join((String)",", new ArrayList(hashSet));
                metricsFile.addMetric((MetricBase)object);
            }
        }
        metricsFile.write(this.OUTPUT);
        CloserUtil.close((Object)samReader);
        return 0;
    }

    private Set<String> makeContextStrings(int n) {
        HashSet<String> hashSet = new HashSet<String>();
        for (byte[] byArray : SequenceUtil.generateAllKmers((int)(2 * n + 1))) {
            if (byArray[n] != 67) continue;
            hashSet.add(StringUtil.bytesToString((byte[])byArray));
        }
        this.log.info(new Object[]{"Generated " + hashSet.size() + " context strings."});
        return hashSet;
    }

    private class Calculator {
        private final String library;
        private final String context;
        int sites = 0;
        long refCcontrolA = 0L;
        long refCoxidatedA = 0L;
        long refCcontrolC = 0L;
        long refCoxidatedC = 0L;
        long refGcontrolA = 0L;
        long refGoxidatedA = 0L;
        long refGcontrolC = 0L;
        long refGoxidatedC = 0L;

        Calculator(String string, String string2) {
            this.library = string;
            this.context = string2;
        }

        void accept(SamLocusIterator.LocusInfo locusInfo, byte by) {
            Counts counts = this.computeAlleleFraction(locusInfo, by);
            if (counts.total() > 0) {
                ++this.sites;
                if (by == 67) {
                    this.refCcontrolA += (long)counts.controlA;
                    this.refCoxidatedA += (long)counts.oxidatedA;
                    this.refCcontrolC += (long)counts.controlC;
                    this.refCoxidatedC += (long)counts.oxidatedC;
                } else if (by == 71) {
                    this.refGcontrolA += (long)counts.controlA;
                    this.refGoxidatedA += (long)counts.oxidatedA;
                    this.refGcontrolC += (long)counts.controlC;
                    this.refGoxidatedC += (long)counts.oxidatedC;
                } else {
                    throw new IllegalStateException("Reference bases other than G and C not supported.");
                }
            }
        }

        CpcgMetrics finish() {
            CpcgMetrics cpcgMetrics = new CpcgMetrics();
            cpcgMetrics.LIBRARY = this.library;
            cpcgMetrics.CONTEXT = this.context;
            cpcgMetrics.TOTAL_SITES = this.sites;
            cpcgMetrics.TOTAL_BASES = this.refCcontrolC + this.refCoxidatedC + this.refCcontrolA + this.refCoxidatedA + this.refGcontrolC + this.refGoxidatedC + this.refGcontrolA + this.refGoxidatedA;
            cpcgMetrics.REF_OXO_BASES = this.refCoxidatedC + this.refGoxidatedC;
            cpcgMetrics.REF_NONOXO_BASES = this.refCcontrolC + this.refGcontrolC;
            cpcgMetrics.REF_TOTAL_BASES = cpcgMetrics.REF_OXO_BASES + cpcgMetrics.REF_NONOXO_BASES;
            cpcgMetrics.ALT_NONOXO_BASES = this.refCcontrolA + this.refGcontrolA;
            cpcgMetrics.ALT_OXO_BASES = this.refCoxidatedA + this.refGoxidatedA;
            cpcgMetrics.OXIDATION_ERROR_RATE = (double)Math.max(cpcgMetrics.ALT_OXO_BASES - cpcgMetrics.ALT_NONOXO_BASES, 1L) / (double)cpcgMetrics.TOTAL_BASES;
            cpcgMetrics.OXIDATION_Q = -10.0 * Math.log10(cpcgMetrics.OXIDATION_ERROR_RATE);
            cpcgMetrics.C_REF_REF_BASES = this.refCcontrolC + this.refCoxidatedC;
            cpcgMetrics.G_REF_REF_BASES = this.refGcontrolC + this.refGoxidatedC;
            cpcgMetrics.C_REF_ALT_BASES = this.refCcontrolA + this.refCoxidatedA;
            cpcgMetrics.G_REF_ALT_BASES = this.refGcontrolA + this.refGoxidatedA;
            double d = (double)cpcgMetrics.C_REF_ALT_BASES / (double)(cpcgMetrics.C_REF_ALT_BASES + cpcgMetrics.C_REF_REF_BASES);
            double d2 = (double)cpcgMetrics.G_REF_ALT_BASES / (double)(cpcgMetrics.G_REF_ALT_BASES + cpcgMetrics.G_REF_REF_BASES);
            cpcgMetrics.C_REF_OXO_ERROR_RATE = Math.max(d - d2, 1.0E-10);
            cpcgMetrics.G_REF_OXO_ERROR_RATE = Math.max(d2 - d, 1.0E-10);
            cpcgMetrics.C_REF_OXO_Q = -10.0 * Math.log10(cpcgMetrics.C_REF_OXO_ERROR_RATE);
            cpcgMetrics.G_REF_OXO_Q = -10.0 * Math.log10(cpcgMetrics.G_REF_OXO_ERROR_RATE);
            return cpcgMetrics;
        }

        private Counts computeAlleleFraction(SamLocusIterator.LocusInfo locusInfo, byte by) {
            Counts counts = new Counts();
            byte by2 = by == 67 ? (byte)65 : 84;
            for (SamLocusIterator.RecordAndOffset recordAndOffset : locusInfo.getRecordAndPositions()) {
                int n;
                byte[] byArray;
                SAMRecord sAMRecord = recordAndOffset.getRecord();
                byte by3 = CollectOxoGMetrics.this.USE_OQ ? ((byArray = sAMRecord.getOriginalBaseQualities()) != null ? byArray[recordAndOffset.getOffset()] : recordAndOffset.getBaseQuality()) : recordAndOffset.getBaseQuality();
                if (by3 < CollectOxoGMetrics.this.MINIMUM_QUALITY_SCORE || !this.library.equals(CodeUtil.getOrElse((Object)sAMRecord.getReadGroup().getLibrary(), (Object)CollectOxoGMetrics.UNKNOWN_LIBRARY))) continue;
                byte by4 = recordAndOffset.getReadBase();
                byte by5 = sAMRecord.getReadNegativeStrandFlag() ? SequenceUtil.complement((byte)by4) : by4;
                int n2 = n = sAMRecord.getReadPairedFlag() && sAMRecord.getSecondOfPairFlag() ? 2 : 1;
                if (by4 == by) {
                    if (by5 == 71 && n == 1) {
                        ++counts.oxidatedC;
                        continue;
                    }
                    if (by5 == 71 && n == 2) {
                        ++counts.controlC;
                        continue;
                    }
                    if (by5 == 67 && n == 1) {
                        ++counts.controlC;
                        continue;
                    }
                    if (by5 != 67 || n != 2) continue;
                    ++counts.oxidatedC;
                    continue;
                }
                if (by4 != by2) continue;
                if (by5 == 84 && n == 1) {
                    ++counts.oxidatedA;
                    continue;
                }
                if (by5 == 84 && n == 2) {
                    ++counts.controlA;
                    continue;
                }
                if (by5 == 65 && n == 1) {
                    ++counts.controlA;
                    continue;
                }
                if (by5 != 65 || n != 2) continue;
                ++counts.oxidatedA;
            }
            return counts;
        }
    }

    private static class Counts {
        int controlA;
        int oxidatedA;
        int controlC;
        int oxidatedC;

        private Counts() {
        }

        int total() {
            return this.controlC + this.oxidatedC + this.controlA + this.oxidatedA;
        }
    }

    public static final class CpcgMetrics
    extends MetricBase {
        public String SAMPLE_ALIAS;
        public String LIBRARY;
        public String CONTEXT;
        public int TOTAL_SITES;
        public long TOTAL_BASES;
        public long REF_NONOXO_BASES;
        public long REF_OXO_BASES;
        public long REF_TOTAL_BASES;
        public long ALT_NONOXO_BASES;
        public long ALT_OXO_BASES;
        public double OXIDATION_ERROR_RATE;
        public double OXIDATION_Q;
        public long C_REF_REF_BASES;
        public long G_REF_REF_BASES;
        public long C_REF_ALT_BASES;
        public long G_REF_ALT_BASES;
        public double C_REF_OXO_ERROR_RATE;
        public double C_REF_OXO_Q;
        public double G_REF_OXO_ERROR_RATE;
        public double G_REF_OXO_Q;
    }
}

