/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.filter.SecondaryAlignmentFilter;
import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.reference.ReferenceSequenceFileWalker;
import htsjdk.samtools.util.Histogram;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.samtools.util.SamLocusIterator;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import picard.analysis.CountingDuplicateFilter;
import picard.analysis.CountingFilter;
import picard.analysis.CountingMapQFilter;
import picard.analysis.CountingPairedFilter;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.Metrics;
import picard.util.MathUtil;

@CommandLineProgramProperties(usage="Computes a number of metrics that are useful for evaluating coverage and performance of whole genome sequencing experiments.", usageShort="Writes whole genome sequencing-related metrics for a SAM or BAM file", programGroup=Metrics.class)
public class CollectWgsMetrics
extends CommandLineProgram {
    @Option(shortName="I", doc="Input SAM or BAM file.")
    public File INPUT;
    @Option(shortName="O", doc="Output metrics file.")
    public File OUTPUT;
    @Option(shortName="R", doc="The reference sequence fasta aligned to.")
    public File REFERENCE_SEQUENCE;
    @Option(shortName="MQ", doc="Minimum mapping quality for a read to contribute coverage.", overridable=true)
    public int MINIMUM_MAPPING_QUALITY = 20;
    @Option(shortName="Q", doc="Minimum base quality for a base to contribute coverage.", overridable=true)
    public int MINIMUM_BASE_QUALITY = 20;
    @Option(shortName="CAP", doc="Treat bases with coverage exceeding this value as if they had coverage at this value.", overridable=true)
    public int COVERAGE_CAP = 250;
    @Option(doc="For debugging purposes, stop after processing this many genomic bases.")
    public long STOP_AFTER = -1L;
    @Option(doc="Determines whether to include the base quality histogram in the metrics file.")
    public boolean INCLUDE_BQ_HISTOGRAM = false;
    @Option(doc="If true, count unpaired reads, and paired reads with one end unmapped")
    public boolean COUNT_UNPAIRED = false;
    private final Log log = Log.getInstance(CollectWgsMetrics.class);

    public static void main(String[] stringArray) {
        new CollectWgsMetrics().instanceMainWithExit(stringArray);
    }

    @Override
    protected int doWork() {
        int n;
        SamLocusIterator.LocusInfo locusInfo;
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        IOUtil.assertFileIsReadable((File)this.REFERENCE_SEQUENCE);
        ProgressLogger progressLogger = new ProgressLogger(this.log, 10000000, "Processed", "loci");
        ReferenceSequenceFileWalker referenceSequenceFileWalker = new ReferenceSequenceFileWalker(this.REFERENCE_SEQUENCE);
        SamReader samReader = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE).open(this.INPUT);
        SamLocusIterator samLocusIterator = this.getLocusIterator(samReader);
        ArrayList<CountingFilter> arrayList = new ArrayList<CountingFilter>();
        CountingDuplicateFilter countingDuplicateFilter = new CountingDuplicateFilter();
        CountingMapQFilter countingMapQFilter = new CountingMapQFilter(this.MINIMUM_MAPPING_QUALITY);
        CountingPairedFilter countingPairedFilter = new CountingPairedFilter();
        arrayList.add(countingMapQFilter);
        arrayList.add(countingDuplicateFilter);
        if (!this.COUNT_UNPAIRED) {
            arrayList.add(countingPairedFilter);
        }
        arrayList.add((CountingFilter)new SecondaryAlignmentFilter());
        samLocusIterator.setSamFilters(arrayList);
        samLocusIterator.setEmitUncoveredLoci(true);
        samLocusIterator.setMappingQualityScoreCutoff(0);
        samLocusIterator.setQualityScoreCutoff(0);
        samLocusIterator.setIncludeNonPfReads(false);
        int n2 = this.COVERAGE_CAP;
        long[] lArray = new long[n2 + 1];
        long[] lArray2 = new long[127];
        boolean bl = this.STOP_AFTER > 0L;
        long l = this.STOP_AFTER - 1L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        while (samLocusIterator.hasNext()) {
            locusInfo = samLocusIterator.next();
            ReferenceSequence referenceSequence = referenceSequenceFileWalker.get(locusInfo.getSequenceIndex());
            n = referenceSequence.getBases()[locusInfo.getPosition() - 1];
            if (n == 78) continue;
            HashSet<String> hashSet = new HashSet<String>(locusInfo.getRecordAndPositions().size());
            int n3 = 0;
            for (SamLocusIterator.RecordAndOffset recordAndOffset : locusInfo.getRecordAndPositions()) {
                if (recordAndOffset.getBaseQuality() < this.MINIMUM_BASE_QUALITY) {
                    ++l3;
                    continue;
                }
                if (!hashSet.add(recordAndOffset.getRecord().getReadName())) {
                    ++l4;
                    continue;
                }
                if (++n3 > n2) continue;
                byte by = recordAndOffset.getRecord().getBaseQualities()[recordAndOffset.getOffset()];
                lArray2[by] = lArray2[by] + 1L;
            }
            int n4 = Math.min(hashSet.size(), n2);
            if (n4 < hashSet.size()) {
                l5 += (long)(hashSet.size() - n2);
            }
            int n5 = n4;
            lArray[n5] = lArray[n5] + 1L;
            progressLogger.record(locusInfo.getSequenceName(), locusInfo.getPosition());
            if (!bl || ++l2 <= l) continue;
            break;
        }
        locusInfo = new Histogram("coverage", "count");
        for (int i = 0; i < lArray.length; ++i) {
            locusInfo.increment((Comparable)Integer.valueOf(i), (double)lArray[i]);
        }
        Histogram histogram = new Histogram("value", "baseq_count");
        for (n = 0; n < lArray2.length; ++n) {
            histogram.increment((Comparable)Integer.valueOf(n), (double)lArray2[n]);
        }
        WgsMetrics wgsMetrics = this.generateWgsMetrics();
        wgsMetrics.GENOME_TERRITORY = (long)locusInfo.getSumOfValues();
        wgsMetrics.MEAN_COVERAGE = locusInfo.getMean();
        wgsMetrics.SD_COVERAGE = locusInfo.getStandardDeviation();
        wgsMetrics.MEDIAN_COVERAGE = locusInfo.getMedian();
        wgsMetrics.MAD_COVERAGE = locusInfo.getMedianAbsoluteDeviation();
        long l6 = this.getBasesExcludedBy(countingDuplicateFilter);
        long l7 = this.getBasesExcludedBy(countingMapQFilter);
        long l8 = this.getBasesExcludedBy(countingPairedFilter);
        double d = locusInfo.getSum();
        double d2 = d + (double)l6 + (double)l7 + (double)l8 + (double)l3 + (double)l4 + (double)l5;
        wgsMetrics.PCT_EXC_DUPE = (double)l6 / d2;
        wgsMetrics.PCT_EXC_MAPQ = (double)l7 / d2;
        wgsMetrics.PCT_EXC_UNPAIRED = (double)l8 / d2;
        wgsMetrics.PCT_EXC_BASEQ = (double)l3 / d2;
        wgsMetrics.PCT_EXC_OVERLAP = (double)l4 / d2;
        wgsMetrics.PCT_EXC_CAPPED = (double)l5 / d2;
        wgsMetrics.PCT_EXC_TOTAL = (d2 - d) / d2;
        wgsMetrics.PCT_1X = (double)MathUtil.sum(lArray, 1, lArray.length) / (double)wgsMetrics.GENOME_TERRITORY;
        wgsMetrics.PCT_5X = (double)MathUtil.sum(lArray, 5, lArray.length) / (double)wgsMetrics.GENOME_TERRITORY;
        wgsMetrics.PCT_10X = (double)MathUtil.sum(lArray, 10, lArray.length) / (double)wgsMetrics.GENOME_TERRITORY;
        wgsMetrics.PCT_15X = (double)MathUtil.sum(lArray, 15, lArray.length) / (double)wgsMetrics.GENOME_TERRITORY;
        wgsMetrics.PCT_20X = (double)MathUtil.sum(lArray, 20, lArray.length) / (double)wgsMetrics.GENOME_TERRITORY;
        wgsMetrics.PCT_25X = (double)MathUtil.sum(lArray, 25, lArray.length) / (double)wgsMetrics.GENOME_TERRITORY;
        wgsMetrics.PCT_30X = (double)MathUtil.sum(lArray, 30, lArray.length) / (double)wgsMetrics.GENOME_TERRITORY;
        wgsMetrics.PCT_40X = (double)MathUtil.sum(lArray, 40, lArray.length) / (double)wgsMetrics.GENOME_TERRITORY;
        wgsMetrics.PCT_50X = (double)MathUtil.sum(lArray, 50, lArray.length) / (double)wgsMetrics.GENOME_TERRITORY;
        wgsMetrics.PCT_60X = (double)MathUtil.sum(lArray, 60, lArray.length) / (double)wgsMetrics.GENOME_TERRITORY;
        wgsMetrics.PCT_70X = (double)MathUtil.sum(lArray, 70, lArray.length) / (double)wgsMetrics.GENOME_TERRITORY;
        wgsMetrics.PCT_80X = (double)MathUtil.sum(lArray, 80, lArray.length) / (double)wgsMetrics.GENOME_TERRITORY;
        wgsMetrics.PCT_90X = (double)MathUtil.sum(lArray, 90, lArray.length) / (double)wgsMetrics.GENOME_TERRITORY;
        wgsMetrics.PCT_100X = (double)MathUtil.sum(lArray, 100, lArray.length) / (double)wgsMetrics.GENOME_TERRITORY;
        MetricsFile metricsFile = this.getMetricsFile();
        metricsFile.addMetric((MetricBase)wgsMetrics);
        metricsFile.addHistogram((Histogram)locusInfo);
        if (this.INCLUDE_BQ_HISTOGRAM) {
            metricsFile.addHistogram(histogram);
        }
        metricsFile.write(this.OUTPUT);
        return 0;
    }

    protected WgsMetrics generateWgsMetrics() {
        return new WgsMetrics();
    }

    protected long getBasesExcludedBy(CountingFilter countingFilter) {
        return countingFilter.getFilteredBases();
    }

    protected SamLocusIterator getLocusIterator(SamReader samReader) {
        return new SamLocusIterator(samReader);
    }

    public static class WgsMetrics
    extends MetricBase {
        public long GENOME_TERRITORY;
        public double MEAN_COVERAGE;
        public double SD_COVERAGE;
        public double MEDIAN_COVERAGE;
        public double MAD_COVERAGE;
        public double PCT_EXC_MAPQ;
        public double PCT_EXC_DUPE;
        public double PCT_EXC_UNPAIRED;
        public double PCT_EXC_BASEQ;
        public double PCT_EXC_OVERLAP;
        public double PCT_EXC_CAPPED;
        public double PCT_EXC_TOTAL;
        public double PCT_1X;
        public double PCT_5X;
        public double PCT_10X;
        public double PCT_15X;
        public double PCT_20X;
        public double PCT_25X;
        public double PCT_30X;
        public double PCT_40X;
        public double PCT_50X;
        public double PCT_60X;
        public double PCT_70X;
        public double PCT_80X;
        public double PCT_90X;
        public double PCT_100X;
    }
}

