/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.PeekableIterator;
import htsjdk.samtools.util.ProgressLogger;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import picard.analysis.CollectWgsMetrics;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.Metrics;
import picard.util.QuerySortedReadPairIteratorUtil;

@CommandLineProgramProperties(usage="Computes a number of metrics that are useful for evaluating coverage and performance of sequencing experiments.", usageShort="Writes sequencing-related metrics for a SAM or BAM file", programGroup=Metrics.class)
public class CollectWgsMetricsFromQuerySorted
extends CommandLineProgram {
    @Option(shortName="I", doc="Input SAM or BAM file.")
    public File INPUT;
    @Option(shortName="O", doc="Output metrics file.")
    public File OUTPUT;
    @Option(shortName="MQ", doc="Minimum mapping quality for a read to contribute coverage.", overridable=true)
    public int MINIMUM_MAPPING_QUALITY = 20;
    @Option(shortName="Q", doc="Minimum base quality for a base to contribute coverage.", overridable=true)
    public int MINIMUM_BASE_QUALITY = 20;
    private final Log log = Log.getInstance(CollectWgsMetricsFromQuerySorted.class);

    public static void main(String[] stringArray) {
        new CollectWgsMetricsFromQuerySorted().instanceMainWithExit(stringArray);
    }

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        ProgressLogger progressLogger = new ProgressLogger(this.log, 50000000, "Processed", "read pairs");
        SamReader samReader = SamReaderFactory.makeDefault().open(this.INPUT);
        PeekableIterator peekableIterator = new PeekableIterator((Iterator)samReader.iterator());
        QuerySortedSeqMetrics querySortedSeqMetrics = new QuerySortedSeqMetrics();
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        double d = 0.0;
        QuerySortedReadPairIteratorUtil.ReadPair readPair = QuerySortedReadPairIteratorUtil.getNextReadPair((PeekableIterator<SAMRecord>)peekableIterator);
        while (readPair != null) {
            boolean bl = readPair.read2 != null;
            int n = readPair.read1.getReadLength();
            int n2 = bl ? readPair.read2.getReadLength() : 0;
            int n3 = n + n2;
            querySortedSeqMetrics.TOTAL_BASES += (long)n3;
            if (bl) {
                ++querySortedSeqMetrics.TOTAL_READ_PAIRS;
            }
            if (!bl || readPair.read1.getMateUnmappedFlag() || readPair.read2.getMateUnmappedFlag()) {
                l3 += (long)n3;
            } else if (readPair.read1.getDuplicateReadFlag()) {
                ++querySortedSeqMetrics.TOTAL_DUPE_PAIRS;
                l += (long)n3;
            } else {
                int n4;
                BaseExclusionHelper baseExclusionHelper = this.determineBaseExclusions(readPair.read1);
                BaseExclusionHelper baseExclusionHelper2 = this.determineBaseExclusions(readPair.read2);
                l2 += (long)(baseExclusionHelper.basesExcludedByMapq + baseExclusionHelper2.basesExcludedByMapq);
                l4 += (long)(baseExclusionHelper.lowBQcount + baseExclusionHelper2.lowBQcount);
                int n5 = n3;
                n5 -= baseExclusionHelper.basesExcludedByMapq + baseExclusionHelper.lowBQcount;
                n5 -= baseExclusionHelper2.basesExcludedByMapq + baseExclusionHelper2.lowBQcount;
                if (baseExclusionHelper.basesExcludedByMapq == 0 && baseExclusionHelper2.basesExcludedByMapq == 0) {
                    n4 = this.getOverlappingBaseCount(baseExclusionHelper, baseExclusionHelper2);
                    l5 += (long)n4;
                    n5 -= n4;
                }
                querySortedSeqMetrics.TOTAL_USABLE_BASES += (long)n5;
                n4 = Math.abs(readPair.read1.getInferredInsertSize());
                if (n4 > 0 && readPair.read1.getProperPairFlag()) {
                    ++querySortedSeqMetrics.TOTAL_ORIENTED_PAIRS;
                    d += (double)n4;
                }
            }
            progressLogger.record(readPair.read1);
            readPair = QuerySortedReadPairIteratorUtil.getNextReadPair((PeekableIterator<SAMRecord>)peekableIterator);
        }
        this.setUnusedMetrics(querySortedSeqMetrics);
        querySortedSeqMetrics.GENOME_TERRITORY = samReader.getFileHeader().getSequenceDictionary().getReferenceLength();
        querySortedSeqMetrics.MEAN_COVERAGE = (double)querySortedSeqMetrics.TOTAL_USABLE_BASES / (double)querySortedSeqMetrics.GENOME_TERRITORY;
        querySortedSeqMetrics.PCT_EXC_DUPE = (double)l / (double)querySortedSeqMetrics.TOTAL_BASES;
        querySortedSeqMetrics.PCT_EXC_MAPQ = (double)l2 / (double)querySortedSeqMetrics.TOTAL_BASES;
        querySortedSeqMetrics.PCT_EXC_UNPAIRED = (double)l3 / (double)querySortedSeqMetrics.TOTAL_BASES;
        querySortedSeqMetrics.PCT_EXC_BASEQ = (double)l4 / (double)querySortedSeqMetrics.TOTAL_BASES;
        querySortedSeqMetrics.PCT_EXC_OVERLAP = (double)l5 / (double)querySortedSeqMetrics.TOTAL_BASES;
        double d2 = querySortedSeqMetrics.TOTAL_BASES - querySortedSeqMetrics.TOTAL_USABLE_BASES;
        querySortedSeqMetrics.PCT_EXC_TOTAL = d2 / (double)querySortedSeqMetrics.TOTAL_BASES;
        querySortedSeqMetrics.MEAN_INSERT_SIZE = d / (double)querySortedSeqMetrics.TOTAL_ORIENTED_PAIRS;
        MetricsFile metricsFile = this.getMetricsFile();
        metricsFile.addMetric((MetricBase)querySortedSeqMetrics);
        metricsFile.write(this.OUTPUT);
        return 0;
    }

    private int getLowQualityOrSoftclipBaseCount(BaseExclusionHelper baseExclusionHelper) {
        byte[] byArray = baseExclusionHelper.read.getBaseQualities();
        int n = baseExclusionHelper.firstUnclippedBaseIndex + (byArray.length - baseExclusionHelper.firstTrailingClippedBaseIndex);
        for (int i = baseExclusionHelper.firstUnclippedBaseIndex; i < baseExclusionHelper.firstTrailingClippedBaseIndex; ++i) {
            if (byArray[i] >= this.MINIMUM_BASE_QUALITY) continue;
            ++n;
        }
        return n;
    }

    private void setUnusedMetrics(QuerySortedSeqMetrics querySortedSeqMetrics) {
        querySortedSeqMetrics.SD_COVERAGE = -1.0;
        querySortedSeqMetrics.MEDIAN_COVERAGE = -1.0;
        querySortedSeqMetrics.MAD_COVERAGE = -1.0;
        querySortedSeqMetrics.PCT_1X = -1.0;
        querySortedSeqMetrics.PCT_5X = -1.0;
        querySortedSeqMetrics.PCT_10X = -1.0;
        querySortedSeqMetrics.PCT_15X = -1.0;
        querySortedSeqMetrics.PCT_20X = -1.0;
        querySortedSeqMetrics.PCT_25X = -1.0;
        querySortedSeqMetrics.PCT_30X = -1.0;
        querySortedSeqMetrics.PCT_40X = -1.0;
        querySortedSeqMetrics.PCT_50X = -1.0;
        querySortedSeqMetrics.PCT_60X = -1.0;
        querySortedSeqMetrics.PCT_70X = -1.0;
        querySortedSeqMetrics.PCT_80X = -1.0;
        querySortedSeqMetrics.PCT_90X = -1.0;
        querySortedSeqMetrics.PCT_100X = -1.0;
        querySortedSeqMetrics.PCT_EXC_CAPPED = -1.0;
    }

    private int getOverlappingBaseCount(BaseExclusionHelper baseExclusionHelper, BaseExclusionHelper baseExclusionHelper2) {
        if (baseExclusionHelper2.read.getAlignmentStart() < baseExclusionHelper.read.getAlignmentStart()) {
            return this.getOverlappingBaseCount(baseExclusionHelper2, baseExclusionHelper);
        }
        if (baseExclusionHelper.read.getAlignmentEnd() < baseExclusionHelper2.read.getAlignmentStart() || !baseExclusionHelper.read.getReferenceIndex().equals(baseExclusionHelper2.read.getReferenceIndex())) {
            return 0;
        }
        byte[] byArray = baseExclusionHelper.read.getBaseQualities();
        byte[] byArray2 = baseExclusionHelper2.read.getBaseQualities();
        int n = baseExclusionHelper.read.getReadPositionAtReferencePosition(baseExclusionHelper2.read.getAlignmentStart(), true) - 1;
        int n2 = baseExclusionHelper.firstTrailingClippedBaseIndex - n;
        int n3 = Math.min(n2, baseExclusionHelper2.firstTrailingClippedBaseIndex - baseExclusionHelper2.firstUnclippedBaseIndex);
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            int n5 = baseExclusionHelper.firstTrailingClippedBaseIndex - n3 + i;
            int n6 = baseExclusionHelper2.firstUnclippedBaseIndex + i;
            if (byArray[n5] < this.MINIMUM_BASE_QUALITY || byArray2[n6] < this.MINIMUM_BASE_QUALITY) continue;
            ++n4;
        }
        return n4;
    }

    private BaseExclusionHelper determineBaseExclusions(SAMRecord sAMRecord) {
        BaseExclusionHelper baseExclusionHelper = new BaseExclusionHelper(sAMRecord);
        if (sAMRecord.getMappingQuality() < this.MINIMUM_MAPPING_QUALITY) {
            baseExclusionHelper.basesExcludedByMapq = sAMRecord.getReadLength();
        } else {
            baseExclusionHelper.lowBQcount = this.getLowQualityOrSoftclipBaseCount(baseExclusionHelper);
        }
        return baseExclusionHelper;
    }

    private static class BaseExclusionHelper {
        public SAMRecord read;
        public int firstUnclippedBaseIndex;
        public int firstTrailingClippedBaseIndex;
        public int basesExcludedByMapq = 0;
        public int lowBQcount = 0;

        public BaseExclusionHelper(SAMRecord sAMRecord) {
            CigarOperator cigarOperator;
            this.read = sAMRecord;
            List list = sAMRecord.getCigar().getCigarElements();
            this.firstUnclippedBaseIndex = 0;
            for (CigarElement cigarElement : list) {
                cigarOperator = cigarElement.getOperator();
                if (cigarOperator == CigarOperator.SOFT_CLIP) {
                    this.firstUnclippedBaseIndex = cigarElement.getLength();
                    continue;
                }
                if (cigarOperator == CigarOperator.HARD_CLIP) continue;
                break;
            }
            this.firstTrailingClippedBaseIndex = sAMRecord.getReadLength();
            for (int i = list.size() - 1; i >= 0; --i) {
                CigarElement cigarElement;
                cigarElement = (CigarElement)list.get(i);
                cigarOperator = cigarElement.getOperator();
                if (cigarOperator == CigarOperator.SOFT_CLIP) {
                    this.firstTrailingClippedBaseIndex -= cigarElement.getLength();
                    continue;
                }
                if (cigarOperator != CigarOperator.HARD_CLIP) break;
            }
        }
    }

    public static class QuerySortedSeqMetrics
    extends CollectWgsMetrics.WgsMetrics {
        public long TOTAL_BASES = 0L;
        public long TOTAL_USABLE_BASES = 0L;
        public long TOTAL_READ_PAIRS = 0L;
        public long TOTAL_DUPE_PAIRS = 0L;
        public long TOTAL_ORIENTED_PAIRS = 0L;
        public double MEAN_INSERT_SIZE = 0.0;
    }
}

