/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.util.Histogram;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.SequenceUtil;
import java.io.File;
import java.util.List;
import picard.PicardException;
import picard.analysis.SinglePassSamProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.Metrics;
import picard.util.RExecutor;

@CommandLineProgramProperties(usage="Program to chart quality score distributions in a SAM or BAM file.", usageShort="Charts quality score distributions for a SAM or BAM file", programGroup=Metrics.class)
public class QualityScoreDistribution
extends SinglePassSamProgram {
    @Option(shortName="CHART", doc="A file (with .pdf extension) to write the chart to.")
    public File CHART_OUTPUT;
    @Option(doc="If set to true calculate mean quality over aligned reads only.")
    public boolean ALIGNED_READS_ONLY = false;
    @Option(shortName="PF", doc="If set to true calculate mean quality over PF reads only.")
    public boolean PF_READS_ONLY = false;
    @Option(doc="If set to true, include quality for no-call bases in the distribution.")
    public boolean INCLUDE_NO_CALLS = false;
    private final long[] qCounts = new long[128];
    private final long[] oqCounts = new long[128];
    private String plotSubtitle = "";
    private final Log log = Log.getInstance(QualityScoreDistribution.class);

    public static void main(String[] stringArray) {
        System.exit(new QualityScoreDistribution().instanceMain(stringArray));
    }

    @Override
    protected void setup(SAMFileHeader sAMFileHeader, File file) {
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        IOUtil.assertFileIsWritable((File)this.CHART_OUTPUT);
        List list = sAMFileHeader.getReadGroups();
        if (list.size() == 1) {
            this.plotSubtitle = ((SAMReadGroupRecord)list.get(0)).getLibrary();
            if (null == this.plotSubtitle) {
                this.plotSubtitle = "";
            }
        }
    }

    @Override
    protected void acceptRead(SAMRecord sAMRecord, ReferenceSequence referenceSequence) {
        if (this.PF_READS_ONLY && sAMRecord.getReadFailsVendorQualityCheckFlag()) {
            return;
        }
        if (this.ALIGNED_READS_ONLY && sAMRecord.getReadUnmappedFlag()) {
            return;
        }
        if (sAMRecord.isSecondaryOrSupplementary()) {
            return;
        }
        byte[] byArray = sAMRecord.getReadBases();
        byte[] byArray2 = sAMRecord.getBaseQualities();
        byte[] byArray3 = sAMRecord.getOriginalBaseQualities();
        int n = byArray2.length;
        for (int i = 0; i < n; ++i) {
            if (!this.INCLUDE_NO_CALLS && SequenceUtil.isNoCall((byte)byArray[i])) continue;
            byte by = byArray2[i];
            this.qCounts[by] = this.qCounts[by] + 1L;
            if (byArray3 == null) continue;
            byte by2 = byArray3[i];
            this.oqCounts[by2] = this.oqCounts[by2] + 1L;
        }
    }

    @Override
    protected void finish() {
        Histogram histogram = new Histogram("QUALITY", "COUNT_OF_Q");
        Histogram histogram2 = new Histogram("QUALITY", "COUNT_OF_OQ");
        for (int i = 0; i < this.qCounts.length; ++i) {
            if (this.qCounts[i] > 0L) {
                histogram.increment((Comparable)Byte.valueOf((byte)i), (double)this.qCounts[i]);
            }
            if (this.oqCounts[i] <= 0L) continue;
            histogram2.increment((Comparable)Byte.valueOf((byte)i), (double)this.oqCounts[i]);
        }
        MetricsFile metricsFile = this.getMetricsFile();
        metricsFile.addHistogram(histogram);
        if (!histogram2.isEmpty()) {
            metricsFile.addHistogram(histogram2);
        }
        metricsFile.write(this.OUTPUT);
        if (histogram.isEmpty() && histogram2.isEmpty()) {
            this.log.warn(new Object[]{"No valid bases found in input file. No plot will be produced."});
        } else {
            int n = RExecutor.executeFromClasspath("picard/analysis/qualityScoreDistribution.R", this.OUTPUT.getAbsolutePath(), this.CHART_OUTPUT.getAbsolutePath(), this.INPUT.getName(), this.plotSubtitle);
            if (n != 0) {
                throw new PicardException("R script qualityScoreDistribution.R failed with return code " + n);
            }
        }
    }
}

