/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import htsjdk.samtools.AlignmentBlock;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.util.Histogram;
import htsjdk.samtools.util.SequenceUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import picard.analysis.CpgLocation;
import picard.analysis.MetricAccumulationLevel;
import picard.analysis.RrbsCpgDetailMetrics;
import picard.analysis.RrbsMetrics;
import picard.analysis.RrbsSummaryMetrics;
import picard.metrics.PerUnitMetricCollector;
import picard.metrics.SAMRecordAndReference;
import picard.metrics.SAMRecordAndReferenceMultiLevelCollector;

public class RrbsMetricsCollector
extends SAMRecordAndReferenceMultiLevelCollector<RrbsMetrics, Comparable<?>> {
    private final int minReadLength;
    private final double maxMismatchRate;
    private final int cQualityThreshold;
    private final int nextBaseQualityThreshold;

    public RrbsMetricsCollector(Set<MetricAccumulationLevel> set, List<SAMReadGroupRecord> list, int n, int n2, int n3, double d) {
        this.cQualityThreshold = n;
        this.nextBaseQualityThreshold = n2;
        this.minReadLength = n3;
        this.maxMismatchRate = d;
        this.setup(set, list);
    }

    @Override
    protected PerUnitMetricCollector<RrbsMetrics, Comparable<?>, SAMRecordAndReference> makeChildCollector(String string, String string2, String string3) {
        return new PerUnitRrbsMetricsCollector(string, string2, string3);
    }

    private byte[] getFragment(byte[] byArray, int n, int n2) {
        return Arrays.copyOfRange(byArray, n, n + n2);
    }

    private boolean isC(byte by, byte by2) {
        return SequenceUtil.basesEqual((byte)by, (byte)67) && SequenceUtil.bisulfiteBasesEqual((byte)by2, (byte)by);
    }

    private boolean isValidCpg(byte[] byArray, byte[] byArray2, byte[] byArray3, int n) {
        return this.isC(byArray[n], byArray2[n]) && SequenceUtil.basesEqual((byte)byArray[n + 1], (byte)byArray2[n + 1]) && this.isAboveCytoQcThreshold(byArray3, n);
    }

    private boolean isAboveCytoQcThreshold(byte[] byArray, int n) {
        return n < byArray.length - 1 && byArray[n] >= this.cQualityThreshold && byArray[n + 1] >= this.nextBaseQualityThreshold;
    }

    private int getCurRefIndex(int n, int n2, int n3, boolean bl) {
        return bl ? n + (n2 - 1) - n3 - 1 : n + n3;
    }

    private class PerUnitRrbsMetricsCollector
    implements PerUnitMetricCollector<RrbsMetrics, Comparable<?>, SAMRecordAndReference> {
        final String sample;
        final String library;
        final String readGroup;
        int nCytoConverted = 0;
        int nCytoTotal = 0;
        final Histogram<CpgLocation> cpgTotal = new Histogram();
        final Histogram<CpgLocation> cpgConverted = new Histogram();
        int mappedRecordCount = 0;
        int smallReadCount = 0;
        int mismatchCount = 0;
        int noCpgCount = 0;
        double cytoConversionRate;
        double cpgConversionRate;
        int nCpgSeen;
        int nCpgConverted;
        double coverageMean;
        int coverageMedian;

        public PerUnitRrbsMetricsCollector(String string, String string2, String string3) {
            this.sample = string;
            this.library = string2;
            this.readGroup = string3;
        }

        @Override
        public void acceptRecord(SAMRecordAndReference sAMRecordAndReference) {
            ++this.mappedRecordCount;
            SAMRecord sAMRecord = sAMRecordAndReference.getSamRecord();
            ReferenceSequence referenceSequence = sAMRecordAndReference.getReferenceSequence();
            byte[] byArray = sAMRecord.getReadBases();
            byte[] byArray2 = sAMRecord.getBaseQualities();
            byte[] byArray3 = referenceSequence.getBases();
            if (sAMRecord.getReadLength() < RrbsMetricsCollector.this.minReadLength) {
                ++this.smallReadCount;
                return;
            }
            if ((long)SequenceUtil.countMismatches((SAMRecord)sAMRecord, (byte[])byArray3, (boolean)true) > Math.round((double)sAMRecord.getReadLength() * RrbsMetricsCollector.this.maxMismatchRate)) {
                ++this.mismatchCount;
                return;
            }
            int n = 0;
            for (AlignmentBlock alignmentBlock : sAMRecord.getAlignmentBlocks()) {
                int n2 = alignmentBlock.getLength();
                int n3 = alignmentBlock.getReferenceStart() - 1;
                int n4 = alignmentBlock.getReadStart() - 1;
                byte[] byArray4 = RrbsMetricsCollector.this.getFragment(byArray3, n3, n2);
                byte[] byArray5 = RrbsMetricsCollector.this.getFragment(byArray, n4, n2);
                byte[] byArray6 = RrbsMetricsCollector.this.getFragment(byArray2, n4, n2);
                if (sAMRecord.getReadNegativeStrandFlag()) {
                    SequenceUtil.reverseComplement((byte[])byArray4);
                    SequenceUtil.reverseComplement((byte[])byArray5);
                    SequenceUtil.reverseQualities((byte[])byArray6);
                }
                for (int i = 0; i < n2 - 1; ++i) {
                    int n5 = RrbsMetricsCollector.this.getCurRefIndex(n3, n2, i, sAMRecord.getReadNegativeStrandFlag());
                    if (SequenceUtil.basesEqual((byte)byArray4[i], (byte)67) && SequenceUtil.basesEqual((byte)byArray4[i + 1], (byte)71)) {
                        if (RrbsMetricsCollector.this.isValidCpg(byArray4, byArray5, byArray6, i)) {
                            ++n;
                            CpgLocation cpgLocation = new CpgLocation(sAMRecord.getReferenceName(), n5);
                            this.cpgTotal.increment((Comparable)cpgLocation);
                            if (SequenceUtil.isBisulfiteConverted((byte)byArray5[i], (byte)byArray4[i])) {
                                this.cpgConverted.increment((Comparable)cpgLocation);
                            }
                        }
                        ++i;
                        continue;
                    }
                    if (!RrbsMetricsCollector.this.isC(byArray4[i], byArray5[i]) || !RrbsMetricsCollector.this.isAboveCytoQcThreshold(byArray2, i) || !SequenceUtil.bisulfiteBasesEqual((boolean)false, (byte)byArray5[i + 1], (byte)byArray4[i + 1])) continue;
                    ++this.nCytoTotal;
                    if (!SequenceUtil.isBisulfiteConverted((byte)byArray5[i], (byte)byArray4[i])) continue;
                    ++this.nCytoConverted;
                }
            }
            if (n == 0) {
                ++this.noCpgCount;
            }
        }

        @Override
        public void finish() {
            this.cytoConversionRate = this.nCytoTotal == 0 ? 0.0 : (double)this.nCytoConverted / (double)this.nCytoTotal;
            this.nCpgSeen = (int)this.cpgTotal.getSumOfValues();
            this.nCpgConverted = (int)this.cpgConverted.getSumOfValues();
            this.cpgConversionRate = this.nCpgSeen == 0 ? 0.0 : (double)this.nCpgConverted / (double)this.nCpgSeen;
            this.coverageMean = this.cpgTotal.getMeanBinSize();
            this.coverageMedian = (int)this.cpgTotal.getMedianBinSize();
        }

        @Override
        public void addMetricsToFile(MetricsFile<RrbsMetrics, Comparable<?>> metricsFile) {
            RrbsSummaryMetrics rrbsSummaryMetrics = this.buildSummaryMetrics();
            List<RrbsCpgDetailMetrics> list = this.buildDetailMetrics();
            RrbsMetrics rrbsMetrics = new RrbsMetrics(rrbsSummaryMetrics, list);
            metricsFile.addMetric((MetricBase)rrbsMetrics);
        }

        private RrbsSummaryMetrics buildSummaryMetrics() {
            RrbsSummaryMetrics rrbsSummaryMetrics = new RrbsSummaryMetrics();
            rrbsSummaryMetrics.SAMPLE = this.sample;
            rrbsSummaryMetrics.READ_GROUP = this.readGroup;
            rrbsSummaryMetrics.LIBRARY = this.library;
            rrbsSummaryMetrics.READS_ALIGNED = this.mappedRecordCount;
            rrbsSummaryMetrics.NON_CPG_BASES = this.nCytoTotal;
            rrbsSummaryMetrics.NON_CPG_CONVERTED_BASES = this.nCytoConverted;
            rrbsSummaryMetrics.PCT_NON_CPG_BASES_CONVERTED = this.cytoConversionRate;
            rrbsSummaryMetrics.CPG_BASES_SEEN = this.nCpgSeen;
            rrbsSummaryMetrics.CPG_BASES_CONVERTED = this.nCpgConverted;
            rrbsSummaryMetrics.PCT_CPG_BASES_CONVERTED = this.cpgConversionRate;
            rrbsSummaryMetrics.MEAN_CPG_COVERAGE = this.coverageMean;
            rrbsSummaryMetrics.MEDIAN_CPG_COVERAGE = this.coverageMedian;
            rrbsSummaryMetrics.READS_IGNORED_SHORT = this.smallReadCount;
            rrbsSummaryMetrics.READS_WITH_NO_CPG = this.noCpgCount;
            rrbsSummaryMetrics.READS_IGNORED_MISMATCHES = this.mismatchCount;
            return rrbsSummaryMetrics;
        }

        private List<RrbsCpgDetailMetrics> buildDetailMetrics() {
            ArrayList<RrbsCpgDetailMetrics> arrayList = new ArrayList<RrbsCpgDetailMetrics>();
            for (CpgLocation cpgLocation : this.cpgTotal.keySet()) {
                RrbsCpgDetailMetrics rrbsCpgDetailMetrics = new RrbsCpgDetailMetrics();
                rrbsCpgDetailMetrics.SAMPLE = this.sample;
                rrbsCpgDetailMetrics.READ_GROUP = this.readGroup;
                rrbsCpgDetailMetrics.LIBRARY = this.library;
                rrbsCpgDetailMetrics.SEQUENCE_NAME = cpgLocation.getSequence();
                rrbsCpgDetailMetrics.POSITION = cpgLocation.getPosition();
                rrbsCpgDetailMetrics.TOTAL_SITES = (int)((Histogram.Bin)this.cpgTotal.get((Object)cpgLocation)).getValue();
                rrbsCpgDetailMetrics.CONVERTED_SITES = this.cpgConverted.containsKey((Object)cpgLocation) ? (int)((Histogram.Bin)this.cpgConverted.get((Object)cpgLocation)).getValue() : 0;
                rrbsCpgDetailMetrics.PCT_CONVERTED = rrbsCpgDetailMetrics.CONVERTED_SITES == 0 ? 0.0 : (double)rrbsCpgDetailMetrics.CONVERTED_SITES.intValue() / (double)rrbsCpgDetailMetrics.TOTAL_SITES.intValue();
                arrayList.add(rrbsCpgDetailMetrics);
            }
            return arrayList;
        }
    }
}

